package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The relationships for the Create Package request
 */
@Generated(from = "_PackageRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class PackageRelationships extends org.cloudfoundry.client.v3.packages._PackageRelationships {
  private final ToOneRelationship application;

  private PackageRelationships(PackageRelationships.Builder builder) {
    this.application = builder.application;
  }

  /**
   * The application relationship
   */
  @JsonProperty("app")
  @Override
  public ToOneRelationship getApplication() {
    return application;
  }

  /**
   * This instance is equal to all instances of {@code PackageRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof PackageRelationships
        && equalTo((PackageRelationships) another);
  }

  private boolean equalTo(PackageRelationships another) {
    return application.equals(another.application);
  }

  /**
   * Computes a hash code from attributes: {@code application}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + application.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PackageRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PackageRelationships{"
        + "application=" + application
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_PackageRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.packages._PackageRelationships {
    ToOneRelationship application;
    @JsonProperty("app")
    public void setApplication(ToOneRelationship application) {
      this.application = application;
    }
    @Override
    public ToOneRelationship getApplication() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static PackageRelationships fromJson(Json json) {
    PackageRelationships.Builder builder = PackageRelationships.builder();
    if (json.application != null) {
      builder.application(json.application);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link PackageRelationships PackageRelationships}.
   * <pre>
   * PackageRelationships.builder()
   *    .application(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link PackageRelationships#getApplication() application}
   *    .build();
   * </pre>
   * @return A new PackageRelationships builder
   */
  public static PackageRelationships.Builder builder() {
    return new PackageRelationships.Builder();
  }

  /**
   * Builds instances of type {@link PackageRelationships PackageRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_PackageRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship application;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PackageRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PackageRelationships instance) {
      return from((_PackageRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _PackageRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_PackageRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      application(instance.getApplication());
      return this;
    }

    /**
     * Initializes the value for the {@link PackageRelationships#getApplication() application} attribute.
     * @param application The value for application 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app")
    public final Builder application(ToOneRelationship application) {
      this.application = Objects.requireNonNull(application, "application");
      initBits &= ~INIT_BIT_APPLICATION;
      return this;
    }

    /**
     * Builds a new {@link PackageRelationships PackageRelationships}.
     * @return An immutable instance of PackageRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PackageRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PackageRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION) != 0) attributes.add("application");
      return "Cannot build PackageRelationships, some of required attributes are not set " + attributes;
    }
  }
}
