package org.cloudfoundry.client.v3.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Route operation
 */
@Generated(from = "_DeleteRouteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteRouteRequest extends org.cloudfoundry.client.v3.routes._DeleteRouteRequest {
  private final String routeId;

  private DeleteRouteRequest(DeleteRouteRequest.Builder builder) {
    this.routeId = builder.routeId;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteRouteRequest
        && equalTo((DeleteRouteRequest) another);
  }

  private boolean equalTo(DeleteRouteRequest another) {
    return routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteRouteRequest{"
        + "routeId=" + routeId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteRouteRequest DeleteRouteRequest}.
   * <pre>
   * DeleteRouteRequest.builder()
   *    .routeId(String) // required {@link DeleteRouteRequest#getRouteId() routeId}
   *    .build();
   * </pre>
   * @return A new DeleteRouteRequest builder
   */
  public static DeleteRouteRequest.Builder builder() {
    return new DeleteRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteRouteRequest DeleteRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteRouteRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private long initBits = 0x1L;

    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteRouteRequest instance) {
      return from((_DeleteRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      routeId(instance.getRouteId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteRouteRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteRouteRequest DeleteRouteRequest}.
     * @return An immutable instance of DeleteRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build DeleteRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
