package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Metadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Metadata.builder()}.
 */
@Generated(from = "_Metadata", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Metadata extends org.cloudfoundry.logcache.v1._Metadata {
  private final Long count;
  private final Long expired;
  private final Long newestTimestamp;
  private final Long oldestTimestamp;

  private Metadata(Metadata.Builder builder) {
    this.count = builder.count;
    this.expired = builder.expired;
    this.newestTimestamp = builder.newestTimestamp;
    this.oldestTimestamp = builder.oldestTimestamp;
  }

  /**
   * The number of envelopes held in Log Cache
   */
  @JsonProperty("count")
  @Override
  public Long getCount() {
    return count;
  }

  /**
   * The number of envelopes that have been pruned
   */
  @JsonProperty("expired")
  @Override
  public Optional<Long> getExpired() {
    return Optional.ofNullable(expired);
  }

  /**
   * Newest entry for the source, in nanoseconds since the Unix epoch
   */
  @JsonProperty("newestTimestamp")
  @Override
  public Long getNewestTimestamp() {
    return newestTimestamp;
  }

  /**
   * Oldest entry for the source, in nanoseconds since the Unix epoch
   */
  @JsonProperty("oldestTimestamp")
  @Override
  public Long getOldestTimestamp() {
    return oldestTimestamp;
  }

  /**
   * This instance is equal to all instances of {@code Metadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Metadata
        && equalTo((Metadata) another);
  }

  private boolean equalTo(Metadata another) {
    return count.equals(another.count)
        && Objects.equals(expired, another.expired)
        && newestTimestamp.equals(another.newestTimestamp)
        && oldestTimestamp.equals(another.oldestTimestamp);
  }

  /**
   * Computes a hash code from attributes: {@code count}, {@code expired}, {@code newestTimestamp}, {@code oldestTimestamp}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + count.hashCode();
    h += (h << 5) + Objects.hashCode(expired);
    h += (h << 5) + newestTimestamp.hashCode();
    h += (h << 5) + oldestTimestamp.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Metadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Metadata{");
    builder.append("count=").append(count);
    if (expired != null) {
      builder.append(", ");
      builder.append("expired=").append(expired);
    }
    builder.append(", ");
    builder.append("newestTimestamp=").append(newestTimestamp);
    builder.append(", ");
    builder.append("oldestTimestamp=").append(oldestTimestamp);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Metadata", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._Metadata {
    Long count;
    Optional<Long> expired = Optional.empty();
    Long newestTimestamp;
    Long oldestTimestamp;
    @JsonProperty("count")
    public void setCount(Long count) {
      this.count = count;
    }
    @JsonProperty("expired")
    public void setExpired(Optional<Long> expired) {
      this.expired = expired;
    }
    @JsonProperty("newestTimestamp")
    public void setNewestTimestamp(Long newestTimestamp) {
      this.newestTimestamp = newestTimestamp;
    }
    @JsonProperty("oldestTimestamp")
    public void setOldestTimestamp(Long oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp;
    }
    @Override
    public Long getCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Long> getExpired() { throw new UnsupportedOperationException(); }
    @Override
    public Long getNewestTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Long getOldestTimestamp() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Metadata fromJson(Json json) {
    Metadata.Builder builder = Metadata.builder();
    if (json.count != null) {
      builder.count(json.count);
    }
    if (json.expired != null) {
      builder.expired(json.expired);
    }
    if (json.newestTimestamp != null) {
      builder.newestTimestamp(json.newestTimestamp);
    }
    if (json.oldestTimestamp != null) {
      builder.oldestTimestamp(json.oldestTimestamp);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Metadata Metadata}.
   * <pre>
   * Metadata.builder()
   *    .count(Long) // required {@link Metadata#getCount() count}
   *    .expired(Long) // optional {@link Metadata#getExpired() expired}
   *    .newestTimestamp(Long) // required {@link Metadata#getNewestTimestamp() newestTimestamp}
   *    .oldestTimestamp(Long) // required {@link Metadata#getOldestTimestamp() oldestTimestamp}
   *    .build();
   * </pre>
   * @return A new Metadata builder
   */
  public static Metadata.Builder builder() {
    return new Metadata.Builder();
  }

  /**
   * Builds instances of type {@link Metadata Metadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Metadata", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_COUNT = 0x1L;
    private static final long INIT_BIT_NEWEST_TIMESTAMP = 0x2L;
    private static final long INIT_BIT_OLDEST_TIMESTAMP = 0x4L;
    private long initBits = 0x7L;

    private Long count;
    private Long expired;
    private Long newestTimestamp;
    private Long oldestTimestamp;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Metadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Metadata instance) {
      return from((_Metadata) instance);
    }

    /**
     * Copy abstract value type {@code _Metadata} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Metadata instance) {
      Objects.requireNonNull(instance, "instance");
      count(instance.getCount());
      Optional<Long> expiredOptional = instance.getExpired();
      if (expiredOptional.isPresent()) {
        expired(expiredOptional);
      }
      newestTimestamp(instance.getNewestTimestamp());
      oldestTimestamp(instance.getOldestTimestamp());
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getCount() count} attribute.
     * @param count The value for count 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("count")
    public final Builder count(Long count) {
      this.count = Objects.requireNonNull(count, "count");
      initBits &= ~INIT_BIT_COUNT;
      return this;
    }

    /**
     * Initializes the optional value {@link Metadata#getExpired() expired} to expired.
     * @param expired The value for expired
     * @return {@code this} builder for chained invocation
     */
    public final Builder expired(long expired) {
      this.expired = expired;
      return this;
    }

    /**
     * Initializes the optional value {@link Metadata#getExpired() expired} to expired.
     * @param expired The value for expired
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("expired")
    public final Builder expired(Optional<Long> expired) {
      this.expired = expired.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getNewestTimestamp() newestTimestamp} attribute.
     * @param newestTimestamp The value for newestTimestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("newestTimestamp")
    public final Builder newestTimestamp(Long newestTimestamp) {
      this.newestTimestamp = Objects.requireNonNull(newestTimestamp, "newestTimestamp");
      initBits &= ~INIT_BIT_NEWEST_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getOldestTimestamp() oldestTimestamp} attribute.
     * @param oldestTimestamp The value for oldestTimestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("oldestTimestamp")
    public final Builder oldestTimestamp(Long oldestTimestamp) {
      this.oldestTimestamp = Objects.requireNonNull(oldestTimestamp, "oldestTimestamp");
      initBits &= ~INIT_BIT_OLDEST_TIMESTAMP;
      return this;
    }

    /**
     * Builds a new {@link Metadata Metadata}.
     * @return An immutable instance of Metadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Metadata build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Metadata(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COUNT) != 0) attributes.add("count");
      if ((initBits & INIT_BIT_NEWEST_TIMESTAMP) != 0) attributes.add("newestTimestamp");
      if ((initBits & INIT_BIT_OLDEST_TIMESTAMP) != 0) attributes.add("oldestTimestamp");
      return "Cannot build Metadata, some of required attributes are not set " + attributes;
    }
  }
}
