package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the get token by client credentials operation
 */
@Generated(from = "_GetTokenByClientCredentialsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetTokenByClientCredentialsRequest
    extends org.cloudfoundry.uaa.tokens._GetTokenByClientCredentialsRequest {
  private final String clientId;
  private final String clientSecret;
  private final @Nullable TokenFormat tokenFormat;

  private GetTokenByClientCredentialsRequest(GetTokenByClientCredentialsRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.clientSecret = builder.clientSecret;
    this.tokenFormat = builder.tokenFormat;
  }

  /**
   * The client identifier
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The client's secret passphrase
   */
  @Override
  public String getClientSecret() {
    return clientSecret;
  }

  /**
   * The token format
   */
  @Override
  public @Nullable TokenFormat getTokenFormat() {
    return tokenFormat;
  }

  /**
   * This instance is equal to all instances of {@code GetTokenByClientCredentialsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTokenByClientCredentialsRequest
        && equalTo((GetTokenByClientCredentialsRequest) another);
  }

  private boolean equalTo(GetTokenByClientCredentialsRequest another) {
    return clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret)
        && Objects.equals(tokenFormat, another.tokenFormat);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code clientSecret}, {@code tokenFormat}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + clientSecret.hashCode();
    h += (h << 5) + Objects.hashCode(tokenFormat);
    return h;
  }

  /**
   * Prints the immutable value {@code GetTokenByClientCredentialsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTokenByClientCredentialsRequest{"
        + "clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", tokenFormat=" + tokenFormat
        + "}";
  }

  /**
   * Creates a builder for {@link GetTokenByClientCredentialsRequest GetTokenByClientCredentialsRequest}.
   * <pre>
   * GetTokenByClientCredentialsRequest.builder()
   *    .clientId(String) // required {@link GetTokenByClientCredentialsRequest#getClientId() clientId}
   *    .clientSecret(String) // required {@link GetTokenByClientCredentialsRequest#getClientSecret() clientSecret}
   *    .tokenFormat(org.cloudfoundry.uaa.tokens.TokenFormat | null) // nullable {@link GetTokenByClientCredentialsRequest#getTokenFormat() tokenFormat}
   *    .build();
   * </pre>
   * @return A new GetTokenByClientCredentialsRequest builder
   */
  public static GetTokenByClientCredentialsRequest.Builder builder() {
    return new GetTokenByClientCredentialsRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetTokenByClientCredentialsRequest GetTokenByClientCredentialsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetTokenByClientCredentialsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_CLIENT_SECRET = 0x2L;
    private long initBits = 0x3L;

    private String clientId;
    private String clientSecret;
    private TokenFormat tokenFormat;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTokenByClientCredentialsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTokenByClientCredentialsRequest instance) {
      return from((_GetTokenByClientCredentialsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetTokenByClientCredentialsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetTokenByClientCredentialsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      clientSecret(instance.getClientSecret());
      TokenFormat tokenFormatValue = instance.getTokenFormat();
      if (tokenFormatValue != null) {
        tokenFormat(tokenFormatValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByClientCredentialsRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByClientCredentialsRequest#getClientSecret() clientSecret} attribute.
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      initBits &= ~INIT_BIT_CLIENT_SECRET;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByClientCredentialsRequest#getTokenFormat() tokenFormat} attribute.
     * @param tokenFormat The value for tokenFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenFormat(@Nullable TokenFormat tokenFormat) {
      this.tokenFormat = tokenFormat;
      return this;
    }

    /**
     * Builds a new {@link GetTokenByClientCredentialsRequest GetTokenByClientCredentialsRequest}.
     * @return An immutable instance of GetTokenByClientCredentialsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTokenByClientCredentialsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTokenByClientCredentialsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_CLIENT_SECRET) != 0) attributes.add("clientSecret");
      return "Cannot build GetTokenByClientCredentialsRequest, some of required attributes are not set " + attributes;
    }
  }
}
