package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * A checksum payload
 */
@Generated(from = "_Checksum", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Checksum extends org.cloudfoundry.client.v3._Checksum {
  private final @Nullable ChecksumType type;
  private final @Nullable String value;

  private Checksum(Checksum.Builder builder) {
    this.type = builder.type;
    this.value = builder.value;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable ChecksumType getType() {
    return type;
  }

  /**
   * The value
   */
  @JsonProperty("value")
  @Override
  public @Nullable String getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code Checksum} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Checksum
        && equalTo((Checksum) another);
  }

  private boolean equalTo(Checksum another) {
    return Objects.equals(type, another.type)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code Checksum} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Checksum{"
        + "type=" + type
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Checksum", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._Checksum {
    ChecksumType type;
    String value;
    @JsonProperty("type")
    public void setType(@Nullable ChecksumType type) {
      this.type = type;
    }
    @JsonProperty("value")
    public void setValue(@Nullable String value) {
      this.value = value;
    }
    @Override
    public ChecksumType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Checksum fromJson(Json json) {
    Checksum.Builder builder = Checksum.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Checksum Checksum}.
   * <pre>
   * Checksum.builder()
   *    .type(org.cloudfoundry.client.v3.ChecksumType | null) // nullable {@link Checksum#getType() type}
   *    .value(String | null) // nullable {@link Checksum#getValue() value}
   *    .build();
   * </pre>
   * @return A new Checksum builder
   */
  public static Checksum.Builder builder() {
    return new Checksum.Builder();
  }

  /**
   * Builds instances of type {@link Checksum Checksum}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Checksum", generator = "Immutables")
  public static final class Builder {
    private ChecksumType type;
    private String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Checksum} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Checksum instance) {
      return from((_Checksum) instance);
    }

    /**
     * Copy abstract value type {@code _Checksum} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Checksum instance) {
      Objects.requireNonNull(instance, "instance");
      ChecksumType typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      String valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Checksum#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable ChecksumType type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link Checksum#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link Checksum Checksum}.
     * @return An immutable instance of Checksum
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Checksum build() {
      return new Checksum(this);
    }
  }
}
