package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Data type for the Kpack
 */
@Generated(from = "_KpackData", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class KpackData extends org.cloudfoundry.client.v3._KpackData {
  private final @Nullable List<String> buildpacks;

  private KpackData(KpackData.Builder builder) {
    this.buildpacks = builder.buildpacks == null ? null : createUnmodifiableList(true, builder.buildpacks);
  }

  /**
   * The buildpack
   */
  @JsonProperty("buildpacks")
  @Override
  public @Nullable List<String> getBuildpacks() {
    return buildpacks;
  }

  /**
   * This instance is equal to all instances of {@code KpackData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof KpackData
        && equalTo((KpackData) another);
  }

  private boolean equalTo(KpackData another) {
    return Objects.equals(buildpacks, another.buildpacks);
  }

  /**
   * Computes a hash code from attributes: {@code buildpacks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(buildpacks);
    return h;
  }

  /**
   * Prints the immutable value {@code KpackData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "KpackData{"
        + "buildpacks=" + buildpacks
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_KpackData", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._KpackData {
    List<String> buildpacks = null;
    @JsonProperty("buildpacks")
    public void setBuildpacks(@Nullable List<String> buildpacks) {
      this.buildpacks = buildpacks;
    }
    @Override
    public List<String> getBuildpacks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static KpackData fromJson(Json json) {
    KpackData.Builder builder = KpackData.builder();
    if (json.buildpacks != null) {
      builder.addAllBuildpacks(json.buildpacks);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link KpackData KpackData}.
   * <pre>
   * KpackData.builder()
   *    .buildpacks(List&amp;lt;String&amp;gt; | null) // nullable {@link KpackData#getBuildpacks() buildpacks}
   *    .build();
   * </pre>
   * @return A new KpackData builder
   */
  public static KpackData.Builder builder() {
    return new KpackData.Builder();
  }

  /**
   * Builds instances of type {@link KpackData KpackData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_KpackData", generator = "Immutables")
  public static final class Builder {
    private List<String> buildpacks = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code KpackData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(KpackData instance) {
      return from((_KpackData) instance);
    }

    /**
     * Copy abstract value type {@code _KpackData} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_KpackData instance) {
      Objects.requireNonNull(instance, "instance");
      List<String> buildpacksValue = instance.getBuildpacks();
      if (buildpacksValue != null) {
        addAllBuildpacks(buildpacksValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link KpackData#getBuildpacks() buildpacks} list.
     * @param element A buildpacks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(String element) {
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<String>();
      }
      this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      return this;
    }

    /**
     * Adds elements to {@link KpackData#getBuildpacks() buildpacks} list.
     * @param elements An array of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpacks(String... elements) {
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<String>();
      }
      for (String element : elements) {
        this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link KpackData#getBuildpacks() buildpacks} list.
     * @param elements An iterable of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("buildpacks")
    public final Builder buildpacks(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.buildpacks = null;
        return this;
      }
      this.buildpacks = new ArrayList<String>();
      return addAllBuildpacks(elements);
    }

    /**
     * Adds elements to {@link KpackData#getBuildpacks() buildpacks} list.
     * @param elements An iterable of buildpacks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBuildpacks(Iterable<String> elements) {
      Objects.requireNonNull(elements, "buildpacks element");
      if (this.buildpacks == null) {
        this.buildpacks = new ArrayList<String>();
      }
      for (String element : elements) {
        this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
      }
      return this;
    }

    /**
     * Builds a new {@link KpackData KpackData}.
     * @return An immutable instance of KpackData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public KpackData build() {
      return new KpackData(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
