package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v3.Link;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _UpdateApplicationEnvironmentVariablesResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateApplicationEnvironmentVariablesResponse.builder()}.
 */
@Generated(from = "_UpdateApplicationEnvironmentVariablesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateApplicationEnvironmentVariablesResponse
    extends org.cloudfoundry.client.v3.applications._UpdateApplicationEnvironmentVariablesResponse {
  private final Map<String, Link> links;
  private final Map<String, String> vars;

  private UpdateApplicationEnvironmentVariablesResponse(UpdateApplicationEnvironmentVariablesResponse.Builder builder) {
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.vars = createUnmodifiableMap(false, false, builder.vars);
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The application's environment variables
   */
  @JsonProperty("var")
  @Override
  public Map<String, String> getVars() {
    return vars;
  }

  /**
   * This instance is equal to all instances of {@code UpdateApplicationEnvironmentVariablesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateApplicationEnvironmentVariablesResponse
        && equalTo((UpdateApplicationEnvironmentVariablesResponse) another);
  }

  private boolean equalTo(UpdateApplicationEnvironmentVariablesResponse another) {
    return links.equals(another.links)
        && vars.equals(another.vars);
  }

  /**
   * Computes a hash code from attributes: {@code links}, {@code vars}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + links.hashCode();
    h += (h << 5) + vars.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateApplicationEnvironmentVariablesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateApplicationEnvironmentVariablesResponse{"
        + "links=" + links
        + ", vars=" + vars
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateApplicationEnvironmentVariablesResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.applications._UpdateApplicationEnvironmentVariablesResponse {
    Map<String, Link> links = Collections.emptyMap();
    Map<String, String> vars = Collections.emptyMap();
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("var")
    public void setVars(Map<String, String> vars) {
      this.vars = vars;
    }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getVars() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateApplicationEnvironmentVariablesResponse fromJson(Json json) {
    UpdateApplicationEnvironmentVariablesResponse.Builder builder = UpdateApplicationEnvironmentVariablesResponse.builder();
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.vars != null) {
      builder.putAllVars(json.vars);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateApplicationEnvironmentVariablesResponse UpdateApplicationEnvironmentVariablesResponse}.
   * <pre>
   * UpdateApplicationEnvironmentVariablesResponse.builder()
   *    .link|putAllLinks(String =&gt; org.cloudfoundry.client.v3.Link) // {@link UpdateApplicationEnvironmentVariablesResponse#getLinks() links} mappings
   *    .var|putAllVars(String =&gt; String) // {@link UpdateApplicationEnvironmentVariablesResponse#getVars() vars} mappings
   *    .build();
   * </pre>
   * @return A new UpdateApplicationEnvironmentVariablesResponse builder
   */
  public static UpdateApplicationEnvironmentVariablesResponse.Builder builder() {
    return new UpdateApplicationEnvironmentVariablesResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateApplicationEnvironmentVariablesResponse UpdateApplicationEnvironmentVariablesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateApplicationEnvironmentVariablesResponse", generator = "Immutables")
  public static final class Builder {
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private Map<String, String> vars = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.applications.EnvironmentVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EnvironmentVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateApplicationEnvironmentVariablesResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateApplicationEnvironmentVariablesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateApplicationEnvironmentVariablesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateApplicationEnvironmentVariablesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof EnvironmentVariables) {
        EnvironmentVariables instance = (EnvironmentVariables) object;
        putAllLinks(instance.getLinks());
        putAllVars(instance.getVars());
      }
    }

    /**
     * Put one entry to the {@link UpdateApplicationEnvironmentVariablesResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UpdateApplicationEnvironmentVariablesResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UpdateApplicationEnvironmentVariablesResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UpdateApplicationEnvironmentVariablesResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link UpdateApplicationEnvironmentVariablesResponse#getVars() vars} map.
     * @param key The key in the vars map
     * @param value The associated value in the vars map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder var(String key, String value) {
      this.vars.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UpdateApplicationEnvironmentVariablesResponse#getVars() vars} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder var(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.vars.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UpdateApplicationEnvironmentVariablesResponse#getVars() vars} map. Nulls are not permitted
     * @param entries The entries that will be added to the vars map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("var")
    public final Builder vars(Map<String, ? extends String> entries) {
      this.vars.clear();
      return putAllVars(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UpdateApplicationEnvironmentVariablesResponse#getVars() vars} map. Nulls are not permitted
     * @param entries The entries that will be added to the vars map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVars(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.vars.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateApplicationEnvironmentVariablesResponse UpdateApplicationEnvironmentVariablesResponse}.
     * @return An immutable instance of UpdateApplicationEnvironmentVariablesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateApplicationEnvironmentVariablesResponse build() {
      return new UpdateApplicationEnvironmentVariablesResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
