package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Deployment operation
 */
@Generated(from = "_GetDeploymentResponse", generator = "Immutables")
@SuppressWarnings({"all", "deprecation"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetDeploymentResponse extends org.cloudfoundry.client.v3.deployments._GetDeploymentResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final @Nullable ToOneRelationship application;
  private final @Nullable Relationship droplet;
  private final @Nullable Metadata metadata;
  private final @Nullable List<Process> newProcesses;
  private final @Nullable Relationship previousDroplet;
  private final @Nullable DeploymentRelationships relationships;
  private final @Nullable Revision revision;
  private final @Nullable DeploymentState state;
  private final @Nullable Status status;
  private final @Nullable DeploymentStrategy strategy;

  private GetDeploymentResponse(GetDeploymentResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.application = builder.application;
    this.droplet = builder.droplet;
    this.metadata = builder.metadata;
    this.newProcesses = builder.newProcesses == null ? null : createUnmodifiableList(true, builder.newProcesses);
    this.previousDroplet = builder.previousDroplet;
    this.relationships = builder.relationships;
    this.revision = builder.revision;
    this.state = builder.state;
    this.status = builder.status;
    this.strategy = builder.strategy;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The application the deployment is updating
   */
  @JsonProperty("app")
  @Override
  public @Nullable ToOneRelationship getApplication() {
    return application;
  }

  /**
   * The droplet the deployment is transitioning the app to
   */
  @JsonProperty("droplet")
  @Override
  public @Nullable Relationship getDroplet() {
    return droplet;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The revision the deployment is transitioning the app to
   */
  @JsonProperty("new_processes")
  @Override
  public @Nullable List<Process> getNewProcesses() {
    return newProcesses;
  }

  /**
   * The app’s current droplet before the deployment was created
   */
  @JsonProperty("previous_droplet")
  @Override
  public @Nullable Relationship getPreviousDroplet() {
    return previousDroplet;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable DeploymentRelationships getRelationships() {
    return relationships;
  }

  /**
   * The revision the deployment is transitioning the app to
   */
  @JsonProperty("revision")
  @Override
  public @Nullable Revision getRevision() {
    return revision;
  }

  /**
   * The state of the deployment
   */
  @JsonProperty("state")
  @Deprecated
  @Override
  public @Nullable DeploymentState getState() {
    return state;
  }

  /**
   * The status of the deployment
   */
  @JsonProperty("status")
  @Override
  public @Nullable Status getStatus() {
    return status;
  }

  /**
   * The strategy of the deployment
   */
  @JsonProperty("strategy")
  @Override
  public @Nullable DeploymentStrategy getStrategy() {
    return strategy;
  }

  /**
   * This instance is equal to all instances of {@code GetDeploymentResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetDeploymentResponse
        && equalTo((GetDeploymentResponse) another);
  }

  private boolean equalTo(GetDeploymentResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(application, another.application)
        && Objects.equals(droplet, another.droplet)
        && Objects.equals(metadata, another.metadata)
        && Objects.equals(newProcesses, another.newProcesses)
        && Objects.equals(previousDroplet, another.previousDroplet)
        && Objects.equals(relationships, another.relationships)
        && Objects.equals(revision, another.revision)
        && Objects.equals(state, another.state)
        && Objects.equals(status, another.status)
        && Objects.equals(strategy, another.strategy);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code application}, {@code droplet}, {@code metadata}, {@code newProcesses}, {@code previousDroplet}, {@code relationships}, {@code revision}, {@code state}, {@code status}, {@code strategy}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(application);
    h += (h << 5) + Objects.hashCode(droplet);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + Objects.hashCode(newProcesses);
    h += (h << 5) + Objects.hashCode(previousDroplet);
    h += (h << 5) + Objects.hashCode(relationships);
    h += (h << 5) + Objects.hashCode(revision);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(strategy);
    return h;
  }

  /**
   * Prints the immutable value {@code GetDeploymentResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetDeploymentResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", application=" + application
        + ", droplet=" + droplet
        + ", metadata=" + metadata
        + ", newProcesses=" + newProcesses
        + ", previousDroplet=" + previousDroplet
        + ", relationships=" + relationships
        + ", revision=" + revision
        + ", state=" + state
        + ", status=" + status
        + ", strategy=" + strategy
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetDeploymentResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.deployments._GetDeploymentResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    ToOneRelationship application;
    Relationship droplet;
    Metadata metadata;
    List<Process> newProcesses = null;
    Relationship previousDroplet;
    DeploymentRelationships relationships;
    Revision revision;
    DeploymentState state;
    Status status;
    DeploymentStrategy strategy;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("app")
    public void setApplication(@Nullable ToOneRelationship application) {
      this.application = application;
    }
    @JsonProperty("droplet")
    public void setDroplet(@Nullable Relationship droplet) {
      this.droplet = droplet;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("new_processes")
    public void setNewProcesses(@Nullable List<Process> newProcesses) {
      this.newProcesses = newProcesses;
    }
    @JsonProperty("previous_droplet")
    public void setPreviousDroplet(@Nullable Relationship previousDroplet) {
      this.previousDroplet = previousDroplet;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable DeploymentRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("revision")
    public void setRevision(@Nullable Revision revision) {
      this.revision = revision;
    }
    @JsonProperty("state")
    public void setState(@Nullable DeploymentState state) {
      this.state = state;
    }
    @JsonProperty("status")
    public void setStatus(@Nullable Status status) {
      this.status = status;
    }
    @JsonProperty("strategy")
    public void setStrategy(@Nullable DeploymentStrategy strategy) {
      this.strategy = strategy;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public ToOneRelationship getApplication() { throw new UnsupportedOperationException(); }
    @Override
    public Relationship getDroplet() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public List<Process> getNewProcesses() { throw new UnsupportedOperationException(); }
    @Override
    public Relationship getPreviousDroplet() { throw new UnsupportedOperationException(); }
    @Override
    public DeploymentRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public Revision getRevision() { throw new UnsupportedOperationException(); }
    @Override
    public DeploymentState getState() { throw new UnsupportedOperationException(); }
    @Override
    public Status getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public DeploymentStrategy getStrategy() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetDeploymentResponse fromJson(Json json) {
    GetDeploymentResponse.Builder builder = GetDeploymentResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.application != null) {
      builder.application(json.application);
    }
    if (json.droplet != null) {
      builder.droplet(json.droplet);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.newProcesses != null) {
      builder.addAllNewProcesses(json.newProcesses);
    }
    if (json.previousDroplet != null) {
      builder.previousDroplet(json.previousDroplet);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.revision != null) {
      builder.revision(json.revision);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.strategy != null) {
      builder.strategy(json.strategy);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetDeploymentResponse GetDeploymentResponse}.
   * <pre>
   * GetDeploymentResponse.builder()
   *    .createdAt(String) // required {@link GetDeploymentResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetDeploymentResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link GetDeploymentResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetDeploymentResponse#getUpdatedAt() updatedAt}
   *    .application(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link GetDeploymentResponse#getApplication() application}
   *    .droplet(org.cloudfoundry.client.v3.Relationship | null) // nullable {@link GetDeploymentResponse#getDroplet() droplet}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link GetDeploymentResponse#getMetadata() metadata}
   *    .newProcesses(List&amp;lt;Process&amp;gt; | null) // nullable {@link GetDeploymentResponse#getNewProcesses() newProcesses}
   *    .previousDroplet(org.cloudfoundry.client.v3.Relationship | null) // nullable {@link GetDeploymentResponse#getPreviousDroplet() previousDroplet}
   *    .relationships(org.cloudfoundry.client.v3.deployments.DeploymentRelationships | null) // nullable {@link GetDeploymentResponse#getRelationships() relationships}
   *    .revision(org.cloudfoundry.client.v3.deployments.Revision | null) // nullable {@link GetDeploymentResponse#getRevision() revision}
   *    .state(org.cloudfoundry.client.v3.deployments.DeploymentState | null) // nullable {@link GetDeploymentResponse#getState() state}
   *    .status(org.cloudfoundry.client.v3.deployments.Status | null) // nullable {@link GetDeploymentResponse#getStatus() status}
   *    .strategy(org.cloudfoundry.client.v3.deployments.DeploymentStrategy | null) // nullable {@link GetDeploymentResponse#getStrategy() strategy}
   *    .build();
   * </pre>
   * @return A new GetDeploymentResponse builder
   */
  public static GetDeploymentResponse.Builder builder() {
    return new GetDeploymentResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetDeploymentResponse GetDeploymentResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetDeploymentResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private long initBits = 0x3L;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private ToOneRelationship application;
    private Relationship droplet;
    private Metadata metadata;
    private List<Process> newProcesses = null;
    private Relationship previousDroplet;
    private DeploymentRelationships relationships;
    private Revision revision;
    private DeploymentState state;
    private Status status;
    private DeploymentStrategy strategy;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.deployments.Deployment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Deployment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetDeploymentResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetDeploymentResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetDeploymentResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetDeploymentResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Deployment) {
        Deployment instance = (Deployment) object;
        DeploymentRelationships relationshipsValue = instance.getRelationships();
        if (relationshipsValue != null) {
          relationships(relationshipsValue);
        }
        Metadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
          metadata(metadataValue);
        }
        Relationship dropletValue = instance.getDroplet();
        if (dropletValue != null) {
          droplet(dropletValue);
        }
        ToOneRelationship applicationValue = instance.getApplication();
        if (applicationValue != null) {
          application(applicationValue);
        }
        List<Process> newProcessesValue = instance.getNewProcesses();
        if (newProcessesValue != null) {
          addAllNewProcesses(newProcessesValue);
        }
        DeploymentState stateValue = instance.getState();
        if (stateValue != null) {
          state(stateValue);
        }
        DeploymentStrategy strategyValue = instance.getStrategy();
        if (strategyValue != null) {
          strategy(strategyValue);
        }
        Revision revisionValue = instance.getRevision();
        if (revisionValue != null) {
          revision(revisionValue);
        }
        Relationship previousDropletValue = instance.getPreviousDroplet();
        if (previousDropletValue != null) {
          previousDroplet(previousDropletValue);
        }
        Status statusValue = instance.getStatus();
        if (statusValue != null) {
          status(statusValue);
        }
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetDeploymentResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetDeploymentResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetDeploymentResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetDeploymentResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getApplication() application} attribute.
     * @param application The value for application (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app")
    public final Builder application(@Nullable ToOneRelationship application) {
      this.application = application;
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getDroplet() droplet} attribute.
     * @param droplet The value for droplet (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("droplet")
    public final Builder droplet(@Nullable Relationship droplet) {
      this.droplet = droplet;
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Adds one element to {@link GetDeploymentResponse#getNewProcesses() newProcesses} list.
     * @param element A newProcesses element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder newProcesse(Process element) {
      if (this.newProcesses == null) {
        this.newProcesses = new ArrayList<Process>();
      }
      this.newProcesses.add(Objects.requireNonNull(element, "newProcesses element"));
      return this;
    }

    /**
     * Adds elements to {@link GetDeploymentResponse#getNewProcesses() newProcesses} list.
     * @param elements An array of newProcesses elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder newProcesses(Process... elements) {
      if (this.newProcesses == null) {
        this.newProcesses = new ArrayList<Process>();
      }
      for (Process element : elements) {
        this.newProcesses.add(Objects.requireNonNull(element, "newProcesses element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetDeploymentResponse#getNewProcesses() newProcesses} list.
     * @param elements An iterable of newProcesses elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("new_processes")
    public final Builder newProcesses(@Nullable Iterable<? extends Process> elements) {
      if (elements == null) {
        this.newProcesses = null;
        return this;
      }
      this.newProcesses = new ArrayList<Process>();
      return addAllNewProcesses(elements);
    }

    /**
     * Adds elements to {@link GetDeploymentResponse#getNewProcesses() newProcesses} list.
     * @param elements An iterable of newProcesses elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNewProcesses(Iterable<? extends Process> elements) {
      Objects.requireNonNull(elements, "newProcesses element");
      if (this.newProcesses == null) {
        this.newProcesses = new ArrayList<Process>();
      }
      for (Process element : elements) {
        this.newProcesses.add(Objects.requireNonNull(element, "newProcesses element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getPreviousDroplet() previousDroplet} attribute.
     * @param previousDroplet The value for previousDroplet (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("previous_droplet")
    public final Builder previousDroplet(@Nullable Relationship previousDroplet) {
      this.previousDroplet = previousDroplet;
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(@Nullable DeploymentRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getRevision() revision} attribute.
     * @param revision The value for revision (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("revision")
    public final Builder revision(@Nullable Revision revision) {
      this.revision = revision;
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    @Deprecated
    public final Builder state(@Nullable DeploymentState state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(@Nullable Status status) {
      this.status = status;
      return this;
    }

    /**
     * Initializes the value for the {@link GetDeploymentResponse#getStrategy() strategy} attribute.
     * @param strategy The value for strategy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("strategy")
    public final Builder strategy(@Nullable DeploymentStrategy strategy) {
      this.strategy = strategy;
      return this;
    }

    /**
     * Builds a new {@link GetDeploymentResponse GetDeploymentResponse}.
     * @return An immutable instance of GetDeploymentResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetDeploymentResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetDeploymentResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build GetDeploymentResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
