package org.cloudfoundry.client.v3.packages;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.resourcematch.MatchedResource;
import org.immutables.value.Generated;

/**
 * The request payload for the Upload Package operation
 */
@Generated(from = "_UploadPackageRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UploadPackageRequest extends org.cloudfoundry.client.v3.packages._UploadPackageRequest {
  private final @Nullable List<MatchedResource> resources;
  private final @Nullable Path bits;
  private final String packageId;

  private UploadPackageRequest(UploadPackageRequest.Builder builder) {
    this.resources = builder.resources == null ? null : createUnmodifiableList(true, builder.resources);
    this.bits = builder.bits;
    this.packageId = builder.packageId;
  }

  /**
   * The resources
   */
  @Override
  public @Nullable List<MatchedResource> getResources() {
    return resources;
  }

  /**
   * The bits
   */
  @Override
  public @Nullable Path getBits() {
    return bits;
  }

  /**
   * The package id
   */
  @Override
  public String getPackageId() {
    return packageId;
  }

  /**
   * This instance is equal to all instances of {@code UploadPackageRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UploadPackageRequest
        && equalTo((UploadPackageRequest) another);
  }

  private boolean equalTo(UploadPackageRequest another) {
    return Objects.equals(resources, another.resources)
        && Objects.equals(bits, another.bits)
        && packageId.equals(another.packageId);
  }

  /**
   * Computes a hash code from attributes: {@code resources}, {@code bits}, {@code packageId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(resources);
    h += (h << 5) + Objects.hashCode(bits);
    h += (h << 5) + packageId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UploadPackageRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UploadPackageRequest{"
        + "resources=" + resources
        + ", bits=" + bits
        + ", packageId=" + packageId
        + "}";
  }

  private static UploadPackageRequest validate(UploadPackageRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link UploadPackageRequest UploadPackageRequest}.
   * <pre>
   * UploadPackageRequest.builder()
   *    .resources(List&amp;lt;org.cloudfoundry.client.v3.resourcematch.MatchedResource&amp;gt; | null) // nullable {@link UploadPackageRequest#getResources() resources}
   *    .bits(java.nio.file.Path | null) // nullable {@link UploadPackageRequest#getBits() bits}
   *    .packageId(String) // required {@link UploadPackageRequest#getPackageId() packageId}
   *    .build();
   * </pre>
   * @return A new UploadPackageRequest builder
   */
  public static UploadPackageRequest.Builder builder() {
    return new UploadPackageRequest.Builder();
  }

  /**
   * Builds instances of type {@link UploadPackageRequest UploadPackageRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UploadPackageRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PACKAGE_ID = 0x1L;
    private long initBits = 0x1L;

    private List<MatchedResource> resources = null;
    private Path bits;
    private String packageId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UploadPackageRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UploadPackageRequest instance) {
      return from((_UploadPackageRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UploadPackageRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UploadPackageRequest instance) {
      Objects.requireNonNull(instance, "instance");
      List<MatchedResource> resourcesValue = instance.getResources();
      if (resourcesValue != null) {
        addAllResources(resourcesValue);
      }
      Path bitsValue = instance.getBits();
      if (bitsValue != null) {
        bits(bitsValue);
      }
      packageId(instance.getPackageId());
      return this;
    }

    /**
     * Adds one element to {@link UploadPackageRequest#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(MatchedResource element) {
      if (this.resources == null) {
        this.resources = new ArrayList<MatchedResource>();
      }
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link UploadPackageRequest#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(MatchedResource... elements) {
      if (this.resources == null) {
        this.resources = new ArrayList<MatchedResource>();
      }
      for (MatchedResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UploadPackageRequest#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(@Nullable Iterable<? extends MatchedResource> elements) {
      if (elements == null) {
        this.resources = null;
        return this;
      }
      this.resources = new ArrayList<MatchedResource>();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link UploadPackageRequest#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends MatchedResource> elements) {
      Objects.requireNonNull(elements, "resources element");
      if (this.resources == null) {
        this.resources = new ArrayList<MatchedResource>();
      }
      for (MatchedResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UploadPackageRequest#getBits() bits} attribute.
     * @param bits The value for bits (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bits(@Nullable Path bits) {
      this.bits = bits;
      return this;
    }

    /**
     * Initializes the value for the {@link UploadPackageRequest#getPackageId() packageId} attribute.
     * @param packageId The value for packageId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String packageId) {
      this.packageId = Objects.requireNonNull(packageId, "packageId");
      initBits &= ~INIT_BIT_PACKAGE_ID;
      return this;
    }

    /**
     * Builds a new {@link UploadPackageRequest UploadPackageRequest}.
     * @return An immutable instance of UploadPackageRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UploadPackageRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return UploadPackageRequest.validate(new UploadPackageRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PACKAGE_ID) != 0) attributes.add("packageId");
      return "Cannot build UploadPackageRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
