package org.cloudfoundry.client.v3.resourcematch;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Checksum;
import org.immutables.value.Generated;

/**
 * A resource used for matching or has been matched
 */
@Generated(from = "_MatchedResource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class MatchedResource extends org.cloudfoundry.client.v3.resourcematch._MatchedResource {
  private final @Nullable Checksum checksum;
  private final @Nullable String mode;
  private final @Nullable String path;
  private final @Nullable Integer size;

  private MatchedResource(MatchedResource.Builder builder) {
    this.checksum = builder.checksum;
    this.mode = builder.mode;
    this.path = builder.path;
    this.size = builder.size;
  }

  /**
   * The hash
   */
  @JsonProperty("checksum")
  @Override
  public @Nullable Checksum getChecksum() {
    return checksum;
  }

  /**
   * The POSIX file mode in an octal representation
   */
  @JsonProperty("mode")
  @Override
  public @Nullable String getMode() {
    return mode;
  }

  /**
   * The path relative to app root
   */
  @JsonProperty("path")
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The size
   */
  @JsonProperty("size_in_bytes")
  @Override
  public @Nullable Integer getSize() {
    return size;
  }

  /**
   * This instance is equal to all instances of {@code MatchedResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MatchedResource
        && equalTo((MatchedResource) another);
  }

  private boolean equalTo(MatchedResource another) {
    return Objects.equals(checksum, another.checksum)
        && Objects.equals(mode, another.mode)
        && Objects.equals(path, another.path)
        && Objects.equals(size, another.size);
  }

  /**
   * Computes a hash code from attributes: {@code checksum}, {@code mode}, {@code path}, {@code size}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(checksum);
    h += (h << 5) + Objects.hashCode(mode);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(size);
    return h;
  }

  /**
   * Prints the immutable value {@code MatchedResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MatchedResource{"
        + "checksum=" + checksum
        + ", mode=" + mode
        + ", path=" + path
        + ", size=" + size
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_MatchedResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.resourcematch._MatchedResource {
    Checksum checksum;
    String mode;
    String path;
    Integer size;
    @JsonProperty("checksum")
    public void setChecksum(@Nullable Checksum checksum) {
      this.checksum = checksum;
    }
    @JsonProperty("mode")
    public void setMode(@Nullable String mode) {
      this.mode = mode;
    }
    @JsonProperty("path")
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty("size_in_bytes")
    public void setSize(@Nullable Integer size) {
      this.size = size;
    }
    @Override
    public Checksum getChecksum() { throw new UnsupportedOperationException(); }
    @Override
    public String getMode() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getSize() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static MatchedResource fromJson(Json json) {
    MatchedResource.Builder builder = MatchedResource.builder();
    if (json.checksum != null) {
      builder.checksum(json.checksum);
    }
    if (json.mode != null) {
      builder.mode(json.mode);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.size != null) {
      builder.size(json.size);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link MatchedResource MatchedResource}.
   * <pre>
   * MatchedResource.builder()
   *    .checksum(org.cloudfoundry.client.v3.Checksum | null) // nullable {@link MatchedResource#getChecksum() checksum}
   *    .mode(String | null) // nullable {@link MatchedResource#getMode() mode}
   *    .path(String | null) // nullable {@link MatchedResource#getPath() path}
   *    .size(Integer | null) // nullable {@link MatchedResource#getSize() size}
   *    .build();
   * </pre>
   * @return A new MatchedResource builder
   */
  public static MatchedResource.Builder builder() {
    return new MatchedResource.Builder();
  }

  /**
   * Builds instances of type {@link MatchedResource MatchedResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_MatchedResource", generator = "Immutables")
  public static final class Builder {
    private Checksum checksum;
    private String mode;
    private String path;
    private Integer size;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MatchedResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MatchedResource instance) {
      return from((_MatchedResource) instance);
    }

    /**
     * Copy abstract value type {@code _MatchedResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_MatchedResource instance) {
      Objects.requireNonNull(instance, "instance");
      Checksum checksumValue = instance.getChecksum();
      if (checksumValue != null) {
        checksum(checksumValue);
      }
      String modeValue = instance.getMode();
      if (modeValue != null) {
        mode(modeValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer sizeValue = instance.getSize();
      if (sizeValue != null) {
        size(sizeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MatchedResource#getChecksum() checksum} attribute.
     * @param checksum The value for checksum (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("checksum")
    public final Builder checksum(@Nullable Checksum checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link MatchedResource#getMode() mode} attribute.
     * @param mode The value for mode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mode")
    public final Builder mode(@Nullable String mode) {
      this.mode = mode;
      return this;
    }

    /**
     * Initializes the value for the {@link MatchedResource#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("path")
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link MatchedResource#getSize() size} attribute.
     * @param size The value for size (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("size_in_bytes")
    public final Builder size(@Nullable Integer size) {
      this.size = size;
      return this;
    }

    /**
     * Builds a new {@link MatchedResource MatchedResource}.
     * @return An immutable instance of MatchedResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MatchedResource build() {
      return new MatchedResource(this);
    }
  }
}
