package org.cloudfoundry.client.v3.roles;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Role operation
 */
@Generated(from = "_GetRoleResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetRoleResponse extends org.cloudfoundry.client.v3.roles._GetRoleResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final RoleRelationships relationships;
  private final RoleType type;

  private GetRoleResponse(GetRoleResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.relationships = builder.relationships;
    this.type = builder.type;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * Relationships of the role
   */
  @JsonProperty("relationships")
  @Override
  public RoleRelationships getRelationships() {
    return relationships;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public RoleType getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code GetRoleResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetRoleResponse
        && equalTo((GetRoleResponse) another);
  }

  private boolean equalTo(GetRoleResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && relationships.equals(another.relationships)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code relationships}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetRoleResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetRoleResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", relationships=" + relationships
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetRoleResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.roles._GetRoleResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    RoleRelationships relationships;
    RoleType type;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("relationships")
    public void setRelationships(RoleRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("type")
    public void setType(RoleType type) {
      this.type = type;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public RoleRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public RoleType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetRoleResponse fromJson(Json json) {
    GetRoleResponse.Builder builder = GetRoleResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetRoleResponse GetRoleResponse}.
   * <pre>
   * GetRoleResponse.builder()
   *    .createdAt(String) // required {@link GetRoleResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetRoleResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link GetRoleResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetRoleResponse#getUpdatedAt() updatedAt}
   *    .relationships(org.cloudfoundry.client.v3.roles.RoleRelationships) // required {@link GetRoleResponse#getRelationships() relationships}
   *    .type(org.cloudfoundry.client.v3.roles.RoleType) // required {@link GetRoleResponse#getType() type}
   *    .build();
   * </pre>
   * @return A new GetRoleResponse builder
   */
  public static GetRoleResponse.Builder builder() {
    return new GetRoleResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetRoleResponse GetRoleResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetRoleResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private RoleRelationships relationships;
    private RoleType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.roles.Role} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Role instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetRoleResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetRoleResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetRoleResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetRoleResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
      if (object instanceof Role) {
        Role instance = (Role) object;
        type(instance.getType());
        relationships(instance.getRelationships());
      }
    }

    /**
     * Initializes the value for the {@link GetRoleResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRoleResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetRoleResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetRoleResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetRoleResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetRoleResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetRoleResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRoleResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(RoleRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRoleResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(RoleType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link GetRoleResponse GetRoleResponse}.
     * @return An immutable instance of GetRoleResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetRoleResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetRoleResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build GetRoleResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
