package org.cloudfoundry.client.v3.servicebrokers;

import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _UpdateServiceBrokerResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateServiceBrokerResponse.builder()}.
 */
@Generated(from = "_UpdateServiceBrokerResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceBrokerResponse
    extends org.cloudfoundry.client.v3.servicebrokers._UpdateServiceBrokerResponse {
  private final String jobId;
  private final ServiceBrokerResource serviceBroker;

  private UpdateServiceBrokerResponse(UpdateServiceBrokerResponse.Builder builder) {
    this.jobId = builder.jobId;
    this.serviceBroker = builder.serviceBroker;
  }

  /**
   * @return The value of the {@code jobId} attribute
   */
  @Override
  public Optional<String> jobId() {
    return Optional.ofNullable(jobId);
  }

  /**
   * @return The value of the {@code serviceBroker} attribute
   */
  @Override
  public Optional<ServiceBrokerResource> serviceBroker() {
    return Optional.ofNullable(serviceBroker);
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceBrokerResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceBrokerResponse
        && equalTo((UpdateServiceBrokerResponse) another);
  }

  private boolean equalTo(UpdateServiceBrokerResponse another) {
    return Objects.equals(jobId, another.jobId)
        && Objects.equals(serviceBroker, another.serviceBroker);
  }

  /**
   * Computes a hash code from attributes: {@code jobId}, {@code serviceBroker}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(jobId);
    h += (h << 5) + Objects.hashCode(serviceBroker);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceBrokerResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UpdateServiceBrokerResponse{");
    if (jobId != null) {
      builder.append("jobId=").append(jobId);
    }
    if (serviceBroker != null) {
      if (builder.length() > 28) builder.append(", ");
      builder.append("serviceBroker=").append(serviceBroker);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates a builder for {@link UpdateServiceBrokerResponse UpdateServiceBrokerResponse}.
   * <pre>
   * UpdateServiceBrokerResponse.builder()
   *    .jobId(String) // optional {@link UpdateServiceBrokerResponse#jobId() jobId}
   *    .serviceBroker(ServiceBrokerResource) // optional {@link UpdateServiceBrokerResponse#serviceBroker() serviceBroker}
   *    .build();
   * </pre>
   * @return A new UpdateServiceBrokerResponse builder
   */
  public static UpdateServiceBrokerResponse.Builder builder() {
    return new UpdateServiceBrokerResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceBrokerResponse UpdateServiceBrokerResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceBrokerResponse", generator = "Immutables")
  public static final class Builder {
    private String jobId;
    private ServiceBrokerResource serviceBroker;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceBrokerResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceBrokerResponse instance) {
      return from((_UpdateServiceBrokerResponse) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceBrokerResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceBrokerResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> jobIdOptional = instance.jobId();
      if (jobIdOptional.isPresent()) {
        jobId(jobIdOptional);
      }
      Optional<ServiceBrokerResource> serviceBrokerOptional = instance.serviceBroker();
      if (serviceBrokerOptional.isPresent()) {
        serviceBroker(serviceBrokerOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link UpdateServiceBrokerResponse#jobId() jobId} to jobId.
     * @param jobId The value for jobId
     * @return {@code this} builder for chained invocation
     */
    public final Builder jobId(String jobId) {
      this.jobId = Objects.requireNonNull(jobId, "jobId");
      return this;
    }

    /**
     * Initializes the optional value {@link UpdateServiceBrokerResponse#jobId() jobId} to jobId.
     * @param jobId The value for jobId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jobId(Optional<String> jobId) {
      this.jobId = jobId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UpdateServiceBrokerResponse#serviceBroker() serviceBroker} to serviceBroker.
     * @param serviceBroker The value for serviceBroker
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceBroker(ServiceBrokerResource serviceBroker) {
      this.serviceBroker = Objects.requireNonNull(serviceBroker, "serviceBroker");
      return this;
    }

    /**
     * Initializes the optional value {@link UpdateServiceBrokerResponse#serviceBroker() serviceBroker} to serviceBroker.
     * @param serviceBroker The value for serviceBroker
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBroker(Optional<? extends ServiceBrokerResource> serviceBroker) {
      this.serviceBroker = serviceBroker.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceBrokerResponse UpdateServiceBrokerResponse}.
     * @return An immutable instance of UpdateServiceBrokerResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceBrokerResponse build() {
      return new UpdateServiceBrokerResponse(this);
    }
  }
}
