package org.cloudfoundry.client.v3.serviceinstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Service operation
 */
@Generated(from = "_DeleteServiceInstanceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteServiceInstanceRequest
    extends org.cloudfoundry.client.v3.serviceinstances._DeleteServiceInstanceRequest {
  private final String serviceInstanceId;

  private DeleteServiceInstanceRequest(DeleteServiceInstanceRequest.Builder builder) {
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServiceInstanceRequest
        && equalTo((DeleteServiceInstanceRequest) another);
  }

  private boolean equalTo(DeleteServiceInstanceRequest another) {
    return serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServiceInstanceRequest{"
        + "serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServiceInstanceRequest DeleteServiceInstanceRequest}.
   * <pre>
   * DeleteServiceInstanceRequest.builder()
   *    .serviceInstanceId(String) // required {@link DeleteServiceInstanceRequest#getServiceInstanceId() serviceInstanceId}
   *    .build();
   * </pre>
   * @return A new DeleteServiceInstanceRequest builder
   */
  public static DeleteServiceInstanceRequest.Builder builder() {
    return new DeleteServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServiceInstanceRequest DeleteServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteServiceInstanceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServiceInstanceRequest instance) {
      return from((_DeleteServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceInstanceRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteServiceInstanceRequest DeleteServiceInstanceRequest}.
     * @return An immutable instance of DeleteServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build DeleteServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
