package org.cloudfoundry.client.v3.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _GetUserProvidedCredentialsResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetUserProvidedCredentialsResponse.builder()}.
 */
@Generated(from = "_GetUserProvidedCredentialsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetUserProvidedCredentialsResponse
    extends org.cloudfoundry.client.v3.serviceinstances._GetUserProvidedCredentialsResponse {
  private final Map<String, Object> credentials;

  private GetUserProvidedCredentialsResponse(GetUserProvidedCredentialsResponse.Builder builder) {
    this.credentials = createUnmodifiableMap(false, false, builder.credentials);
  }

  /**
   * 
   * @return credentials as map
   */
  @JsonProperty("credentials")
  @JsonAnyGetter
  @Override
  public Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * This instance is equal to all instances of {@code GetUserProvidedCredentialsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetUserProvidedCredentialsResponse
        && equalTo((GetUserProvidedCredentialsResponse) another);
  }

  private boolean equalTo(GetUserProvidedCredentialsResponse another) {
    return credentials.equals(another.credentials);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + credentials.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetUserProvidedCredentialsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetUserProvidedCredentialsResponse{"
        + "credentials=" + credentials
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetUserProvidedCredentialsResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.serviceinstances._GetUserProvidedCredentialsResponse {
    final Map<String, Object> credentials = new HashMap<String, Object>();

    @JsonAnySetter
    public void setCredentials(String key, Object value) {
      this.credentials.put(key, value);
    }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetUserProvidedCredentialsResponse fromJson(Json json) {
    GetUserProvidedCredentialsResponse.Builder builder = GetUserProvidedCredentialsResponse.builder();
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetUserProvidedCredentialsResponse GetUserProvidedCredentialsResponse}.
   * <pre>
   * GetUserProvidedCredentialsResponse.builder()
   *    .credential|putAllCredentials(String =&gt; Object) // {@link GetUserProvidedCredentialsResponse#getCredentials() credentials} mappings
   *    .build();
   * </pre>
   * @return A new GetUserProvidedCredentialsResponse builder
   */
  public static GetUserProvidedCredentialsResponse.Builder builder() {
    return new GetUserProvidedCredentialsResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetUserProvidedCredentialsResponse GetUserProvidedCredentialsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetUserProvidedCredentialsResponse", generator = "Immutables")
  public static final class Builder {
    private Map<String, Object> credentials = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetUserProvidedCredentialsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetUserProvidedCredentialsResponse instance) {
      return from((_GetUserProvidedCredentialsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetUserProvidedCredentialsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetUserProvidedCredentialsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      putAllCredentials(instance.getCredentials());
      return this;
    }

    /**
     * Put one entry to the {@link GetUserProvidedCredentialsResponse#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonAnySetter
    public final Builder credential(String key, Object value) {
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetUserProvidedCredentialsResponse#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetUserProvidedCredentialsResponse#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credentials")
    public final Builder credentials(Map<String, ? extends Object> entries) {
      this.credentials.clear();
      return putAllCredentials(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetUserProvidedCredentialsResponse#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link GetUserProvidedCredentialsResponse GetUserProvidedCredentialsResponse}.
     * @return An immutable instance of GetUserProvidedCredentialsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetUserProvidedCredentialsResponse build() {
      return new GetUserProvidedCredentialsResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
