package org.cloudfoundry.client.v3.serviceofferings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Pagination;
import org.immutables.value.Generated;

/**
 * The response payload for the List Service Offerings operation
 */
@Generated(from = "_ListServiceOfferingsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServiceOfferingsResponse
    extends org.cloudfoundry.client.v3.serviceofferings._ListServiceOfferingsResponse {
  private final @Nullable Pagination pagination;
  private final @Nullable List<ServiceOfferingResource> resources;

  private ListServiceOfferingsResponse(ListServiceOfferingsResponse.Builder builder) {
    this.pagination = builder.pagination;
    this.resources = builder.resources == null ? null : createUnmodifiableList(true, builder.resources);
  }

  /**
   * The pagination
   */
  @JsonProperty("pagination")
  @Override
  public @Nullable Pagination getPagination() {
    return pagination;
  }

  /**
   * The resources
   */
  @JsonProperty("resources")
  @Override
  public @Nullable List<ServiceOfferingResource> getResources() {
    return resources;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceOfferingsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceOfferingsResponse
        && equalTo((ListServiceOfferingsResponse) another);
  }

  private boolean equalTo(ListServiceOfferingsResponse another) {
    return Objects.equals(pagination, another.pagination)
        && Objects.equals(resources, another.resources);
  }

  /**
   * Computes a hash code from attributes: {@code pagination}, {@code resources}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(pagination);
    h += (h << 5) + Objects.hashCode(resources);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceOfferingsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceOfferingsResponse{"
        + "pagination=" + pagination
        + ", resources=" + resources
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListServiceOfferingsResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceofferings._ListServiceOfferingsResponse {
    Pagination pagination;
    List<ServiceOfferingResource> resources = null;
    @JsonProperty("pagination")
    public void setPagination(@Nullable Pagination pagination) {
      this.pagination = pagination;
    }
    @JsonProperty("resources")
    public void setResources(@Nullable List<ServiceOfferingResource> resources) {
      this.resources = resources;
    }
    @Override
    public Pagination getPagination() { throw new UnsupportedOperationException(); }
    @Override
    public List<ServiceOfferingResource> getResources() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListServiceOfferingsResponse fromJson(Json json) {
    ListServiceOfferingsResponse.Builder builder = ListServiceOfferingsResponse.builder();
    if (json.pagination != null) {
      builder.pagination(json.pagination);
    }
    if (json.resources != null) {
      builder.addAllResources(json.resources);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListServiceOfferingsResponse ListServiceOfferingsResponse}.
   * <pre>
   * ListServiceOfferingsResponse.builder()
   *    .pagination(org.cloudfoundry.client.v3.Pagination | null) // nullable {@link ListServiceOfferingsResponse#getPagination() pagination}
   *    .resources(List&amp;lt;ServiceOfferingResource&amp;gt; | null) // nullable {@link ListServiceOfferingsResponse#getResources() resources}
   *    .build();
   * </pre>
   * @return A new ListServiceOfferingsResponse builder
   */
  public static ListServiceOfferingsResponse.Builder builder() {
    return new ListServiceOfferingsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceOfferingsResponse ListServiceOfferingsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServiceOfferingsResponse", generator = "Immutables")
  public static final class Builder {
    private Pagination pagination;
    private List<ServiceOfferingResource> resources = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceOfferingsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceOfferingsResponse instance) {
      return from((_ListServiceOfferingsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListServiceOfferingsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListServiceOfferingsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Pagination paginationValue = instance.getPagination();
      if (paginationValue != null) {
        pagination(paginationValue);
      }
      List<ServiceOfferingResource> resourcesValue = instance.getResources();
      if (resourcesValue != null) {
        addAllResources(resourcesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceOfferingsResponse#getPagination() pagination} attribute.
     * @param pagination The value for pagination (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("pagination")
    public final Builder pagination(@Nullable Pagination pagination) {
      this.pagination = pagination;
      return this;
    }

    /**
     * Adds one element to {@link ListServiceOfferingsResponse#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(ServiceOfferingResource element) {
      if (this.resources == null) {
        this.resources = new ArrayList<ServiceOfferingResource>();
      }
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServiceOfferingsResponse#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(ServiceOfferingResource... elements) {
      if (this.resources == null) {
        this.resources = new ArrayList<ServiceOfferingResource>();
      }
      for (ServiceOfferingResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServiceOfferingsResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resources")
    public final Builder resources(@Nullable Iterable<? extends ServiceOfferingResource> elements) {
      if (elements == null) {
        this.resources = null;
        return this;
      }
      this.resources = new ArrayList<ServiceOfferingResource>();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link ListServiceOfferingsResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends ServiceOfferingResource> elements) {
      Objects.requireNonNull(elements, "resources element");
      if (this.resources == null) {
        this.resources = new ArrayList<ServiceOfferingResource>();
      }
      for (ServiceOfferingResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListServiceOfferingsResponse ListServiceOfferingsResponse}.
     * @return An immutable instance of ListServiceOfferingsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceOfferingsResponse build() {
      return new ListServiceOfferingsResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
