package org.cloudfoundry.client.v3.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * The response payload for the apply manifest operation
 */
@Generated(from = "_ApplyManifestResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ApplyManifestResponse extends org.cloudfoundry.client.v3.spaces._ApplyManifestResponse {
  private final String jobId;

  private ApplyManifestResponse(ApplyManifestResponse.Builder builder) {
    this.jobId = builder.jobId;
  }

  /**
   * The Job ID
   */
  @JsonProperty("jobId")
  @Override
  public Optional<String> getJobId() {
    return Optional.ofNullable(jobId);
  }

  /**
   * This instance is equal to all instances of {@code ApplyManifestResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplyManifestResponse
        && equalTo((ApplyManifestResponse) another);
  }

  private boolean equalTo(ApplyManifestResponse another) {
    return Objects.equals(jobId, another.jobId);
  }

  /**
   * Computes a hash code from attributes: {@code jobId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(jobId);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplyManifestResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ApplyManifestResponse{");
    if (jobId != null) {
      builder.append("jobId=").append(jobId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ApplyManifestResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.spaces._ApplyManifestResponse {
    Optional<String> jobId = Optional.empty();
    @JsonProperty("jobId")
    public void setJobId(Optional<String> jobId) {
      this.jobId = jobId;
    }
    @Override
    public Optional<String> getJobId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplyManifestResponse fromJson(Json json) {
    ApplyManifestResponse.Builder builder = ApplyManifestResponse.builder();
    if (json.jobId != null) {
      builder.jobId(json.jobId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplyManifestResponse ApplyManifestResponse}.
   * <pre>
   * ApplyManifestResponse.builder()
   *    .jobId(String) // optional {@link ApplyManifestResponse#getJobId() jobId}
   *    .build();
   * </pre>
   * @return A new ApplyManifestResponse builder
   */
  public static ApplyManifestResponse.Builder builder() {
    return new ApplyManifestResponse.Builder();
  }

  /**
   * Builds instances of type {@link ApplyManifestResponse ApplyManifestResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ApplyManifestResponse", generator = "Immutables")
  public static final class Builder {
    private String jobId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplyManifestResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplyManifestResponse instance) {
      return from((_ApplyManifestResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ApplyManifestResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplyManifestResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> jobIdOptional = instance.getJobId();
      if (jobIdOptional.isPresent()) {
        jobId(jobIdOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ApplyManifestResponse#getJobId() jobId} to jobId.
     * @param jobId The value for jobId
     * @return {@code this} builder for chained invocation
     */
    public final Builder jobId(String jobId) {
      this.jobId = Objects.requireNonNull(jobId, "jobId");
      return this;
    }

    /**
     * Initializes the optional value {@link ApplyManifestResponse#getJobId() jobId} to jobId.
     * @param jobId The value for jobId
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jobId")
    public final Builder jobId(Optional<String> jobId) {
      this.jobId = jobId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ApplyManifestResponse ApplyManifestResponse}.
     * @return An immutable instance of ApplyManifestResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplyManifestResponse build() {
      return new ApplyManifestResponse(this);
    }
  }
}
