package org.cloudfoundry.client.v3.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The relationships for the Create Space request
 */
@Generated(from = "_SpaceRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SpaceRelationships extends org.cloudfoundry.client.v3.spaces._SpaceRelationships {
  private final ToOneRelationship organization;
  private final @Nullable ToOneRelationship quota;

  private SpaceRelationships(SpaceRelationships.Builder builder) {
    this.organization = builder.organization;
    this.quota = builder.quota;
  }

  /**
   * The organization relationship
   */
  @JsonProperty("organization")
  @Override
  public ToOneRelationship getOrganization() {
    return organization;
  }

  /**
   * The quota relationship
   */
  @JsonProperty("quota")
  @Override
  public @Nullable ToOneRelationship getQuota() {
    return quota;
  }

  /**
   * This instance is equal to all instances of {@code SpaceRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SpaceRelationships
        && equalTo((SpaceRelationships) another);
  }

  private boolean equalTo(SpaceRelationships another) {
    return organization.equals(another.organization)
        && Objects.equals(quota, another.quota);
  }

  /**
   * Computes a hash code from attributes: {@code organization}, {@code quota}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organization.hashCode();
    h += (h << 5) + Objects.hashCode(quota);
    return h;
  }

  /**
   * Prints the immutable value {@code SpaceRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SpaceRelationships{"
        + "organization=" + organization
        + ", quota=" + quota
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_SpaceRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.spaces._SpaceRelationships {
    ToOneRelationship organization;
    ToOneRelationship quota;
    @JsonProperty("organization")
    public void setOrganization(ToOneRelationship organization) {
      this.organization = organization;
    }
    @JsonProperty("quota")
    public void setQuota(@Nullable ToOneRelationship quota) {
      this.quota = quota;
    }
    @Override
    public ToOneRelationship getOrganization() { throw new UnsupportedOperationException(); }
    @Override
    public ToOneRelationship getQuota() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SpaceRelationships fromJson(Json json) {
    SpaceRelationships.Builder builder = SpaceRelationships.builder();
    if (json.organization != null) {
      builder.organization(json.organization);
    }
    if (json.quota != null) {
      builder.quota(json.quota);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SpaceRelationships SpaceRelationships}.
   * <pre>
   * SpaceRelationships.builder()
   *    .organization(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link SpaceRelationships#getOrganization() organization}
   *    .quota(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link SpaceRelationships#getQuota() quota}
   *    .build();
   * </pre>
   * @return A new SpaceRelationships builder
   */
  public static SpaceRelationships.Builder builder() {
    return new SpaceRelationships.Builder();
  }

  /**
   * Builds instances of type {@link SpaceRelationships SpaceRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SpaceRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship organization;
    private ToOneRelationship quota;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpaceRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SpaceRelationships instance) {
      return from((_SpaceRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _SpaceRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SpaceRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      organization(instance.getOrganization());
      ToOneRelationship quotaValue = instance.getQuota();
      if (quotaValue != null) {
        quota(quotaValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceRelationships#getOrganization() organization} attribute.
     * @param organization The value for organization 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization")
    public final Builder organization(ToOneRelationship organization) {
      this.organization = Objects.requireNonNull(organization, "organization");
      initBits &= ~INIT_BIT_ORGANIZATION;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceRelationships#getQuota() quota} attribute.
     * @param quota The value for quota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("quota")
    public final Builder quota(@Nullable ToOneRelationship quota) {
      this.quota = quota;
      return this;
    }

    /**
     * Builds a new {@link SpaceRelationships SpaceRelationships}.
     * @return An immutable instance of SpaceRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SpaceRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SpaceRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION) != 0) attributes.add("organization");
      return "Cannot build SpaceRelationships, some of required attributes are not set " + attributes;
    }
  }
}
