/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.serviceplans.Organization;
import org.cloudfoundry.client.v3.serviceplans.Visibility;
import org.cloudfoundry.client.v3.serviceplans._UpdateServicePlanVisibilityRequest;
import org.immutables.value.Generated;

@Generated(from="_UpdateServicePlanVisibilityRequest", generator="Immutables")
public final class UpdateServicePlanVisibilityRequest
extends _UpdateServicePlanVisibilityRequest {
    private final String servicePlanId;
    private final Visibility type;
    @Nullable
    private final List<Organization> organizations;

    private UpdateServicePlanVisibilityRequest(Builder builder) {
        this.servicePlanId = builder.servicePlanId;
        this.type = builder.type;
        this.organizations = builder.organizations == null ? null : UpdateServicePlanVisibilityRequest.createUnmodifiableList(true, builder.organizations);
    }

    @Override
    @JsonProperty(value="servicePlanId")
    @JsonIgnore
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    @Override
    @JsonProperty(value="type")
    public Visibility getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="organizations")
    @Nullable
    public List<Organization> getOrganizations() {
        return this.organizations;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateServicePlanVisibilityRequest && this.equalTo((UpdateServicePlanVisibilityRequest)another);
    }

    private boolean equalTo(UpdateServicePlanVisibilityRequest another) {
        return this.servicePlanId.equals(another.servicePlanId) && this.type.equals((Object)another.type) && Objects.equals(this.organizations, another.organizations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.servicePlanId.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.organizations);
        return h;
    }

    public String toString() {
        return "UpdateServicePlanVisibilityRequest{servicePlanId=" + this.servicePlanId + ", type=" + (Object)((Object)this.type) + ", organizations=" + this.organizations + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateServicePlanVisibilityRequest fromJson(Json json) {
        Builder builder = UpdateServicePlanVisibilityRequest.builder();
        if (json.servicePlanId != null) {
            builder.servicePlanId(json.servicePlanId);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.organizations != null) {
            builder.addAllOrganizations(json.organizations);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_UpdateServicePlanVisibilityRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SERVICE_PLAN_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private String servicePlanId;
        private Visibility type;
        private List<Organization> organizations = null;

        private Builder() {
        }

        public final Builder from(UpdateServicePlanVisibilityRequest instance) {
            return this.from((_UpdateServicePlanVisibilityRequest)instance);
        }

        final Builder from(_UpdateServicePlanVisibilityRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.servicePlanId(instance.getServicePlanId());
            this.type(instance.getType());
            List<Organization> organizationsValue = instance.getOrganizations();
            if (organizationsValue != null) {
                this.addAllOrganizations(organizationsValue);
            }
            return this;
        }

        public final Builder servicePlanId(String servicePlanId) {
            this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(Visibility type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder organization(Organization element) {
            if (this.organizations == null) {
                this.organizations = new ArrayList<Organization>();
            }
            this.organizations.add(Objects.requireNonNull(element, "organizations element"));
            return this;
        }

        public final Builder organizations(Organization ... elements) {
            if (this.organizations == null) {
                this.organizations = new ArrayList<Organization>();
            }
            for (Organization element : elements) {
                this.organizations.add(Objects.requireNonNull(element, "organizations element"));
            }
            return this;
        }

        public final Builder organizations(@Nullable Iterable<? extends Organization> elements) {
            if (elements == null) {
                this.organizations = null;
                return this;
            }
            this.organizations = new ArrayList<Organization>();
            return this.addAllOrganizations(elements);
        }

        public final Builder addAllOrganizations(Iterable<? extends Organization> elements) {
            Objects.requireNonNull(elements, "organizations element");
            if (this.organizations == null) {
                this.organizations = new ArrayList<Organization>();
            }
            for (Organization organization : elements) {
                this.organizations.add(Objects.requireNonNull(organization, "organizations element"));
            }
            return this;
        }

        public UpdateServicePlanVisibilityRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateServicePlanVisibilityRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("servicePlanId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build UpdateServicePlanVisibilityRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UpdateServicePlanVisibilityRequest", generator="Immutables")
    static final class Json
    extends _UpdateServicePlanVisibilityRequest {
        String servicePlanId;
        Visibility type;
        List<Organization> organizations = null;

        Json() {
        }

        @JsonProperty(value="servicePlanId")
        @JsonIgnore
        public void setServicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
        }

        @JsonProperty(value="type")
        public void setType(Visibility type) {
            this.type = type;
        }

        @JsonProperty(value="organizations")
        public void setOrganizations(@Nullable List<Organization> organizations) {
            this.organizations = organizations;
        }

        @Override
        public String getServicePlanId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Visibility getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Organization> getOrganizations() {
            throw new UnsupportedOperationException();
        }
    }
}

