/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.spaces._ListSpaceApplicationsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListSpaceApplicationsRequest", generator="Immutables")
public final class ListSpaceApplicationsRequest
extends _ListSpaceApplicationsRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    @Nullable
    private final Boolean diego;
    @Nullable
    private final List<String> names;
    @Nullable
    private final List<String> organizationIds;
    private final String spaceId;
    @Nullable
    private final List<String> stackIds;

    private ListSpaceApplicationsRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.diego = builder.diego;
        this.names = builder.names == null ? null : ListSpaceApplicationsRequest.createUnmodifiableList(true, builder.names);
        this.organizationIds = builder.organizationIds == null ? null : ListSpaceApplicationsRequest.createUnmodifiableList(true, builder.organizationIds);
        this.spaceId = builder.spaceId;
        this.stackIds = builder.stackIds == null ? null : ListSpaceApplicationsRequest.createUnmodifiableList(true, builder.stackIds);
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    @Nullable
    public Boolean getDiego() {
        return this.diego;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @Nullable
    public List<String> getStackIds() {
        return this.stackIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListSpaceApplicationsRequest && this.equalTo(0, (ListSpaceApplicationsRequest)another);
    }

    private boolean equalTo(int synthetic, ListSpaceApplicationsRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && Objects.equals(this.diego, another.diego) && Objects.equals(this.names, another.names) && Objects.equals(this.organizationIds, another.organizationIds) && this.spaceId.equals(another.spaceId) && Objects.equals(this.stackIds, another.stackIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + Objects.hashCode(this.diego);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + Objects.hashCode(this.organizationIds);
        h += (h << 5) + this.spaceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.stackIds);
        return h;
    }

    public String toString() {
        return "ListSpaceApplicationsRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", diego=" + this.diego + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", spaceId=" + this.spaceId + ", stackIds=" + this.stackIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListSpaceApplicationsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SPACE_ID = 1L;
        private long initBits = 1L;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private Boolean diego;
        private List<String> names = null;
        private List<String> organizationIds = null;
        private String spaceId;
        private List<String> stackIds = null;

        private Builder() {
        }

        public final Builder from(ListSpaceApplicationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListSpaceApplicationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListSpaceApplicationsRequest) {
                List<String> organizationIdsValue;
                List<String> stackIdsValue;
                List<String> namesValue;
                instance = (_ListSpaceApplicationsRequest)object;
                this.spaceId(((_ListSpaceApplicationsRequest)instance).getSpaceId());
                Boolean diegoValue = ((_ListSpaceApplicationsRequest)instance).getDiego();
                if (diegoValue != null) {
                    this.diego(diegoValue);
                }
                if ((namesValue = ((_ListSpaceApplicationsRequest)instance).getNames()) != null) {
                    this.addAllNames(namesValue);
                }
                if ((stackIdsValue = ((_ListSpaceApplicationsRequest)instance).getStackIds()) != null) {
                    this.addAllStackIds(stackIdsValue);
                }
                if ((organizationIdsValue = ((_ListSpaceApplicationsRequest)instance).getOrganizationIds()) != null) {
                    this.addAllOrganizationIds(organizationIdsValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder diego(@Nullable Boolean diego) {
            this.diego = diego;
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationIds = null;
                return this;
            }
            this.organizationIds = new ArrayList<String>();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationIds element");
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stackId(String element) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList<String>();
            }
            this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
            return this;
        }

        public final Builder stackIds(String ... elements) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
            }
            return this;
        }

        public final Builder stackIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.stackIds = null;
                return this;
            }
            this.stackIds = new ArrayList<String>();
            return this.addAllStackIds(elements);
        }

        public final Builder addAllStackIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "stackIds element");
            if (this.stackIds == null) {
                this.stackIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
            }
            return this;
        }

        public ListSpaceApplicationsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListSpaceApplicationsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spaceId");
            }
            return "Cannot build ListSpaceApplicationsRequest, some of required attributes are not set " + attributes;
        }
    }
}

