/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.builds;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.builds.Build;
import org.cloudfoundry.client.v3.builds.BuildRelationships;
import org.cloudfoundry.client.v3.builds.BuildState;
import org.cloudfoundry.client.v3.builds.CreatedBy;
import org.cloudfoundry.client.v3.builds.Droplet;
import org.cloudfoundry.client.v3.builds._BuildResource;
import org.immutables.value.Generated;

@Generated(from="_BuildResource", generator="Immutables")
public final class BuildResource
extends _BuildResource {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    private final CreatedBy createdBy;
    @Nullable
    private final Droplet droplet;
    @Nullable
    private final String error;
    private final Relationship inputPackage;
    private final Lifecycle lifecycle;
    @Nullable
    private final Metadata metadata;
    @Nullable
    private final BuildRelationships relationships;
    private final BuildState state;
    @Nullable
    private final Integer stagingMemory;
    @Nullable
    private final Integer stagingDisk;

    private BuildResource(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = BuildResource.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.createdBy = builder.createdBy;
        this.droplet = builder.droplet;
        this.error = builder.error;
        this.inputPackage = builder.inputPackage;
        this.lifecycle = builder.lifecycle;
        this.metadata = builder.metadata;
        this.relationships = builder.relationships;
        this.state = builder.state;
        this.stagingMemory = builder.stagingMemory;
        this.stagingDisk = builder.stagingDisk;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="created_by")
    public CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    @Override
    @JsonProperty(value="droplet")
    @Nullable
    public Droplet getDroplet() {
        return this.droplet;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="package")
    public Relationship getInputPackage() {
        return this.inputPackage;
    }

    @Override
    @JsonProperty(value="lifecycle")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="relationships")
    @Nullable
    public BuildRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="state")
    public BuildState getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="staging_memory_in_mb")
    @Nullable
    public Integer getStagingMemory() {
        return this.stagingMemory;
    }

    @Override
    @JsonProperty(value="staging_disk_in_mb")
    @Nullable
    public Integer getStagingDisk() {
        return this.stagingDisk;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BuildResource && this.equalTo(0, (BuildResource)another);
    }

    private boolean equalTo(int synthetic, BuildResource another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && this.createdBy.equals(another.createdBy) && Objects.equals(this.droplet, another.droplet) && Objects.equals(this.error, another.error) && this.inputPackage.equals(another.inputPackage) && this.lifecycle.equals(another.lifecycle) && Objects.equals(this.metadata, another.metadata) && Objects.equals(this.relationships, another.relationships) && this.state.equals((Object)another.state) && Objects.equals(this.stagingMemory, another.stagingMemory) && Objects.equals(this.stagingDisk, another.stagingDisk);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + this.createdBy.hashCode();
        h += (h << 5) + Objects.hashCode(this.droplet);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.inputPackage.hashCode();
        h += (h << 5) + this.lifecycle.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + Objects.hashCode(this.relationships);
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + Objects.hashCode(this.stagingMemory);
        h += (h << 5) + Objects.hashCode(this.stagingDisk);
        return h;
    }

    public String toString() {
        return "BuildResource{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", createdBy=" + this.createdBy + ", droplet=" + this.droplet + ", error=" + this.error + ", inputPackage=" + this.inputPackage + ", lifecycle=" + this.lifecycle + ", metadata=" + this.metadata + ", relationships=" + this.relationships + ", state=" + (Object)((Object)this.state) + ", stagingMemory=" + this.stagingMemory + ", stagingDisk=" + this.stagingDisk + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BuildResource fromJson(Json json) {
        Builder builder = BuildResource.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.createdBy != null) {
            builder.createdBy(json.createdBy);
        }
        if (json.droplet != null) {
            builder.droplet(json.droplet);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.inputPackage != null) {
            builder.inputPackage(json.inputPackage);
        }
        if (json.lifecycle != null) {
            builder.lifecycle(json.lifecycle);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.stagingMemory != null) {
            builder.stagingMemory(json.stagingMemory);
        }
        if (json.stagingDisk != null) {
            builder.stagingDisk(json.stagingDisk);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_BuildResource", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_CREATED_BY = 4L;
        private static final long INIT_BIT_INPUT_PACKAGE = 8L;
        private static final long INIT_BIT_LIFECYCLE = 16L;
        private static final long INIT_BIT_STATE = 32L;
        private long initBits = 63L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private CreatedBy createdBy;
        private Droplet droplet;
        private String error;
        private Relationship inputPackage;
        private Lifecycle lifecycle;
        private Metadata metadata;
        private BuildRelationships relationships;
        private BuildState state;
        private Integer stagingMemory;
        private Integer stagingDisk;

        private Builder() {
        }

        public final Builder from(Build instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BuildResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_BuildResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String updatedAtValue;
            Integer stagingMemoryValue;
            BuildRelationships relationshipsValue;
            String errorValue;
            Droplet dropletValue;
            Integer stagingDiskValue;
            Metadata metadataValue;
            Resource instance;
            long bits = 0L;
            if (object instanceof Build) {
                instance = (Build)object;
                if ((bits & 1L) == 0L) {
                    metadataValue = ((Build)instance).getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    stagingDiskValue = ((Build)instance).getStagingDisk();
                    if (stagingDiskValue != null) {
                        this.stagingDisk(stagingDiskValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    dropletValue = ((Build)instance).getDroplet();
                    if (dropletValue != null) {
                        this.droplet(dropletValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    errorValue = ((Build)instance).getError();
                    if (errorValue != null) {
                        this.error(errorValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.lifecycle(((Build)instance).getLifecycle());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    relationshipsValue = ((Build)instance).getRelationships();
                    if (relationshipsValue != null) {
                        this.relationships(relationshipsValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.inputPackage(((Build)instance).getInputPackage());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.createdBy(((Build)instance).getCreatedBy());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    stagingMemoryValue = ((Build)instance).getStagingMemory();
                    if (stagingMemoryValue != null) {
                        this.stagingMemory(stagingMemoryValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.state(((Build)instance).getState());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x2000L;
                }
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                if ((bits & 0x20L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 0x20L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x800L;
                }
                if ((bits & 0x2000L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x2000L;
                }
            }
            if (object instanceof _BuildResource) {
                instance = (_BuildResource)object;
                if ((bits & 0x10L) == 0L) {
                    this.lifecycle(((Build)instance).getLifecycle());
                    bits |= 0x10L;
                }
                if ((bits & 0x40L) == 0L) {
                    relationshipsValue = ((Build)instance).getRelationships();
                    if (relationshipsValue != null) {
                        this.relationships(relationshipsValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 1L) == 0L) {
                    metadataValue = ((Build)instance).getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    stagingDiskValue = ((Build)instance).getStagingDisk();
                    if (stagingDiskValue != null) {
                        this.stagingDisk(stagingDiskValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.inputPackage(((Build)instance).getInputPackage());
                    bits |= 0x80L;
                }
                if ((bits & 4L) == 0L) {
                    dropletValue = ((Build)instance).getDroplet();
                    if (dropletValue != null) {
                        this.droplet(dropletValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.createdBy(((Build)instance).getCreatedBy());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    stagingMemoryValue = ((Build)instance).getStagingMemory();
                    if (stagingMemoryValue != null) {
                        this.stagingMemory(stagingMemoryValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.state(((Build)instance).getState());
                    bits |= 0x1000L;
                }
                if ((bits & 8L) == 0L) {
                    errorValue = ((Build)instance).getError();
                    if (errorValue != null) {
                        this.error(errorValue);
                    }
                    bits |= 8L;
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="created_by")
        public final Builder createdBy(CreatedBy createdBy) {
            this.createdBy = Objects.requireNonNull(createdBy, "createdBy");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="droplet")
        public final Builder droplet(@Nullable Droplet droplet) {
            this.droplet = droplet;
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="package")
        public final Builder inputPackage(Relationship inputPackage) {
            this.inputPackage = Objects.requireNonNull(inputPackage, "inputPackage");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="lifecycle")
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(@Nullable BuildRelationships relationships) {
            this.relationships = relationships;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(BuildState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="staging_memory_in_mb")
        public final Builder stagingMemory(@Nullable Integer stagingMemory) {
            this.stagingMemory = stagingMemory;
            return this;
        }

        @JsonProperty(value="staging_disk_in_mb")
        public final Builder stagingDisk(@Nullable Integer stagingDisk) {
            this.stagingDisk = stagingDisk;
            return this;
        }

        public BuildResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BuildResource(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdBy");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("inputPackage");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("lifecycle");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build BuildResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_BuildResource", generator="Immutables")
    static final class Json
    extends _BuildResource {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        CreatedBy createdBy;
        Droplet droplet;
        String error;
        Relationship inputPackage;
        Lifecycle lifecycle;
        Metadata metadata;
        BuildRelationships relationships;
        BuildState state;
        Integer stagingMemory;
        Integer stagingDisk;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="created_by")
        public void setCreatedBy(CreatedBy createdBy) {
            this.createdBy = createdBy;
        }

        @JsonProperty(value="droplet")
        public void setDroplet(@Nullable Droplet droplet) {
            this.droplet = droplet;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="package")
        public void setInputPackage(Relationship inputPackage) {
            this.inputPackage = inputPackage;
        }

        @JsonProperty(value="lifecycle")
        public void setLifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(@Nullable BuildRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="state")
        public void setState(BuildState state) {
            this.state = state;
        }

        @JsonProperty(value="staging_memory_in_mb")
        public void setStagingMemory(@Nullable Integer stagingMemory) {
            this.stagingMemory = stagingMemory;
        }

        @JsonProperty(value="staging_disk_in_mb")
        public void setStagingDisk(@Nullable Integer stagingDisk) {
            this.stagingDisk = stagingDisk;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CreatedBy getCreatedBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Droplet getDroplet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Relationship getInputPackage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Lifecycle getLifecycle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BuildRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BuildState getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStagingMemory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStagingDisk() {
            throw new UnsupportedOperationException();
        }
    }
}

