/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.domains.Domain;
import org.cloudfoundry.client.v3.domains.DomainRelationships;
import org.cloudfoundry.client.v3.domains.RouterGroup;
import org.cloudfoundry.client.v3.organizations._GetOrganizationDefaultDomainResponse;
import org.cloudfoundry.client.v3.routes.Protocol;
import org.immutables.value.Generated;

@Generated(from="_GetOrganizationDefaultDomainResponse", generator="Immutables")
public final class GetOrganizationDefaultDomainResponse
extends _GetOrganizationDefaultDomainResponse {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    @Nullable
    private final Metadata metadata;
    private final String name;
    private final DomainRelationships relationships;
    @Nullable
    private final RouterGroup routerGroup;
    @Nullable
    private final List<Protocol> supportedProtocols;
    private final boolean isInternal;

    private GetOrganizationDefaultDomainResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = GetOrganizationDefaultDomainResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.relationships = builder.relationships;
        this.routerGroup = builder.routerGroup;
        this.supportedProtocols = builder.supportedProtocols == null ? null : GetOrganizationDefaultDomainResponse.createUnmodifiableList(true, builder.supportedProtocols);
        this.isInternal = builder.isInternal;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="relationships")
    public DomainRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="router_group")
    @Nullable
    public RouterGroup getRouterGroup() {
        return this.routerGroup;
    }

    @Override
    @JsonProperty(value="supported_protocols")
    @Nullable
    public List<Protocol> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @Override
    @JsonProperty(value="internal")
    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetOrganizationDefaultDomainResponse && this.equalTo(0, (GetOrganizationDefaultDomainResponse)another);
    }

    private boolean equalTo(int synthetic, GetOrganizationDefaultDomainResponse another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.metadata, another.metadata) && this.name.equals(another.name) && this.relationships.equals(another.relationships) && Objects.equals(this.routerGroup, another.routerGroup) && Objects.equals(this.supportedProtocols, another.supportedProtocols) && this.isInternal == another.isInternal;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + Objects.hashCode(this.routerGroup);
        h += (h << 5) + Objects.hashCode(this.supportedProtocols);
        h += (h << 5) + Boolean.hashCode(this.isInternal);
        return h;
    }

    public String toString() {
        return "GetOrganizationDefaultDomainResponse{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", metadata=" + this.metadata + ", name=" + this.name + ", relationships=" + this.relationships + ", routerGroup=" + this.routerGroup + ", supportedProtocols=" + this.supportedProtocols + ", isInternal=" + this.isInternal + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetOrganizationDefaultDomainResponse fromJson(Json json) {
        Builder builder = GetOrganizationDefaultDomainResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.routerGroup != null) {
            builder.routerGroup(json.routerGroup);
        }
        if (json.supportedProtocols != null) {
            builder.addAllSupportedProtocols(json.supportedProtocols);
        }
        if (json.isInternalIsSet) {
            builder.isInternal(json.isInternal);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_GetOrganizationDefaultDomainResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_RELATIONSHIPS = 8L;
        private static final long INIT_BIT_IS_INTERNAL = 16L;
        private long initBits = 31L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private Metadata metadata;
        private String name;
        private DomainRelationships relationships;
        private RouterGroup routerGroup;
        private List<Protocol> supportedProtocols = null;
        private boolean isInternal;

        private Builder() {
        }

        public final Builder from(Domain instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(GetOrganizationDefaultDomainResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_GetOrganizationDefaultDomainResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String updatedAtValue;
            List<Protocol> supportedProtocolsValue;
            RouterGroup routerGroupValue;
            Metadata metadataValue;
            Resource instance;
            long bits = 0L;
            if (object instanceof Domain) {
                instance = (Domain)object;
                if ((bits & 8L) == 0L) {
                    this.isInternal(((Domain)instance).isInternal());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.relationships(((Domain)instance).getRelationships());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    metadataValue = ((Domain)instance).getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.name(((Domain)instance).getName());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x100L;
                }
                if ((bits & 2L) == 0L) {
                    routerGroupValue = ((Domain)instance).getRouterGroup();
                    if (routerGroupValue != null) {
                        this.routerGroup(routerGroupValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    supportedProtocolsValue = ((Domain)instance).getSupportedProtocols();
                    if (supportedProtocolsValue != null) {
                        this.addAllSupportedProtocols(supportedProtocolsValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x200L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x200L;
                }
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                if ((bits & 0x10L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 0x10L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x200L;
                }
            }
            if (object instanceof _GetOrganizationDefaultDomainResponse) {
                instance = (_GetOrganizationDefaultDomainResponse)object;
                if ((bits & 8L) == 0L) {
                    this.isInternal(((Domain)instance).isInternal());
                    bits |= 8L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.name(((Domain)instance).getName());
                    bits |= 0x40L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.relationships(((Domain)instance).getRelationships());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    metadataValue = ((Domain)instance).getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    routerGroupValue = ((Domain)instance).getRouterGroup();
                    if (routerGroupValue != null) {
                        this.routerGroup(routerGroupValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    supportedProtocolsValue = ((Domain)instance).getSupportedProtocols();
                    if (supportedProtocolsValue != null) {
                        this.addAllSupportedProtocols(supportedProtocolsValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(DomainRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="router_group")
        public final Builder routerGroup(@Nullable RouterGroup routerGroup) {
            this.routerGroup = routerGroup;
            return this;
        }

        public final Builder supportedProtocol(Protocol element) {
            if (this.supportedProtocols == null) {
                this.supportedProtocols = new ArrayList<Protocol>();
            }
            this.supportedProtocols.add(Objects.requireNonNull(element, "supportedProtocols element"));
            return this;
        }

        public final Builder supportedProtocols(Protocol ... elements) {
            if (this.supportedProtocols == null) {
                this.supportedProtocols = new ArrayList<Protocol>();
            }
            for (Protocol element : elements) {
                this.supportedProtocols.add(Objects.requireNonNull(element, "supportedProtocols element"));
            }
            return this;
        }

        @JsonProperty(value="supported_protocols")
        public final Builder supportedProtocols(@Nullable Iterable<? extends Protocol> elements) {
            if (elements == null) {
                this.supportedProtocols = null;
                return this;
            }
            this.supportedProtocols = new ArrayList<Protocol>();
            return this.addAllSupportedProtocols(elements);
        }

        public final Builder addAllSupportedProtocols(Iterable<? extends Protocol> elements) {
            Objects.requireNonNull(elements, "supportedProtocols element");
            if (this.supportedProtocols == null) {
                this.supportedProtocols = new ArrayList<Protocol>();
            }
            for (Protocol protocol : elements) {
                this.supportedProtocols.add(Objects.requireNonNull(protocol, "supportedProtocols element"));
            }
            return this;
        }

        @JsonProperty(value="internal")
        public final Builder isInternal(boolean isInternal) {
            this.isInternal = isInternal;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public GetOrganizationDefaultDomainResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetOrganizationDefaultDomainResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("isInternal");
            }
            return "Cannot build GetOrganizationDefaultDomainResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_GetOrganizationDefaultDomainResponse", generator="Immutables")
    static final class Json
    extends _GetOrganizationDefaultDomainResponse {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        Metadata metadata;
        String name;
        DomainRelationships relationships;
        RouterGroup routerGroup;
        List<Protocol> supportedProtocols = null;
        boolean isInternal;
        boolean isInternalIsSet;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(DomainRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="router_group")
        public void setRouterGroup(@Nullable RouterGroup routerGroup) {
            this.routerGroup = routerGroup;
        }

        @JsonProperty(value="supported_protocols")
        public void setSupportedProtocols(@Nullable List<Protocol> supportedProtocols) {
            this.supportedProtocols = supportedProtocols;
        }

        @JsonProperty(value="internal")
        public void setIsInternal(boolean isInternal) {
            this.isInternal = isInternal;
            this.isInternalIsSet = true;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DomainRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RouterGroup getRouterGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Protocol> getSupportedProtocols() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInternal() {
            throw new UnsupportedOperationException();
        }
    }
}

