/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.routes.Process;
import org.cloudfoundry.client.v3.routes._Application;
import org.immutables.value.Generated;

@Generated(from="_Application", generator="Immutables")
public final class Application
extends _Application {
    private final String applicationId;
    @Nullable
    private final Process process;

    private Application(Builder builder) {
        this.applicationId = builder.applicationId;
        this.process = builder.process;
    }

    @Override
    @JsonProperty(value="guid")
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @JsonProperty(value="process")
    @Nullable
    public Process getProcess() {
        return this.process;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Application && this.equalTo(0, (Application)another);
    }

    private boolean equalTo(int synthetic, Application another) {
        return this.applicationId.equals(another.applicationId) && Objects.equals(this.process, another.process);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.process);
        return h;
    }

    public String toString() {
        return "Application{applicationId=" + this.applicationId + ", process=" + this.process + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Application fromJson(Json json) {
        Builder builder = Application.builder();
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.process != null) {
            builder.process(json.process);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_Application", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String applicationId;
        private Process process;

        private Builder() {
        }

        public final Builder from(Application instance) {
            return this.from((_Application)instance);
        }

        final Builder from(_Application instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            Process processValue = instance.getProcess();
            if (processValue != null) {
                this.process(processValue);
            }
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="process")
        public final Builder process(@Nullable Process process) {
            this.process = process;
            return this;
        }

        public Application build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Application(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build Application, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_Application", generator="Immutables")
    static final class Json
    extends _Application {
        String applicationId;
        Process process;

        Json() {
        }

        @JsonProperty(value="guid")
        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="process")
        public void setProcess(@Nullable Process process) {
            this.process = process;
        }

        @Override
        public String getApplicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Process getProcess() {
            throw new UnsupportedOperationException();
        }
    }
}

