/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.routes.Application;
import org.cloudfoundry.client.v3.routes._Destination;
import org.immutables.value.Generated;

@Generated(from="_Destination", generator="Immutables")
public final class Destination
extends _Destination {
    private final Application application;
    @Nullable
    private final String destinationId;
    @Nullable
    private final Integer port;
    @Nullable
    private final Integer weight;
    @Nullable
    private final String protocol;

    private Destination(Builder builder) {
        this.application = builder.application;
        this.destinationId = builder.destinationId;
        this.port = builder.port;
        this.weight = builder.weight;
        this.protocol = builder.protocol;
    }

    @Override
    @JsonProperty(value="app")
    public Application getApplication() {
        return this.application;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getDestinationId() {
        return this.destinationId;
    }

    @Override
    @JsonProperty(value="port")
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="weight")
    @Nullable
    public Integer getWeight() {
        return this.weight;
    }

    @Override
    @JsonProperty(value="protocol")
    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Destination && this.equalTo(0, (Destination)another);
    }

    private boolean equalTo(int synthetic, Destination another) {
        return this.application.equals(another.application) && Objects.equals(this.destinationId, another.destinationId) && Objects.equals(this.port, another.port) && Objects.equals(this.weight, another.weight) && Objects.equals(this.protocol, another.protocol);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.application.hashCode();
        h += (h << 5) + Objects.hashCode(this.destinationId);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.weight);
        h += (h << 5) + Objects.hashCode(this.protocol);
        return h;
    }

    public String toString() {
        return "Destination{application=" + this.application + ", destinationId=" + this.destinationId + ", port=" + this.port + ", weight=" + this.weight + ", protocol=" + this.protocol + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Destination fromJson(Json json) {
        Builder builder = Destination.builder();
        if (json.application != null) {
            builder.application(json.application);
        }
        if (json.destinationId != null) {
            builder.destinationId(json.destinationId);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.weight != null) {
            builder.weight(json.weight);
        }
        if (json.protocol != null) {
            builder.protocol(json.protocol);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_Destination", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_APPLICATION = 1L;
        private long initBits = 1L;
        private Application application;
        private String destinationId;
        private Integer port;
        private Integer weight;
        private String protocol;

        private Builder() {
        }

        public final Builder from(Destination instance) {
            return this.from((_Destination)instance);
        }

        final Builder from(_Destination instance) {
            String protocolValue;
            Integer weightValue;
            Integer portValue;
            Objects.requireNonNull(instance, "instance");
            this.application(instance.getApplication());
            String destinationIdValue = instance.getDestinationId();
            if (destinationIdValue != null) {
                this.destinationId(destinationIdValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            if ((weightValue = instance.getWeight()) != null) {
                this.weight(weightValue);
            }
            if ((protocolValue = instance.getProtocol()) != null) {
                this.protocol(protocolValue);
            }
            return this;
        }

        @JsonProperty(value="app")
        public final Builder application(Application application) {
            this.application = Objects.requireNonNull(application, "application");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder destinationId(@Nullable String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        @JsonProperty(value="port")
        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="weight")
        public final Builder weight(@Nullable Integer weight) {
            this.weight = weight;
            return this;
        }

        @JsonProperty(value="protocol")
        public final Builder protocol(@Nullable String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Destination build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Destination(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("application");
            }
            return "Cannot build Destination, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_Destination", generator="Immutables")
    static final class Json
    extends _Destination {
        Application application;
        String destinationId;
        Integer port;
        Integer weight;
        String protocol;

        Json() {
        }

        @JsonProperty(value="app")
        public void setApplication(Application application) {
            this.application = application;
        }

        @JsonProperty(value="guid")
        public void setDestinationId(@Nullable String destinationId) {
            this.destinationId = destinationId;
        }

        @JsonProperty(value="port")
        public void setPort(@Nullable Integer port) {
            this.port = port;
        }

        @JsonProperty(value="weight")
        public void setWeight(@Nullable Integer weight) {
            this.weight = weight;
        }

        @JsonProperty(value="protocol")
        public void setProtocol(@Nullable String protocol) {
            this.protocol = protocol;
        }

        @Override
        public Application getApplication() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDestinationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getWeight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProtocol() {
            throw new UnsupportedOperationException();
        }
    }
}

