/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v3.securitygroups._ListSecurityGroupsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListSecurityGroupsRequest", generator="Immutables")
public final class ListSecurityGroupsRequest
extends _ListSecurityGroupsRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    private final List<String> securityGroupIds;
    private final List<String> names;
    @Nullable
    private final Boolean globallyEnabledRunning;
    @Nullable
    private final Boolean globallyEnabledStagingBoolean;
    @Nullable
    private final List<String> runningSpaceIds;
    @Nullable
    private final List<String> stagingSpaceIds;

    private ListSecurityGroupsRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.securityGroupIds = ListSecurityGroupsRequest.createUnmodifiableList(true, builder.securityGroupIds);
        this.names = ListSecurityGroupsRequest.createUnmodifiableList(true, builder.names);
        this.globallyEnabledRunning = builder.globallyEnabledRunning;
        this.globallyEnabledStagingBoolean = builder.globallyEnabledStagingBoolean;
        this.runningSpaceIds = builder.runningSpaceIds == null ? null : ListSecurityGroupsRequest.createUnmodifiableList(true, builder.runningSpaceIds);
        this.stagingSpaceIds = builder.stagingSpaceIds == null ? null : ListSecurityGroupsRequest.createUnmodifiableList(true, builder.stagingSpaceIds);
    }

    @Override
    @JsonIgnore
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    @JsonIgnore
    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    @Override
    @JsonIgnore
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Boolean getGloballyEnabledRunning() {
        return this.globallyEnabledRunning;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Boolean getGloballyEnabledStagingBoolean() {
        return this.globallyEnabledStagingBoolean;
    }

    @Override
    @JsonIgnore
    @Nullable
    public List<String> getRunningSpaceIds() {
        return this.runningSpaceIds;
    }

    @Override
    @JsonIgnore
    @Nullable
    public List<String> getStagingSpaceIds() {
        return this.stagingSpaceIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListSecurityGroupsRequest && this.equalTo(0, (ListSecurityGroupsRequest)another);
    }

    private boolean equalTo(int synthetic, ListSecurityGroupsRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && this.securityGroupIds.equals(another.securityGroupIds) && this.names.equals(another.names) && Objects.equals(this.globallyEnabledRunning, another.globallyEnabledRunning) && Objects.equals(this.globallyEnabledStagingBoolean, another.globallyEnabledStagingBoolean) && Objects.equals(this.runningSpaceIds, another.runningSpaceIds) && Objects.equals(this.stagingSpaceIds, another.stagingSpaceIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + this.securityGroupIds.hashCode();
        h += (h << 5) + this.names.hashCode();
        h += (h << 5) + Objects.hashCode(this.globallyEnabledRunning);
        h += (h << 5) + Objects.hashCode(this.globallyEnabledStagingBoolean);
        h += (h << 5) + Objects.hashCode(this.runningSpaceIds);
        h += (h << 5) + Objects.hashCode(this.stagingSpaceIds);
        return h;
    }

    public String toString() {
        return "ListSecurityGroupsRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", securityGroupIds=" + this.securityGroupIds + ", names=" + this.names + ", globallyEnabledRunning=" + this.globallyEnabledRunning + ", globallyEnabledStagingBoolean=" + this.globallyEnabledStagingBoolean + ", runningSpaceIds=" + this.runningSpaceIds + ", stagingSpaceIds=" + this.stagingSpaceIds + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListSecurityGroupsRequest fromJson(Json json) {
        Builder builder = ListSecurityGroupsRequest.builder();
        if (json.orderDirection != null) {
            builder.orderDirection(json.orderDirection);
        }
        if (json.page != null) {
            builder.page(json.page);
        }
        if (json.resultsPerPage != null) {
            builder.resultsPerPage(json.resultsPerPage);
        }
        if (json.securityGroupIds != null) {
            builder.addAllSecurityGroupIds(json.securityGroupIds);
        }
        if (json.names != null) {
            builder.addAllNames(json.names);
        }
        if (json.globallyEnabledRunning != null) {
            builder.globallyEnabledRunning(json.globallyEnabledRunning);
        }
        if (json.globallyEnabledStagingBoolean != null) {
            builder.globallyEnabledStagingBoolean(json.globallyEnabledStagingBoolean);
        }
        if (json.runningSpaceIds != null) {
            builder.addAllRunningSpaceIds(json.runningSpaceIds);
        }
        if (json.stagingSpaceIds != null) {
            builder.addAllStagingSpaceIds(json.stagingSpaceIds);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListSecurityGroupsRequest", generator="Immutables")
    public static final class Builder {
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private List<String> securityGroupIds = new ArrayList<String>();
        private List<String> names = new ArrayList<String>();
        private Boolean globallyEnabledRunning;
        private Boolean globallyEnabledStagingBoolean;
        private List<String> runningSpaceIds = null;
        private List<String> stagingSpaceIds = null;

        private Builder() {
        }

        public final Builder from(ListSecurityGroupsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListSecurityGroupsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListSecurityGroupsRequest) {
                Boolean globallyEnabledRunningValue;
                List<String> runningSpaceIdsValue;
                instance = (_ListSecurityGroupsRequest)object;
                List<String> stagingSpaceIdsValue = ((_ListSecurityGroupsRequest)instance).getStagingSpaceIds();
                if (stagingSpaceIdsValue != null) {
                    this.addAllStagingSpaceIds(stagingSpaceIdsValue);
                }
                this.addAllNames(((_ListSecurityGroupsRequest)instance).getNames());
                Boolean globallyEnabledStagingBooleanValue = ((_ListSecurityGroupsRequest)instance).getGloballyEnabledStagingBoolean();
                if (globallyEnabledStagingBooleanValue != null) {
                    this.globallyEnabledStagingBoolean(globallyEnabledStagingBooleanValue);
                }
                if ((runningSpaceIdsValue = ((_ListSecurityGroupsRequest)instance).getRunningSpaceIds()) != null) {
                    this.addAllRunningSpaceIds(runningSpaceIdsValue);
                }
                if ((globallyEnabledRunningValue = ((_ListSecurityGroupsRequest)instance).getGloballyEnabledRunning()) != null) {
                    this.globallyEnabledRunning(globallyEnabledRunningValue);
                }
                this.addAllSecurityGroupIds(((_ListSecurityGroupsRequest)instance).getSecurityGroupIds());
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder securityGroupId(String element) {
            this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
            return this;
        }

        public final Builder securityGroupIds(String ... elements) {
            for (String element : elements) {
                this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
            }
            return this;
        }

        public final Builder securityGroupIds(Iterable<String> elements) {
            this.securityGroupIds.clear();
            return this.addAllSecurityGroupIds(elements);
        }

        public final Builder addAllSecurityGroupIds(Iterable<String> elements) {
            for (String element : elements) {
                this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
            }
            return this;
        }

        public final Builder name(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder globallyEnabledRunning(@Nullable Boolean globallyEnabledRunning) {
            this.globallyEnabledRunning = globallyEnabledRunning;
            return this;
        }

        public final Builder globallyEnabledStagingBoolean(@Nullable Boolean globallyEnabledStagingBoolean) {
            this.globallyEnabledStagingBoolean = globallyEnabledStagingBoolean;
            return this;
        }

        public final Builder runningSpaceId(String element) {
            if (this.runningSpaceIds == null) {
                this.runningSpaceIds = new ArrayList<String>();
            }
            this.runningSpaceIds.add(Objects.requireNonNull(element, "runningSpaceIds element"));
            return this;
        }

        public final Builder runningSpaceIds(String ... elements) {
            if (this.runningSpaceIds == null) {
                this.runningSpaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.runningSpaceIds.add(Objects.requireNonNull(element, "runningSpaceIds element"));
            }
            return this;
        }

        public final Builder runningSpaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.runningSpaceIds = null;
                return this;
            }
            this.runningSpaceIds = new ArrayList<String>();
            return this.addAllRunningSpaceIds(elements);
        }

        public final Builder addAllRunningSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "runningSpaceIds element");
            if (this.runningSpaceIds == null) {
                this.runningSpaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.runningSpaceIds.add(Objects.requireNonNull(element, "runningSpaceIds element"));
            }
            return this;
        }

        public final Builder stagingSpaceId(String element) {
            if (this.stagingSpaceIds == null) {
                this.stagingSpaceIds = new ArrayList<String>();
            }
            this.stagingSpaceIds.add(Objects.requireNonNull(element, "stagingSpaceIds element"));
            return this;
        }

        public final Builder stagingSpaceIds(String ... elements) {
            if (this.stagingSpaceIds == null) {
                this.stagingSpaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.stagingSpaceIds.add(Objects.requireNonNull(element, "stagingSpaceIds element"));
            }
            return this;
        }

        public final Builder stagingSpaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.stagingSpaceIds = null;
                return this;
            }
            this.stagingSpaceIds = new ArrayList<String>();
            return this.addAllStagingSpaceIds(elements);
        }

        public final Builder addAllStagingSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "stagingSpaceIds element");
            if (this.stagingSpaceIds == null) {
                this.stagingSpaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.stagingSpaceIds.add(Objects.requireNonNull(element, "stagingSpaceIds element"));
            }
            return this;
        }

        public ListSecurityGroupsRequest build() {
            return new ListSecurityGroupsRequest(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ListSecurityGroupsRequest", generator="Immutables")
    static final class Json
    extends _ListSecurityGroupsRequest {
        OrderDirection orderDirection;
        Integer page;
        Integer resultsPerPage;
        List<String> securityGroupIds = Collections.emptyList();
        List<String> names = Collections.emptyList();
        Boolean globallyEnabledRunning;
        Boolean globallyEnabledStagingBoolean;
        List<String> runningSpaceIds = null;
        List<String> stagingSpaceIds = null;

        Json() {
        }

        @JsonIgnore
        public void setOrderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
        }

        @JsonIgnore
        public void setPage(@Nullable Integer page) {
            this.page = page;
        }

        @JsonIgnore
        public void setResultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
        }

        @JsonIgnore
        public void setSecurityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
        }

        @JsonIgnore
        public void setNames(List<String> names) {
            this.names = names;
        }

        @JsonIgnore
        public void setGloballyEnabledRunning(@Nullable Boolean globallyEnabledRunning) {
            this.globallyEnabledRunning = globallyEnabledRunning;
        }

        @JsonIgnore
        public void setGloballyEnabledStagingBoolean(@Nullable Boolean globallyEnabledStagingBoolean) {
            this.globallyEnabledStagingBoolean = globallyEnabledStagingBoolean;
        }

        @JsonIgnore
        public void setRunningSpaceIds(@Nullable List<String> runningSpaceIds) {
            this.runningSpaceIds = runningSpaceIds;
        }

        @JsonIgnore
        public void setStagingSpaceIds(@Nullable List<String> stagingSpaceIds) {
            this.stagingSpaceIds = stagingSpaceIds;
        }

        @Override
        public OrderDirection getOrderDirection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getResultsPerPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSecurityGroupIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getGloballyEnabledRunning() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getGloballyEnabledStagingBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getRunningSpaceIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getStagingSpaceIds() {
            throw new UnsupportedOperationException();
        }
    }
}

