/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.serviceofferings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.serviceofferings.BrokerCatalog;
import org.cloudfoundry.client.v3.serviceofferings.ServiceOffering;
import org.cloudfoundry.client.v3.serviceofferings.ServiceOfferingRelationships;
import org.cloudfoundry.client.v3.serviceofferings._ServiceOfferingResource;
import org.immutables.value.Generated;

@Generated(from="_ServiceOfferingResource", generator="Immutables")
public final class ServiceOfferingResource
extends _ServiceOfferingResource {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    private final Boolean available;
    private final BrokerCatalog brokerCatalog;
    private final String description;
    private final String documentationUrl;
    @Nullable
    private final Metadata metadata;
    private final String name;
    @Nullable
    private final ServiceOfferingRelationships relationships;
    @Nullable
    private final List<String> requires;
    private final Boolean shareable;
    @Nullable
    private final List<String> tags;

    private ServiceOfferingResource(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = ServiceOfferingResource.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.available = builder.available;
        this.brokerCatalog = builder.brokerCatalog;
        this.description = builder.description;
        this.documentationUrl = builder.documentationUrl;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.relationships = builder.relationships;
        this.requires = builder.requires == null ? null : ServiceOfferingResource.createUnmodifiableList(true, builder.requires);
        this.shareable = builder.shareable;
        this.tags = builder.tags == null ? null : ServiceOfferingResource.createUnmodifiableList(true, builder.tags);
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="available")
    public Boolean getAvailable() {
        return this.available;
    }

    @Override
    @JsonProperty(value="broker_catalog")
    public BrokerCatalog getBrokerCatalog() {
        return this.brokerCatalog;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="documentation_url")
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="relationships")
    @Nullable
    public ServiceOfferingRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="requires")
    @Nullable
    public List<String> getRequires() {
        return this.requires;
    }

    @Override
    @JsonProperty(value="shareable")
    public Boolean getShareable() {
        return this.shareable;
    }

    @Override
    @JsonProperty(value="tags")
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceOfferingResource && this.equalTo(0, (ServiceOfferingResource)another);
    }

    private boolean equalTo(int synthetic, ServiceOfferingResource another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && this.available.equals(another.available) && this.brokerCatalog.equals(another.brokerCatalog) && this.description.equals(another.description) && this.documentationUrl.equals(another.documentationUrl) && Objects.equals(this.metadata, another.metadata) && this.name.equals(another.name) && Objects.equals(this.relationships, another.relationships) && Objects.equals(this.requires, another.requires) && this.shareable.equals(another.shareable) && Objects.equals(this.tags, another.tags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + this.available.hashCode();
        h += (h << 5) + this.brokerCatalog.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.documentationUrl.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationships);
        h += (h << 5) + Objects.hashCode(this.requires);
        h += (h << 5) + this.shareable.hashCode();
        h += (h << 5) + Objects.hashCode(this.tags);
        return h;
    }

    public String toString() {
        return "ServiceOfferingResource{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", available=" + this.available + ", brokerCatalog=" + this.brokerCatalog + ", description=" + this.description + ", documentationUrl=" + this.documentationUrl + ", metadata=" + this.metadata + ", name=" + this.name + ", relationships=" + this.relationships + ", requires=" + this.requires + ", shareable=" + this.shareable + ", tags=" + this.tags + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ServiceOfferingResource fromJson(Json json) {
        Builder builder = ServiceOfferingResource.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.available != null) {
            builder.available(json.available);
        }
        if (json.brokerCatalog != null) {
            builder.brokerCatalog(json.brokerCatalog);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.documentationUrl != null) {
            builder.documentationUrl(json.documentationUrl);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.requires != null) {
            builder.addAllRequires(json.requires);
        }
        if (json.shareable != null) {
            builder.shareable(json.shareable);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_ServiceOfferingResource", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_AVAILABLE = 4L;
        private static final long INIT_BIT_BROKER_CATALOG = 8L;
        private static final long INIT_BIT_DESCRIPTION = 16L;
        private static final long INIT_BIT_DOCUMENTATION_URL = 32L;
        private static final long INIT_BIT_NAME = 64L;
        private static final long INIT_BIT_SHAREABLE = 128L;
        private long initBits = 255L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private Boolean available;
        private BrokerCatalog brokerCatalog;
        private String description;
        private String documentationUrl;
        private Metadata metadata;
        private String name;
        private ServiceOfferingRelationships relationships;
        private List<String> requires = null;
        private Boolean shareable;
        private List<String> tags = null;

        private Builder() {
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ServiceOffering instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ServiceOfferingResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ServiceOfferingResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            List<String> requiresValue;
            ServiceOfferingRelationships relationshipsValue;
            List<String> tagsValue;
            Metadata metadataValue;
            String updatedAtValue;
            Resource instance;
            long bits = 0L;
            if (object instanceof Resource) {
                instance = (Resource)object;
                if ((bits & 0x40L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 0x40L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x400L;
                }
                if ((bits & 0x1000L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x1000L;
                }
            }
            if (object instanceof ServiceOffering) {
                instance = (ServiceOffering)object;
                if ((bits & 1L) == 0L) {
                    this.shareable(((ServiceOffering)instance).getShareable());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.documentationUrl(((ServiceOffering)instance).getDocumentationUrl());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    metadataValue = ((ServiceOffering)instance).getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.available(((ServiceOffering)instance).getAvailable());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.description(((ServiceOffering)instance).getDescription());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    tagsValue = ((ServiceOffering)instance).getTags();
                    if (tagsValue != null) {
                        this.addAllTags(tagsValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    relationshipsValue = ((ServiceOffering)instance).getRelationships();
                    if (relationshipsValue != null) {
                        this.relationships(relationshipsValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.name(((ServiceOffering)instance).getName());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.brokerCatalog(((ServiceOffering)instance).getBrokerCatalog());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    requiresValue = ((ServiceOffering)instance).getRequires();
                    if (requiresValue != null) {
                        this.addAllRequires(requiresValue);
                    }
                    bits |= 0x2000L;
                }
            }
            if (object instanceof _ServiceOfferingResource) {
                instance = (_ServiceOfferingResource)object;
                if ((bits & 1L) == 0L) {
                    this.shareable(((ServiceOffering)instance).getShareable());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.documentationUrl(((ServiceOffering)instance).getDocumentationUrl());
                    bits |= 2L;
                }
                if ((bits & 0x80L) == 0L) {
                    relationshipsValue = ((ServiceOffering)instance).getRelationships();
                    if (relationshipsValue != null) {
                        this.relationships(relationshipsValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 4L) == 0L) {
                    metadataValue = ((ServiceOffering)instance).getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.available(((ServiceOffering)instance).getAvailable());
                    bits |= 8L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.name(((ServiceOffering)instance).getName());
                    bits |= 0x100L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.description(((ServiceOffering)instance).getDescription());
                    bits |= 0x10L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.brokerCatalog(((ServiceOffering)instance).getBrokerCatalog());
                    bits |= 0x800L;
                }
                if ((bits & 0x20L) == 0L) {
                    tagsValue = ((ServiceOffering)instance).getTags();
                    if (tagsValue != null) {
                        this.addAllTags(tagsValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x2000L) == 0L) {
                    requiresValue = ((ServiceOffering)instance).getRequires();
                    if (requiresValue != null) {
                        this.addAllRequires(requiresValue);
                    }
                    bits |= 0x2000L;
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="available")
        public final Builder available(Boolean available) {
            this.available = Objects.requireNonNull(available, "available");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="broker_catalog")
        public final Builder brokerCatalog(BrokerCatalog brokerCatalog) {
            this.brokerCatalog = Objects.requireNonNull(brokerCatalog, "brokerCatalog");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="documentation_url")
        public final Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = Objects.requireNonNull(documentationUrl, "documentationUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(@Nullable ServiceOfferingRelationships relationships) {
            this.relationships = relationships;
            return this;
        }

        public final Builder require(String element) {
            if (this.requires == null) {
                this.requires = new ArrayList<String>();
            }
            this.requires.add(Objects.requireNonNull(element, "requires element"));
            return this;
        }

        public final Builder requires(String ... elements) {
            if (this.requires == null) {
                this.requires = new ArrayList<String>();
            }
            for (String element : elements) {
                this.requires.add(Objects.requireNonNull(element, "requires element"));
            }
            return this;
        }

        @JsonProperty(value="requires")
        public final Builder requires(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.requires = null;
                return this;
            }
            this.requires = new ArrayList<String>();
            return this.addAllRequires(elements);
        }

        public final Builder addAllRequires(Iterable<String> elements) {
            Objects.requireNonNull(elements, "requires element");
            if (this.requires == null) {
                this.requires = new ArrayList<String>();
            }
            for (String element : elements) {
                this.requires.add(Objects.requireNonNull(element, "requires element"));
            }
            return this;
        }

        @JsonProperty(value="shareable")
        public final Builder shareable(Boolean shareable) {
            this.shareable = Objects.requireNonNull(shareable, "shareable");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tags(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="tags")
        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public ServiceOfferingResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ServiceOfferingResource(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("available");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("brokerCatalog");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("documentationUrl");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("shareable");
            }
            return "Cannot build ServiceOfferingResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ServiceOfferingResource", generator="Immutables")
    static final class Json
    extends _ServiceOfferingResource {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        Boolean available;
        BrokerCatalog brokerCatalog;
        String description;
        String documentationUrl;
        Metadata metadata;
        String name;
        ServiceOfferingRelationships relationships;
        List<String> requires = null;
        Boolean shareable;
        List<String> tags = null;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="available")
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @JsonProperty(value="broker_catalog")
        public void setBrokerCatalog(BrokerCatalog brokerCatalog) {
            this.brokerCatalog = brokerCatalog;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="documentation_url")
        public void setDocumentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(@Nullable ServiceOfferingRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="requires")
        public void setRequires(@Nullable List<String> requires) {
            this.requires = requires;
        }

        @JsonProperty(value="shareable")
        public void setShareable(Boolean shareable) {
            this.shareable = shareable;
        }

        @JsonProperty(value="tags")
        public void setTags(@Nullable List<String> tags) {
            this.tags = tags;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getAvailable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BrokerCatalog getBrokerCatalog() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDocumentationUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceOfferingRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getRequires() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getShareable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }
    }
}

