/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.logcache.v1.Counter;
import org.cloudfoundry.logcache.v1.Event;
import org.cloudfoundry.logcache.v1.Gauge;
import org.cloudfoundry.logcache.v1.Log;
import org.cloudfoundry.logcache.v1.Timer;
import org.cloudfoundry.logcache.v1._Envelope;
import org.immutables.value.Generated;

@JsonIgnoreProperties(value={"deprecated_tags"})
@Generated(from="_Envelope", generator="Immutables")
public final class Envelope
extends _Envelope {
    @Nullable
    private final Counter counter;
    @Nullable
    private final Event event;
    @Nullable
    private final Gauge gauge;
    @Nullable
    private final String instanceId;
    @Nullable
    private final Log log;
    @Nullable
    private final String sourceId;
    private final Map<String, String> tags;
    @Nullable
    private final Timer timer;
    @Nullable
    private final Long timestamp;

    private Envelope(Builder builder) {
        this.counter = builder.counter;
        this.event = builder.event;
        this.gauge = builder.gauge;
        this.instanceId = builder.instanceId;
        this.log = builder.log;
        this.sourceId = builder.sourceId;
        this.tags = Envelope.createUnmodifiableMap(false, false, builder.tags);
        this.timer = builder.timer;
        this.timestamp = builder.timestamp;
    }

    @Override
    @JsonProperty(value="counter")
    @Nullable
    public Counter getCounter() {
        return this.counter;
    }

    @Override
    @JsonProperty(value="event")
    @Nullable
    public Event getEvent() {
        return this.event;
    }

    @Override
    @JsonProperty(value="gauge")
    @Nullable
    public Gauge getGauge() {
        return this.gauge;
    }

    @Override
    @JsonProperty(value="instance_id")
    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @JsonProperty(value="log")
    @Nullable
    public Log getLog() {
        return this.log;
    }

    @Override
    @JsonProperty(value="source_id")
    @Nullable
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    @JsonProperty(value="tags")
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="timer")
    @Nullable
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    @JsonProperty(value="timestamp")
    @Nullable
    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Envelope && this.equalTo(0, (Envelope)another);
    }

    private boolean equalTo(int synthetic, Envelope another) {
        return Objects.equals(this.counter, another.counter) && Objects.equals(this.event, another.event) && Objects.equals(this.gauge, another.gauge) && Objects.equals(this.instanceId, another.instanceId) && Objects.equals(this.log, another.log) && Objects.equals(this.sourceId, another.sourceId) && this.tags.equals(another.tags) && Objects.equals(this.timer, another.timer) && Objects.equals(this.timestamp, another.timestamp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.counter);
        h += (h << 5) + Objects.hashCode(this.event);
        h += (h << 5) + Objects.hashCode(this.gauge);
        h += (h << 5) + Objects.hashCode(this.instanceId);
        h += (h << 5) + Objects.hashCode(this.log);
        h += (h << 5) + Objects.hashCode(this.sourceId);
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + Objects.hashCode(this.timer);
        h += (h << 5) + Objects.hashCode(this.timestamp);
        return h;
    }

    public String toString() {
        return "Envelope{counter=" + this.counter + ", event=" + this.event + ", gauge=" + this.gauge + ", instanceId=" + this.instanceId + ", log=" + this.log + ", sourceId=" + this.sourceId + ", tags=" + this.tags + ", timer=" + this.timer + ", timestamp=" + this.timestamp + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Envelope fromJson(Json json) {
        Builder builder = Envelope.builder();
        if (json.counter != null) {
            builder.counter(json.counter);
        }
        if (json.event != null) {
            builder.event(json.event);
        }
        if (json.gauge != null) {
            builder.gauge(json.gauge);
        }
        if (json.instanceId != null) {
            builder.instanceId(json.instanceId);
        }
        if (json.log != null) {
            builder.log(json.log);
        }
        if (json.sourceId != null) {
            builder.sourceId(json.sourceId);
        }
        if (json.tags != null) {
            builder.putAllTags(json.tags);
        }
        if (json.timer != null) {
            builder.timer(json.timer);
        }
        if (json.timestamp != null) {
            builder.timestamp(json.timestamp);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_Envelope", generator="Immutables")
    public static final class Builder {
        private Counter counter;
        private Event event;
        private Gauge gauge;
        private String instanceId;
        private Log log;
        private String sourceId;
        private Map<String, String> tags = new LinkedHashMap<String, String>();
        private Timer timer;
        private Long timestamp;

        private Builder() {
        }

        public final Builder from(Envelope instance) {
            return this.from((_Envelope)instance);
        }

        final Builder from(_Envelope instance) {
            Long timestampValue;
            String sourceIdValue;
            Log logValue;
            String instanceIdValue;
            Gauge gaugeValue;
            Event eventValue;
            Objects.requireNonNull(instance, "instance");
            Counter counterValue = instance.getCounter();
            if (counterValue != null) {
                this.counter(counterValue);
            }
            if ((eventValue = instance.getEvent()) != null) {
                this.event(eventValue);
            }
            if ((gaugeValue = instance.getGauge()) != null) {
                this.gauge(gaugeValue);
            }
            if ((instanceIdValue = instance.getInstanceId()) != null) {
                this.instanceId(instanceIdValue);
            }
            if ((logValue = instance.getLog()) != null) {
                this.log(logValue);
            }
            if ((sourceIdValue = instance.getSourceId()) != null) {
                this.sourceId(sourceIdValue);
            }
            this.putAllTags(instance.getTags());
            Timer timerValue = instance.getTimer();
            if (timerValue != null) {
                this.timer(timerValue);
            }
            if ((timestampValue = instance.getTimestamp()) != null) {
                this.timestamp(timestampValue);
            }
            return this;
        }

        @JsonProperty(value="counter")
        public final Builder counter(@Nullable Counter counter) {
            this.counter = counter;
            return this;
        }

        @JsonProperty(value="event")
        public final Builder event(@Nullable Event event) {
            this.event = event;
            return this;
        }

        @JsonProperty(value="gauge")
        public final Builder gauge(@Nullable Gauge gauge) {
            this.gauge = gauge;
            return this;
        }

        @JsonProperty(value="instance_id")
        public final Builder instanceId(@Nullable String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @JsonProperty(value="log")
        public final Builder log(@Nullable Log log) {
            this.log = log;
            return this;
        }

        @JsonProperty(value="source_id")
        public final Builder sourceId(@Nullable String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final Builder tag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public final Builder tag(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.tags.put(k, v);
            return this;
        }

        @JsonProperty(value="tags")
        public final Builder tags(Map<String, ? extends String> entries) {
            this.tags.clear();
            return this.putAllTags(entries);
        }

        public final Builder putAllTags(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.tags.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="timer")
        public final Builder timer(@Nullable Timer timer) {
            this.timer = timer;
            return this;
        }

        @JsonProperty(value="timestamp")
        public final Builder timestamp(@Nullable Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Envelope build() {
            return new Envelope(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_Envelope", generator="Immutables")
    static final class Json
    extends _Envelope {
        Counter counter;
        Event event;
        Gauge gauge;
        String instanceId;
        Log log;
        String sourceId;
        Map<String, String> tags = Collections.emptyMap();
        Timer timer;
        Long timestamp;

        Json() {
        }

        @JsonProperty(value="counter")
        public void setCounter(@Nullable Counter counter) {
            this.counter = counter;
        }

        @JsonProperty(value="event")
        public void setEvent(@Nullable Event event) {
            this.event = event;
        }

        @JsonProperty(value="gauge")
        public void setGauge(@Nullable Gauge gauge) {
            this.gauge = gauge;
        }

        @JsonProperty(value="instance_id")
        public void setInstanceId(@Nullable String instanceId) {
            this.instanceId = instanceId;
        }

        @JsonProperty(value="log")
        public void setLog(@Nullable Log log) {
            this.log = log;
        }

        @JsonProperty(value="source_id")
        public void setSourceId(@Nullable String sourceId) {
            this.sourceId = sourceId;
        }

        @JsonProperty(value="tags")
        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="timer")
        public void setTimer(@Nullable Timer timer) {
            this.timer = timer;
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(@Nullable Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public Counter getCounter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Event getEvent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Gauge getGauge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getInstanceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Log getLog() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSourceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Timer getTimer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getTimestamp() {
            throw new UnsupportedOperationException();
        }
    }
}

