/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.logcache.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.logcache.v1.EnvelopeType;
import org.cloudfoundry.logcache.v1._ReadRequest;
import org.immutables.value.Generated;

@Generated(from="_ReadRequest", generator="Immutables")
public final class ReadRequest
extends _ReadRequest {
    @Nullable
    private final Boolean descending;
    @Nullable
    private final Long endTime;
    @Nullable
    private final List<EnvelopeType> envelopeTypes;
    @Nullable
    private final Integer limit;
    @Nullable
    private final String nameFilter;
    private final String sourceId;
    @Nullable
    private final Long startTime;

    private ReadRequest(Builder builder) {
        this.descending = builder.descending;
        this.endTime = builder.endTime;
        this.envelopeTypes = builder.envelopeTypes == null ? null : ReadRequest.createUnmodifiableList(true, builder.envelopeTypes);
        this.limit = builder.limit;
        this.nameFilter = builder.nameFilter;
        this.sourceId = builder.sourceId;
        this.startTime = builder.startTime;
    }

    @Override
    @Nullable
    public Boolean getDescending() {
        return this.descending;
    }

    @Override
    @Nullable
    public Long getEndTime() {
        return this.endTime;
    }

    @Override
    @Nullable
    public List<EnvelopeType> getEnvelopeTypes() {
        return this.envelopeTypes;
    }

    @Override
    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    @Nullable
    public String getNameFilter() {
        return this.nameFilter;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    @Nullable
    public Long getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReadRequest && this.equalTo(0, (ReadRequest)another);
    }

    private boolean equalTo(int synthetic, ReadRequest another) {
        return Objects.equals(this.descending, another.descending) && Objects.equals(this.endTime, another.endTime) && Objects.equals(this.envelopeTypes, another.envelopeTypes) && Objects.equals(this.limit, another.limit) && Objects.equals(this.nameFilter, another.nameFilter) && this.sourceId.equals(another.sourceId) && Objects.equals(this.startTime, another.startTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.descending);
        h += (h << 5) + Objects.hashCode(this.endTime);
        h += (h << 5) + Objects.hashCode(this.envelopeTypes);
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.nameFilter);
        h += (h << 5) + this.sourceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.startTime);
        return h;
    }

    public String toString() {
        return "ReadRequest{descending=" + this.descending + ", endTime=" + this.endTime + ", envelopeTypes=" + this.envelopeTypes + ", limit=" + this.limit + ", nameFilter=" + this.nameFilter + ", sourceId=" + this.sourceId + ", startTime=" + this.startTime + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ReadRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_ID = 1L;
        private long initBits = 1L;
        private Boolean descending;
        private Long endTime;
        private List<EnvelopeType> envelopeTypes = null;
        private Integer limit;
        private String nameFilter;
        private String sourceId;
        private Long startTime;

        private Builder() {
        }

        public final Builder from(ReadRequest instance) {
            return this.from((_ReadRequest)instance);
        }

        final Builder from(_ReadRequest instance) {
            String nameFilterValue;
            Integer limitValue;
            List<EnvelopeType> envelopeTypesValue;
            Long endTimeValue;
            Objects.requireNonNull(instance, "instance");
            Boolean descendingValue = instance.getDescending();
            if (descendingValue != null) {
                this.descending(descendingValue);
            }
            if ((endTimeValue = instance.getEndTime()) != null) {
                this.endTime(endTimeValue);
            }
            if ((envelopeTypesValue = instance.getEnvelopeTypes()) != null) {
                this.addAllEnvelopeTypes(envelopeTypesValue);
            }
            if ((limitValue = instance.getLimit()) != null) {
                this.limit(limitValue);
            }
            if ((nameFilterValue = instance.getNameFilter()) != null) {
                this.nameFilter(nameFilterValue);
            }
            this.sourceId(instance.getSourceId());
            Long startTimeValue = instance.getStartTime();
            if (startTimeValue != null) {
                this.startTime(startTimeValue);
            }
            return this;
        }

        public final Builder descending(@Nullable Boolean descending) {
            this.descending = descending;
            return this;
        }

        public final Builder endTime(@Nullable Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Builder envelopeType(EnvelopeType element) {
            if (this.envelopeTypes == null) {
                this.envelopeTypes = new ArrayList<EnvelopeType>();
            }
            this.envelopeTypes.add(Objects.requireNonNull(element, "envelopeTypes element"));
            return this;
        }

        public final Builder envelopeTypes(EnvelopeType ... elements) {
            if (this.envelopeTypes == null) {
                this.envelopeTypes = new ArrayList<EnvelopeType>();
            }
            for (EnvelopeType element : elements) {
                this.envelopeTypes.add(Objects.requireNonNull(element, "envelopeTypes element"));
            }
            return this;
        }

        public final Builder envelopeTypes(@Nullable Iterable<? extends EnvelopeType> elements) {
            if (elements == null) {
                this.envelopeTypes = null;
                return this;
            }
            this.envelopeTypes = new ArrayList<EnvelopeType>();
            return this.addAllEnvelopeTypes(elements);
        }

        public final Builder addAllEnvelopeTypes(Iterable<? extends EnvelopeType> elements) {
            Objects.requireNonNull(elements, "envelopeTypes element");
            if (this.envelopeTypes == null) {
                this.envelopeTypes = new ArrayList<EnvelopeType>();
            }
            for (EnvelopeType envelopeType : elements) {
                this.envelopeTypes.add(Objects.requireNonNull(envelopeType, "envelopeTypes element"));
            }
            return this;
        }

        public final Builder limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Builder nameFilter(@Nullable String nameFilter) {
            this.nameFilter = nameFilter;
            return this;
        }

        public final Builder sourceId(String sourceId) {
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder startTime(@Nullable Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public ReadRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ReadRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceId");
            }
            return "Cannot build ReadRequest, some of required attributes are not set " + attributes;
        }
    }
}

