package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Net Info Port details
 */
@Generated(from = "_NetInfoPorts", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class NetInfoPorts extends org.cloudfoundry.client.v2.applications._NetInfoPorts {
  private final Integer containerPort;
  private final Integer hostPort;

  private NetInfoPorts(NetInfoPorts.Builder builder) {
    this.containerPort = builder.containerPort;
    this.hostPort = builder.hostPort;
  }

  /**
   * @return The value of the {@code containerPort} attribute
   */
  @JsonProperty("container_port")
  @Override
  public Integer getContainerPort() {
    return containerPort;
  }

  /**
   * @return The value of the {@code hostPort} attribute
   */
  @JsonProperty("host_port")
  @Override
  public Integer getHostPort() {
    return hostPort;
  }

  /**
   * This instance is equal to all instances of {@code NetInfoPorts} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof NetInfoPorts
        && equalTo(0, (NetInfoPorts) another);
  }

  private boolean equalTo(int synthetic, NetInfoPorts another) {
    return containerPort.equals(another.containerPort)
        && hostPort.equals(another.hostPort);
  }

  /**
   * Computes a hash code from attributes: {@code containerPort}, {@code hostPort}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + containerPort.hashCode();
    h += (h << 5) + hostPort.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NetInfoPorts} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NetInfoPorts{"
        + "containerPort=" + containerPort
        + ", hostPort=" + hostPort
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_NetInfoPorts", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._NetInfoPorts {
    Integer containerPort;
    Integer hostPort;
    @JsonProperty("container_port")
    public void setContainerPort(Integer containerPort) {
      this.containerPort = containerPort;
    }
    @JsonProperty("host_port")
    public void setHostPort(Integer hostPort) {
      this.hostPort = hostPort;
    }
    @Override
    public Integer getContainerPort() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getHostPort() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static NetInfoPorts fromJson(Json json) {
    NetInfoPorts.Builder builder = NetInfoPorts.builder();
    if (json.containerPort != null) {
      builder.containerPort(json.containerPort);
    }
    if (json.hostPort != null) {
      builder.hostPort(json.hostPort);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link NetInfoPorts NetInfoPorts}.
   * <pre>
   * NetInfoPorts.builder()
   *    .containerPort(Integer) // required {@link NetInfoPorts#getContainerPort() containerPort}
   *    .hostPort(Integer) // required {@link NetInfoPorts#getHostPort() hostPort}
   *    .build();
   * </pre>
   * @return A new NetInfoPorts builder
   */
  public static NetInfoPorts.Builder builder() {
    return new NetInfoPorts.Builder();
  }

  /**
   * Builds instances of type {@link NetInfoPorts NetInfoPorts}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_NetInfoPorts", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONTAINER_PORT = 0x1L;
    private static final long INIT_BIT_HOST_PORT = 0x2L;
    private long initBits = 0x3L;

    private Integer containerPort;
    private Integer hostPort;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NetInfoPorts} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NetInfoPorts instance) {
      return from((_NetInfoPorts) instance);
    }

    /**
     * Copy abstract value type {@code _NetInfoPorts} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_NetInfoPorts instance) {
      Objects.requireNonNull(instance, "instance");
      containerPort(instance.getContainerPort());
      hostPort(instance.getHostPort());
      return this;
    }

    /**
     * Initializes the value for the {@link NetInfoPorts#getContainerPort() containerPort} attribute.
     * @param containerPort The value for containerPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("container_port")
    public final Builder containerPort(Integer containerPort) {
      this.containerPort = Objects.requireNonNull(containerPort, "containerPort");
      initBits &= ~INIT_BIT_CONTAINER_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link NetInfoPorts#getHostPort() hostPort} attribute.
     * @param hostPort The value for hostPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("host_port")
    public final Builder hostPort(Integer hostPort) {
      this.hostPort = Objects.requireNonNull(hostPort, "hostPort");
      initBits &= ~INIT_BIT_HOST_PORT;
      return this;
    }

    /**
     * Builds a new {@link NetInfoPorts NetInfoPorts}.
     * @return An immutable instance of NetInfoPorts
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public NetInfoPorts build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new NetInfoPorts(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTAINER_PORT) != 0) attributes.add("containerPort");
      if ((initBits & INIT_BIT_HOST_PORT) != 0) attributes.add("hostPort");
      return "Cannot build NetInfoPorts, some of required attributes are not set " + attributes;
    }
  }
}
