package org.cloudfoundry.client.v2.buildpacks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload to Upload a Buildpack
 */
@Generated(from = "_UploadBuildpackRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UploadBuildpackRequest
    extends org.cloudfoundry.client.v2.buildpacks._UploadBuildpackRequest {
  private final Path buildpack;
  private final String buildpackId;
  private final String filename;

  private UploadBuildpackRequest(UploadBuildpackRequest.Builder builder) {
    this.buildpack = builder.buildpack;
    this.buildpackId = builder.buildpackId;
    this.filename = builder.filename;
  }

  /**
   * A binary zip file containing the buildpack bits.
   */
  @Override
  public Path getBuildpack() {
    return buildpack;
  }

  /**
   * The buildpack id
   */
  @Override
  public String getBuildpackId() {
    return buildpackId;
  }

  /**
   * The filename
   */
  @Override
  public String getFilename() {
    return filename;
  }

  /**
   * This instance is equal to all instances of {@code UploadBuildpackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UploadBuildpackRequest
        && equalTo(0, (UploadBuildpackRequest) another);
  }

  private boolean equalTo(int synthetic, UploadBuildpackRequest another) {
    return buildpack.equals(another.buildpack)
        && buildpackId.equals(another.buildpackId)
        && filename.equals(another.filename);
  }

  /**
   * Computes a hash code from attributes: {@code buildpack}, {@code buildpackId}, {@code filename}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + buildpack.hashCode();
    h += (h << 5) + buildpackId.hashCode();
    h += (h << 5) + filename.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UploadBuildpackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UploadBuildpackRequest{"
        + "buildpack=" + buildpack
        + ", buildpackId=" + buildpackId
        + ", filename=" + filename
        + "}";
  }

  /**
   * Creates a builder for {@link UploadBuildpackRequest UploadBuildpackRequest}.
   * <pre>
   * UploadBuildpackRequest.builder()
   *    .buildpack(java.nio.file.Path) // required {@link UploadBuildpackRequest#getBuildpack() buildpack}
   *    .buildpackId(String) // required {@link UploadBuildpackRequest#getBuildpackId() buildpackId}
   *    .filename(String) // required {@link UploadBuildpackRequest#getFilename() filename}
   *    .build();
   * </pre>
   * @return A new UploadBuildpackRequest builder
   */
  public static UploadBuildpackRequest.Builder builder() {
    return new UploadBuildpackRequest.Builder();
  }

  /**
   * Builds instances of type {@link UploadBuildpackRequest UploadBuildpackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UploadBuildpackRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BUILDPACK = 0x1L;
    private static final long INIT_BIT_BUILDPACK_ID = 0x2L;
    private static final long INIT_BIT_FILENAME = 0x4L;
    private long initBits = 0x7L;

    private Path buildpack;
    private String buildpackId;
    private String filename;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UploadBuildpackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UploadBuildpackRequest instance) {
      return from((_UploadBuildpackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UploadBuildpackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UploadBuildpackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      buildpack(instance.getBuildpack());
      buildpackId(instance.getBuildpackId());
      filename(instance.getFilename());
      return this;
    }

    /**
     * Initializes the value for the {@link UploadBuildpackRequest#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(Path buildpack) {
      this.buildpack = Objects.requireNonNull(buildpack, "buildpack");
      initBits &= ~INIT_BIT_BUILDPACK;
      return this;
    }

    /**
     * Initializes the value for the {@link UploadBuildpackRequest#getBuildpackId() buildpackId} attribute.
     * @param buildpackId The value for buildpackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpackId(String buildpackId) {
      this.buildpackId = Objects.requireNonNull(buildpackId, "buildpackId");
      initBits &= ~INIT_BIT_BUILDPACK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UploadBuildpackRequest#getFilename() filename} attribute.
     * @param filename The value for filename 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder filename(String filename) {
      this.filename = Objects.requireNonNull(filename, "filename");
      initBits &= ~INIT_BIT_FILENAME;
      return this;
    }

    /**
     * Builds a new {@link UploadBuildpackRequest UploadBuildpackRequest}.
     * @return An immutable instance of UploadBuildpackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UploadBuildpackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UploadBuildpackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BUILDPACK) != 0) attributes.add("buildpack");
      if ((initBits & INIT_BIT_BUILDPACK_ID) != 0) attributes.add("buildpackId");
      if ((initBits & INIT_BIT_FILENAME) != 0) attributes.add("filename");
      return "Cannot build UploadBuildpackRequest, some of required attributes are not set " + attributes;
    }
  }
}
