package org.cloudfoundry.client.v2.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Event operation
 */
@Generated(from = "_GetEventRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetEventRequest extends org.cloudfoundry.client.v2.events._GetEventRequest {
  private final String eventId;

  private GetEventRequest(GetEventRequest.Builder builder) {
    this.eventId = builder.eventId;
  }

  /**
   * The event id
   */
  @Override
  public String getEventId() {
    return eventId;
  }

  /**
   * This instance is equal to all instances of {@code GetEventRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetEventRequest
        && equalTo(0, (GetEventRequest) another);
  }

  private boolean equalTo(int synthetic, GetEventRequest another) {
    return eventId.equals(another.eventId);
  }

  /**
   * Computes a hash code from attributes: {@code eventId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + eventId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetEventRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetEventRequest{"
        + "eventId=" + eventId
        + "}";
  }

  /**
   * Creates a builder for {@link GetEventRequest GetEventRequest}.
   * <pre>
   * GetEventRequest.builder()
   *    .eventId(String) // required {@link GetEventRequest#getEventId() eventId}
   *    .build();
   * </pre>
   * @return A new GetEventRequest builder
   */
  public static GetEventRequest.Builder builder() {
    return new GetEventRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetEventRequest GetEventRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetEventRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_EVENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String eventId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetEventRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetEventRequest instance) {
      return from((_GetEventRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetEventRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetEventRequest instance) {
      Objects.requireNonNull(instance, "instance");
      eventId(instance.getEventId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetEventRequest#getEventId() eventId} attribute.
     * @param eventId The value for eventId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder eventId(String eventId) {
      this.eventId = Objects.requireNonNull(eventId, "eventId");
      initBits &= ~INIT_BIT_EVENT_ID;
      return this;
    }

    /**
     * Builds a new {@link GetEventRequest GetEventRequest}.
     * @return An immutable instance of GetEventRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetEventRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetEventRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EVENT_ID) != 0) attributes.add("eventId");
      return "Cannot build GetEventRequest, some of required attributes are not set " + attributes;
    }
  }
}
