package org.cloudfoundry.client.v2.info;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response payload for the Info operation
 */
@Generated(from = "_GetInfoResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetInfoResponse extends org.cloudfoundry.client.v2.info._GetInfoResponse {
  private final @Nullable String apiVersion;
  private final @Nullable String applicationSshEndpoint;
  private final @Nullable String applicationSshHostKeyFingerprint;
  private final @Nullable String applicationSshOAuthClient;
  private final @Nullable String authorizationEndpoint;
  private final @Nullable String buildNumber;
  private final @Nullable String description;
  private final @Nullable String dopplerLoggingEndpoint;
  private final @Nullable String loggingEndpoint;
  private final @Nullable String minCliVersion;
  private final @Nullable String minRecommendedCliVersion;
  private final @Nullable String name;
  private final @Nullable String osbapiVersion;
  private final @Nullable String routingEndpoint;
  private final @Nullable String support;
  private final @Nullable String tokenEndpoint;
  private final @Nullable String user;
  private final @Nullable Integer version;

  private GetInfoResponse(GetInfoResponse.Builder builder) {
    this.apiVersion = builder.apiVersion;
    this.applicationSshEndpoint = builder.applicationSshEndpoint;
    this.applicationSshHostKeyFingerprint = builder.applicationSshHostKeyFingerprint;
    this.applicationSshOAuthClient = builder.applicationSshOAuthClient;
    this.authorizationEndpoint = builder.authorizationEndpoint;
    this.buildNumber = builder.buildNumber;
    this.description = builder.description;
    this.dopplerLoggingEndpoint = builder.dopplerLoggingEndpoint;
    this.loggingEndpoint = builder.loggingEndpoint;
    this.minCliVersion = builder.minCliVersion;
    this.minRecommendedCliVersion = builder.minRecommendedCliVersion;
    this.name = builder.name;
    this.osbapiVersion = builder.osbapiVersion;
    this.routingEndpoint = builder.routingEndpoint;
    this.support = builder.support;
    this.tokenEndpoint = builder.tokenEndpoint;
    this.user = builder.user;
    this.version = builder.version;
  }

  /**
   * The API version
   */
  @JsonProperty("api_version")
  @Override
  public @Nullable String getApiVersion() {
    return apiVersion;
  }

  /**
   * The application SSH endpoint
   */
  @JsonProperty("app_ssh_endpoint")
  @Override
  public @Nullable String getApplicationSshEndpoint() {
    return applicationSshEndpoint;
  }

  /**
   * The application SSH host key fingerprint
   */
  @JsonProperty("app_ssh_host_key_fingerprint")
  @Override
  public @Nullable String getApplicationSshHostKeyFingerprint() {
    return applicationSshHostKeyFingerprint;
  }

  /**
   * The application SSH OAuth client
   */
  @JsonProperty("app_ssh_oauth_client")
  @Override
  public @Nullable String getApplicationSshOAuthClient() {
    return applicationSshOAuthClient;
  }

  /**
   * The authorization endpoint
   */
  @JsonProperty("authorization_endpoint")
  @Override
  public @Nullable String getAuthorizationEndpoint() {
    return authorizationEndpoint;
  }

  /**
   * The build number
   */
  @JsonProperty("build")
  @Override
  public @Nullable String getBuildNumber() {
    return buildNumber;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The doppler logging endpoint
   */
  @JsonProperty("doppler_logging_endpoint")
  @Override
  public @Nullable String getDopplerLoggingEndpoint() {
    return dopplerLoggingEndpoint;
  }

  /**
   * The logging endpoint
   */
  @JsonProperty("logging_endpoint")
  @Override
  public @Nullable String getLoggingEndpoint() {
    return loggingEndpoint;
  }

  /**
   * The minimum CLI version
   */
  @JsonProperty("min_cli_version")
  @Override
  public @Nullable String getMinCliVersion() {
    return minCliVersion;
  }

  /**
   * The minimum recommended CLI version
   */
  @JsonProperty("min_recommended_cli_version")
  @Override
  public @Nullable String getMinRecommendedCliVersion() {
    return minRecommendedCliVersion;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The version of the supported Open Service Broker API
   */
  @JsonProperty("osbapi_version")
  @Override
  public @Nullable String getOsbapiVersion() {
    return osbapiVersion;
  }

  /**
   * The routing endpoint
   */
  @JsonProperty("routing_endpoint")
  @Override
  public @Nullable String getRoutingEndpoint() {
    return routingEndpoint;
  }

  /**
   * The support url
   */
  @JsonProperty("support")
  @Override
  public @Nullable String getSupport() {
    return support;
  }

  /**
   * The token endpoint
   */
  @JsonProperty("token_endpoint")
  @Override
  public @Nullable String getTokenEndpoint() {
    return tokenEndpoint;
  }

  /**
   * The user
   */
  @JsonProperty("user")
  @Override
  public @Nullable String getUser() {
    return user;
  }

  /**
   * The version
   */
  @JsonProperty("version")
  @Override
  public @Nullable Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code GetInfoResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetInfoResponse
        && equalTo(0, (GetInfoResponse) another);
  }

  private boolean equalTo(int synthetic, GetInfoResponse another) {
    return Objects.equals(apiVersion, another.apiVersion)
        && Objects.equals(applicationSshEndpoint, another.applicationSshEndpoint)
        && Objects.equals(applicationSshHostKeyFingerprint, another.applicationSshHostKeyFingerprint)
        && Objects.equals(applicationSshOAuthClient, another.applicationSshOAuthClient)
        && Objects.equals(authorizationEndpoint, another.authorizationEndpoint)
        && Objects.equals(buildNumber, another.buildNumber)
        && Objects.equals(description, another.description)
        && Objects.equals(dopplerLoggingEndpoint, another.dopplerLoggingEndpoint)
        && Objects.equals(loggingEndpoint, another.loggingEndpoint)
        && Objects.equals(minCliVersion, another.minCliVersion)
        && Objects.equals(minRecommendedCliVersion, another.minRecommendedCliVersion)
        && Objects.equals(name, another.name)
        && Objects.equals(osbapiVersion, another.osbapiVersion)
        && Objects.equals(routingEndpoint, another.routingEndpoint)
        && Objects.equals(support, another.support)
        && Objects.equals(tokenEndpoint, another.tokenEndpoint)
        && Objects.equals(user, another.user)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code apiVersion}, {@code applicationSshEndpoint}, {@code applicationSshHostKeyFingerprint}, {@code applicationSshOAuthClient}, {@code authorizationEndpoint}, {@code buildNumber}, {@code description}, {@code dopplerLoggingEndpoint}, {@code loggingEndpoint}, {@code minCliVersion}, {@code minRecommendedCliVersion}, {@code name}, {@code osbapiVersion}, {@code routingEndpoint}, {@code support}, {@code tokenEndpoint}, {@code user}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(apiVersion);
    h += (h << 5) + Objects.hashCode(applicationSshEndpoint);
    h += (h << 5) + Objects.hashCode(applicationSshHostKeyFingerprint);
    h += (h << 5) + Objects.hashCode(applicationSshOAuthClient);
    h += (h << 5) + Objects.hashCode(authorizationEndpoint);
    h += (h << 5) + Objects.hashCode(buildNumber);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(dopplerLoggingEndpoint);
    h += (h << 5) + Objects.hashCode(loggingEndpoint);
    h += (h << 5) + Objects.hashCode(minCliVersion);
    h += (h << 5) + Objects.hashCode(minRecommendedCliVersion);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(osbapiVersion);
    h += (h << 5) + Objects.hashCode(routingEndpoint);
    h += (h << 5) + Objects.hashCode(support);
    h += (h << 5) + Objects.hashCode(tokenEndpoint);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code GetInfoResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetInfoResponse{"
        + "apiVersion=" + apiVersion
        + ", applicationSshEndpoint=" + applicationSshEndpoint
        + ", applicationSshHostKeyFingerprint=" + applicationSshHostKeyFingerprint
        + ", applicationSshOAuthClient=" + applicationSshOAuthClient
        + ", authorizationEndpoint=" + authorizationEndpoint
        + ", buildNumber=" + buildNumber
        + ", description=" + description
        + ", dopplerLoggingEndpoint=" + dopplerLoggingEndpoint
        + ", loggingEndpoint=" + loggingEndpoint
        + ", minCliVersion=" + minCliVersion
        + ", minRecommendedCliVersion=" + minRecommendedCliVersion
        + ", name=" + name
        + ", osbapiVersion=" + osbapiVersion
        + ", routingEndpoint=" + routingEndpoint
        + ", support=" + support
        + ", tokenEndpoint=" + tokenEndpoint
        + ", user=" + user
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetInfoResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.info._GetInfoResponse {
    String apiVersion;
    String applicationSshEndpoint;
    String applicationSshHostKeyFingerprint;
    String applicationSshOAuthClient;
    String authorizationEndpoint;
    String buildNumber;
    String description;
    String dopplerLoggingEndpoint;
    String loggingEndpoint;
    String minCliVersion;
    String minRecommendedCliVersion;
    String name;
    String osbapiVersion;
    String routingEndpoint;
    String support;
    String tokenEndpoint;
    String user;
    Integer version;
    @JsonProperty("api_version")
    public void setApiVersion(@Nullable String apiVersion) {
      this.apiVersion = apiVersion;
    }
    @JsonProperty("app_ssh_endpoint")
    public void setApplicationSshEndpoint(@Nullable String applicationSshEndpoint) {
      this.applicationSshEndpoint = applicationSshEndpoint;
    }
    @JsonProperty("app_ssh_host_key_fingerprint")
    public void setApplicationSshHostKeyFingerprint(@Nullable String applicationSshHostKeyFingerprint) {
      this.applicationSshHostKeyFingerprint = applicationSshHostKeyFingerprint;
    }
    @JsonProperty("app_ssh_oauth_client")
    public void setApplicationSshOAuthClient(@Nullable String applicationSshOAuthClient) {
      this.applicationSshOAuthClient = applicationSshOAuthClient;
    }
    @JsonProperty("authorization_endpoint")
    public void setAuthorizationEndpoint(@Nullable String authorizationEndpoint) {
      this.authorizationEndpoint = authorizationEndpoint;
    }
    @JsonProperty("build")
    public void setBuildNumber(@Nullable String buildNumber) {
      this.buildNumber = buildNumber;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("doppler_logging_endpoint")
    public void setDopplerLoggingEndpoint(@Nullable String dopplerLoggingEndpoint) {
      this.dopplerLoggingEndpoint = dopplerLoggingEndpoint;
    }
    @JsonProperty("logging_endpoint")
    public void setLoggingEndpoint(@Nullable String loggingEndpoint) {
      this.loggingEndpoint = loggingEndpoint;
    }
    @JsonProperty("min_cli_version")
    public void setMinCliVersion(@Nullable String minCliVersion) {
      this.minCliVersion = minCliVersion;
    }
    @JsonProperty("min_recommended_cli_version")
    public void setMinRecommendedCliVersion(@Nullable String minRecommendedCliVersion) {
      this.minRecommendedCliVersion = minRecommendedCliVersion;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("osbapi_version")
    public void setOsbapiVersion(@Nullable String osbapiVersion) {
      this.osbapiVersion = osbapiVersion;
    }
    @JsonProperty("routing_endpoint")
    public void setRoutingEndpoint(@Nullable String routingEndpoint) {
      this.routingEndpoint = routingEndpoint;
    }
    @JsonProperty("support")
    public void setSupport(@Nullable String support) {
      this.support = support;
    }
    @JsonProperty("token_endpoint")
    public void setTokenEndpoint(@Nullable String tokenEndpoint) {
      this.tokenEndpoint = tokenEndpoint;
    }
    @JsonProperty("user")
    public void setUser(@Nullable String user) {
      this.user = user;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable Integer version) {
      this.version = version;
    }
    @Override
    public String getApiVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationSshEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationSshHostKeyFingerprint() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationSshOAuthClient() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthorizationEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public String getBuildNumber() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getDopplerLoggingEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public String getLoggingEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public String getMinCliVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getMinRecommendedCliVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOsbapiVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getRoutingEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public String getSupport() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public String getUser() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetInfoResponse fromJson(Json json) {
    GetInfoResponse.Builder builder = GetInfoResponse.builder();
    if (json.apiVersion != null) {
      builder.apiVersion(json.apiVersion);
    }
    if (json.applicationSshEndpoint != null) {
      builder.applicationSshEndpoint(json.applicationSshEndpoint);
    }
    if (json.applicationSshHostKeyFingerprint != null) {
      builder.applicationSshHostKeyFingerprint(json.applicationSshHostKeyFingerprint);
    }
    if (json.applicationSshOAuthClient != null) {
      builder.applicationSshOAuthClient(json.applicationSshOAuthClient);
    }
    if (json.authorizationEndpoint != null) {
      builder.authorizationEndpoint(json.authorizationEndpoint);
    }
    if (json.buildNumber != null) {
      builder.buildNumber(json.buildNumber);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.dopplerLoggingEndpoint != null) {
      builder.dopplerLoggingEndpoint(json.dopplerLoggingEndpoint);
    }
    if (json.loggingEndpoint != null) {
      builder.loggingEndpoint(json.loggingEndpoint);
    }
    if (json.minCliVersion != null) {
      builder.minCliVersion(json.minCliVersion);
    }
    if (json.minRecommendedCliVersion != null) {
      builder.minRecommendedCliVersion(json.minRecommendedCliVersion);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.osbapiVersion != null) {
      builder.osbapiVersion(json.osbapiVersion);
    }
    if (json.routingEndpoint != null) {
      builder.routingEndpoint(json.routingEndpoint);
    }
    if (json.support != null) {
      builder.support(json.support);
    }
    if (json.tokenEndpoint != null) {
      builder.tokenEndpoint(json.tokenEndpoint);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetInfoResponse GetInfoResponse}.
   * <pre>
   * GetInfoResponse.builder()
   *    .apiVersion(String | null) // nullable {@link GetInfoResponse#getApiVersion() apiVersion}
   *    .applicationSshEndpoint(String | null) // nullable {@link GetInfoResponse#getApplicationSshEndpoint() applicationSshEndpoint}
   *    .applicationSshHostKeyFingerprint(String | null) // nullable {@link GetInfoResponse#getApplicationSshHostKeyFingerprint() applicationSshHostKeyFingerprint}
   *    .applicationSshOAuthClient(String | null) // nullable {@link GetInfoResponse#getApplicationSshOAuthClient() applicationSshOAuthClient}
   *    .authorizationEndpoint(String | null) // nullable {@link GetInfoResponse#getAuthorizationEndpoint() authorizationEndpoint}
   *    .buildNumber(String | null) // nullable {@link GetInfoResponse#getBuildNumber() buildNumber}
   *    .description(String | null) // nullable {@link GetInfoResponse#getDescription() description}
   *    .dopplerLoggingEndpoint(String | null) // nullable {@link GetInfoResponse#getDopplerLoggingEndpoint() dopplerLoggingEndpoint}
   *    .loggingEndpoint(String | null) // nullable {@link GetInfoResponse#getLoggingEndpoint() loggingEndpoint}
   *    .minCliVersion(String | null) // nullable {@link GetInfoResponse#getMinCliVersion() minCliVersion}
   *    .minRecommendedCliVersion(String | null) // nullable {@link GetInfoResponse#getMinRecommendedCliVersion() minRecommendedCliVersion}
   *    .name(String | null) // nullable {@link GetInfoResponse#getName() name}
   *    .osbapiVersion(String | null) // nullable {@link GetInfoResponse#getOsbapiVersion() osbapiVersion}
   *    .routingEndpoint(String | null) // nullable {@link GetInfoResponse#getRoutingEndpoint() routingEndpoint}
   *    .support(String | null) // nullable {@link GetInfoResponse#getSupport() support}
   *    .tokenEndpoint(String | null) // nullable {@link GetInfoResponse#getTokenEndpoint() tokenEndpoint}
   *    .user(String | null) // nullable {@link GetInfoResponse#getUser() user}
   *    .version(Integer | null) // nullable {@link GetInfoResponse#getVersion() version}
   *    .build();
   * </pre>
   * @return A new GetInfoResponse builder
   */
  public static GetInfoResponse.Builder builder() {
    return new GetInfoResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetInfoResponse GetInfoResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetInfoResponse", generator = "Immutables")
  public static final class Builder {
    private String apiVersion;
    private String applicationSshEndpoint;
    private String applicationSshHostKeyFingerprint;
    private String applicationSshOAuthClient;
    private String authorizationEndpoint;
    private String buildNumber;
    private String description;
    private String dopplerLoggingEndpoint;
    private String loggingEndpoint;
    private String minCliVersion;
    private String minRecommendedCliVersion;
    private String name;
    private String osbapiVersion;
    private String routingEndpoint;
    private String support;
    private String tokenEndpoint;
    private String user;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetInfoResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetInfoResponse instance) {
      return from((_GetInfoResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetInfoResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetInfoResponse instance) {
      Objects.requireNonNull(instance, "instance");
      String apiVersionValue = instance.getApiVersion();
      if (apiVersionValue != null) {
        apiVersion(apiVersionValue);
      }
      String applicationSshEndpointValue = instance.getApplicationSshEndpoint();
      if (applicationSshEndpointValue != null) {
        applicationSshEndpoint(applicationSshEndpointValue);
      }
      String applicationSshHostKeyFingerprintValue = instance.getApplicationSshHostKeyFingerprint();
      if (applicationSshHostKeyFingerprintValue != null) {
        applicationSshHostKeyFingerprint(applicationSshHostKeyFingerprintValue);
      }
      String applicationSshOAuthClientValue = instance.getApplicationSshOAuthClient();
      if (applicationSshOAuthClientValue != null) {
        applicationSshOAuthClient(applicationSshOAuthClientValue);
      }
      String authorizationEndpointValue = instance.getAuthorizationEndpoint();
      if (authorizationEndpointValue != null) {
        authorizationEndpoint(authorizationEndpointValue);
      }
      String buildNumberValue = instance.getBuildNumber();
      if (buildNumberValue != null) {
        buildNumber(buildNumberValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String dopplerLoggingEndpointValue = instance.getDopplerLoggingEndpoint();
      if (dopplerLoggingEndpointValue != null) {
        dopplerLoggingEndpoint(dopplerLoggingEndpointValue);
      }
      String loggingEndpointValue = instance.getLoggingEndpoint();
      if (loggingEndpointValue != null) {
        loggingEndpoint(loggingEndpointValue);
      }
      String minCliVersionValue = instance.getMinCliVersion();
      if (minCliVersionValue != null) {
        minCliVersion(minCliVersionValue);
      }
      String minRecommendedCliVersionValue = instance.getMinRecommendedCliVersion();
      if (minRecommendedCliVersionValue != null) {
        minRecommendedCliVersion(minRecommendedCliVersionValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String osbapiVersionValue = instance.getOsbapiVersion();
      if (osbapiVersionValue != null) {
        osbapiVersion(osbapiVersionValue);
      }
      String routingEndpointValue = instance.getRoutingEndpoint();
      if (routingEndpointValue != null) {
        routingEndpoint(routingEndpointValue);
      }
      String supportValue = instance.getSupport();
      if (supportValue != null) {
        support(supportValue);
      }
      String tokenEndpointValue = instance.getTokenEndpoint();
      if (tokenEndpointValue != null) {
        tokenEndpoint(tokenEndpointValue);
      }
      String userValue = instance.getUser();
      if (userValue != null) {
        user(userValue);
      }
      Integer versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getApiVersion() apiVersion} attribute.
     * @param apiVersion The value for apiVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("api_version")
    public final Builder apiVersion(@Nullable String apiVersion) {
      this.apiVersion = apiVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getApplicationSshEndpoint() applicationSshEndpoint} attribute.
     * @param applicationSshEndpoint The value for applicationSshEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_ssh_endpoint")
    public final Builder applicationSshEndpoint(@Nullable String applicationSshEndpoint) {
      this.applicationSshEndpoint = applicationSshEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getApplicationSshHostKeyFingerprint() applicationSshHostKeyFingerprint} attribute.
     * @param applicationSshHostKeyFingerprint The value for applicationSshHostKeyFingerprint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_ssh_host_key_fingerprint")
    public final Builder applicationSshHostKeyFingerprint(@Nullable String applicationSshHostKeyFingerprint) {
      this.applicationSshHostKeyFingerprint = applicationSshHostKeyFingerprint;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getApplicationSshOAuthClient() applicationSshOAuthClient} attribute.
     * @param applicationSshOAuthClient The value for applicationSshOAuthClient (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_ssh_oauth_client")
    public final Builder applicationSshOAuthClient(@Nullable String applicationSshOAuthClient) {
      this.applicationSshOAuthClient = applicationSshOAuthClient;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getAuthorizationEndpoint() authorizationEndpoint} attribute.
     * @param authorizationEndpoint The value for authorizationEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authorization_endpoint")
    public final Builder authorizationEndpoint(@Nullable String authorizationEndpoint) {
      this.authorizationEndpoint = authorizationEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getBuildNumber() buildNumber} attribute.
     * @param buildNumber The value for buildNumber (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("build")
    public final Builder buildNumber(@Nullable String buildNumber) {
      this.buildNumber = buildNumber;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getDopplerLoggingEndpoint() dopplerLoggingEndpoint} attribute.
     * @param dopplerLoggingEndpoint The value for dopplerLoggingEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("doppler_logging_endpoint")
    public final Builder dopplerLoggingEndpoint(@Nullable String dopplerLoggingEndpoint) {
      this.dopplerLoggingEndpoint = dopplerLoggingEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getLoggingEndpoint() loggingEndpoint} attribute.
     * @param loggingEndpoint The value for loggingEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("logging_endpoint")
    public final Builder loggingEndpoint(@Nullable String loggingEndpoint) {
      this.loggingEndpoint = loggingEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getMinCliVersion() minCliVersion} attribute.
     * @param minCliVersion The value for minCliVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("min_cli_version")
    public final Builder minCliVersion(@Nullable String minCliVersion) {
      this.minCliVersion = minCliVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getMinRecommendedCliVersion() minRecommendedCliVersion} attribute.
     * @param minRecommendedCliVersion The value for minRecommendedCliVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("min_recommended_cli_version")
    public final Builder minRecommendedCliVersion(@Nullable String minRecommendedCliVersion) {
      this.minRecommendedCliVersion = minRecommendedCliVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getOsbapiVersion() osbapiVersion} attribute.
     * @param osbapiVersion The value for osbapiVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("osbapi_version")
    public final Builder osbapiVersion(@Nullable String osbapiVersion) {
      this.osbapiVersion = osbapiVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getRoutingEndpoint() routingEndpoint} attribute.
     * @param routingEndpoint The value for routingEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routing_endpoint")
    public final Builder routingEndpoint(@Nullable String routingEndpoint) {
      this.routingEndpoint = routingEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getSupport() support} attribute.
     * @param support The value for support (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("support")
    public final Builder support(@Nullable String support) {
      this.support = support;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getTokenEndpoint() tokenEndpoint} attribute.
     * @param tokenEndpoint The value for tokenEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token_endpoint")
    public final Builder tokenEndpoint(@Nullable String tokenEndpoint) {
      this.tokenEndpoint = tokenEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getUser() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("user")
    public final Builder user(@Nullable String user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the value for the {@link GetInfoResponse#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(@Nullable Integer version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link GetInfoResponse GetInfoResponse}.
     * @return An immutable instance of GetInfoResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetInfoResponse build() {
      return new GetInfoResponse(this);
    }
  }
}
