package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Associate Billing Manager with the Organization operation
 */
@Generated(from = "_AssociateOrganizationBillingManagerRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AssociateOrganizationBillingManagerRequest
    extends org.cloudfoundry.client.v2.organizations._AssociateOrganizationBillingManagerRequest {
  private final String billingManagerId;
  private final String organizationId;

  private AssociateOrganizationBillingManagerRequest(AssociateOrganizationBillingManagerRequest.Builder builder) {
    this.billingManagerId = builder.billingManagerId;
    this.organizationId = builder.organizationId;
  }

  /**
   * The billing manager id
   */
  @Override
  public String getBillingManagerId() {
    return billingManagerId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateOrganizationBillingManagerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateOrganizationBillingManagerRequest
        && equalTo(0, (AssociateOrganizationBillingManagerRequest) another);
  }

  private boolean equalTo(int synthetic, AssociateOrganizationBillingManagerRequest another) {
    return billingManagerId.equals(another.billingManagerId)
        && organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code billingManagerId}, {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + billingManagerId.hashCode();
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateOrganizationBillingManagerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateOrganizationBillingManagerRequest{"
        + "billingManagerId=" + billingManagerId
        + ", organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateOrganizationBillingManagerRequest AssociateOrganizationBillingManagerRequest}.
   * <pre>
   * AssociateOrganizationBillingManagerRequest.builder()
   *    .billingManagerId(String) // required {@link AssociateOrganizationBillingManagerRequest#getBillingManagerId() billingManagerId}
   *    .organizationId(String) // required {@link AssociateOrganizationBillingManagerRequest#getOrganizationId() organizationId}
   *    .build();
   * </pre>
   * @return A new AssociateOrganizationBillingManagerRequest builder
   */
  public static AssociateOrganizationBillingManagerRequest.Builder builder() {
    return new AssociateOrganizationBillingManagerRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateOrganizationBillingManagerRequest AssociateOrganizationBillingManagerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AssociateOrganizationBillingManagerRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BILLING_MANAGER_ID = 0x1L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x2L;
    private long initBits = 0x3L;

    private String billingManagerId;
    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateOrganizationBillingManagerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateOrganizationBillingManagerRequest instance) {
      return from((_AssociateOrganizationBillingManagerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateOrganizationBillingManagerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateOrganizationBillingManagerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      billingManagerId(instance.getBillingManagerId());
      organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateOrganizationBillingManagerRequest#getBillingManagerId() billingManagerId} attribute.
     * @param billingManagerId The value for billingManagerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagerId(String billingManagerId) {
      this.billingManagerId = Objects.requireNonNull(billingManagerId, "billingManagerId");
      initBits &= ~INIT_BIT_BILLING_MANAGER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateOrganizationBillingManagerRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateOrganizationBillingManagerRequest AssociateOrganizationBillingManagerRequest}.
     * @return An immutable instance of AssociateOrganizationBillingManagerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateOrganizationBillingManagerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateOrganizationBillingManagerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BILLING_MANAGER_ID) != 0) attributes.add("billingManagerId");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build AssociateOrganizationBillingManagerRequest, some of required attributes are not set " + attributes;
    }
  }
}
