package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response payload for the Organization summary operation
 */
@Generated(from = "_SummaryOrganizationResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SummaryOrganizationResponse
    extends org.cloudfoundry.client.v2.organizations._SummaryOrganizationResponse {
  private final @Nullable String id;
  private final @Nullable String name;
  private final @Nullable List<OrganizationSpaceSummary> spaces;
  private final @Nullable String status;

  private SummaryOrganizationResponse(SummaryOrganizationResponse.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.spaces = builder.spaces == null ? null : createUnmodifiableList(true, builder.spaces);
    this.status = builder.status;
  }

  /**
   * The organization id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The organization name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * List of spaces that are in the organization
   */
  @JsonProperty("spaces")
  @Override
  public @Nullable List<OrganizationSpaceSummary> getSpaces() {
    return spaces;
  }

  /**
   * The organization status
   */
  @JsonProperty("status")
  @Override
  public @Nullable String getStatus() {
    return status;
  }

  /**
   * This instance is equal to all instances of {@code SummaryOrganizationResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SummaryOrganizationResponse
        && equalTo(0, (SummaryOrganizationResponse) another);
  }

  private boolean equalTo(int synthetic, SummaryOrganizationResponse another) {
    return Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(spaces, another.spaces)
        && Objects.equals(status, another.status);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code spaces}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(spaces);
    h += (h << 5) + Objects.hashCode(status);
    return h;
  }

  /**
   * Prints the immutable value {@code SummaryOrganizationResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SummaryOrganizationResponse{"
        + "id=" + id
        + ", name=" + name
        + ", spaces=" + spaces
        + ", status=" + status
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_SummaryOrganizationResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.organizations._SummaryOrganizationResponse {
    String id;
    String name;
    List<OrganizationSpaceSummary> spaces = null;
    String status;
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("spaces")
    public void setSpaces(@Nullable List<OrganizationSpaceSummary> spaces) {
      this.spaces = spaces;
    }
    @JsonProperty("status")
    public void setStatus(@Nullable String status) {
      this.status = status;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<OrganizationSpaceSummary> getSpaces() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatus() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SummaryOrganizationResponse fromJson(Json json) {
    SummaryOrganizationResponse.Builder builder = SummaryOrganizationResponse.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.spaces != null) {
      builder.addAllSpaces(json.spaces);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SummaryOrganizationResponse SummaryOrganizationResponse}.
   * <pre>
   * SummaryOrganizationResponse.builder()
   *    .id(String | null) // nullable {@link SummaryOrganizationResponse#getId() id}
   *    .name(String | null) // nullable {@link SummaryOrganizationResponse#getName() name}
   *    .spaces(List&amp;lt;OrganizationSpaceSummary&amp;gt; | null) // nullable {@link SummaryOrganizationResponse#getSpaces() spaces}
   *    .status(String | null) // nullable {@link SummaryOrganizationResponse#getStatus() status}
   *    .build();
   * </pre>
   * @return A new SummaryOrganizationResponse builder
   */
  public static SummaryOrganizationResponse.Builder builder() {
    return new SummaryOrganizationResponse.Builder();
  }

  /**
   * Builds instances of type {@link SummaryOrganizationResponse SummaryOrganizationResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SummaryOrganizationResponse", generator = "Immutables")
  public static final class Builder {
    private String id;
    private String name;
    private List<OrganizationSpaceSummary> spaces = null;
    private String status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SummaryOrganizationResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SummaryOrganizationResponse instance) {
      return from((_SummaryOrganizationResponse) instance);
    }

    /**
     * Copy abstract value type {@code _SummaryOrganizationResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SummaryOrganizationResponse instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      List<OrganizationSpaceSummary> spacesValue = instance.getSpaces();
      if (spacesValue != null) {
        addAllSpaces(spacesValue);
      }
      String statusValue = instance.getStatus();
      if (statusValue != null) {
        status(statusValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SummaryOrganizationResponse#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link SummaryOrganizationResponse#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Adds one element to {@link SummaryOrganizationResponse#getSpaces() spaces} list.
     * @param element A spaces element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(OrganizationSpaceSummary element) {
      if (this.spaces == null) {
        this.spaces = new ArrayList<OrganizationSpaceSummary>();
      }
      this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      return this;
    }

    /**
     * Adds elements to {@link SummaryOrganizationResponse#getSpaces() spaces} list.
     * @param elements An array of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaces(OrganizationSpaceSummary... elements) {
      if (this.spaces == null) {
        this.spaces = new ArrayList<OrganizationSpaceSummary>();
      }
      for (OrganizationSpaceSummary element : elements) {
        this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SummaryOrganizationResponse#getSpaces() spaces} list.
     * @param elements An iterable of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("spaces")
    public final Builder spaces(@Nullable Iterable<? extends OrganizationSpaceSummary> elements) {
      if (elements == null) {
        this.spaces = null;
        return this;
      }
      this.spaces = new ArrayList<OrganizationSpaceSummary>();
      return addAllSpaces(elements);
    }

    /**
     * Adds elements to {@link SummaryOrganizationResponse#getSpaces() spaces} list.
     * @param elements An iterable of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaces(Iterable<? extends OrganizationSpaceSummary> elements) {
      Objects.requireNonNull(elements, "spaces element");
      if (this.spaces == null) {
        this.spaces = new ArrayList<OrganizationSpaceSummary>();
      }
      for (OrganizationSpaceSummary element : elements) {
        this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SummaryOrganizationResponse#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Builds a new {@link SummaryOrganizationResponse SummaryOrganizationResponse}.
     * @return An immutable instance of SummaryOrganizationResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SummaryOrganizationResponse build() {
      return new SummaryOrganizationResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
