package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Associate an Application with the Route operation
 */
@Generated(from = "_AssociateRouteApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AssociateRouteApplicationRequest
    extends org.cloudfoundry.client.v2.routes._AssociateRouteApplicationRequest {
  private final String applicationId;
  private final String routeId;

  private AssociateRouteApplicationRequest(AssociateRouteApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.routeId = builder.routeId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateRouteApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateRouteApplicationRequest
        && equalTo(0, (AssociateRouteApplicationRequest) another);
  }

  private boolean equalTo(int synthetic, AssociateRouteApplicationRequest another) {
    return applicationId.equals(another.applicationId)
        && routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateRouteApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateRouteApplicationRequest{"
        + "applicationId=" + applicationId
        + ", routeId=" + routeId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateRouteApplicationRequest AssociateRouteApplicationRequest}.
   * <pre>
   * AssociateRouteApplicationRequest.builder()
   *    .applicationId(String) // required {@link AssociateRouteApplicationRequest#getApplicationId() applicationId}
   *    .routeId(String) // required {@link AssociateRouteApplicationRequest#getRouteId() routeId}
   *    .build();
   * </pre>
   * @return A new AssociateRouteApplicationRequest builder
   */
  public static AssociateRouteApplicationRequest.Builder builder() {
    return new AssociateRouteApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateRouteApplicationRequest AssociateRouteApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AssociateRouteApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_ROUTE_ID = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateRouteApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateRouteApplicationRequest instance) {
      return from((_AssociateRouteApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateRouteApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateRouteApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      routeId(instance.getRouteId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateRouteApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateRouteApplicationRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateRouteApplicationRequest AssociateRouteApplicationRequest}.
     * @return An immutable instance of AssociateRouteApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateRouteApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateRouteApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build AssociateRouteApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
