package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.immutables.value.Generated;

/**
 * The response payload for the Associate an Application with the Route operation
 */
@Generated(from = "_AssociateRouteApplicationResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AssociateRouteApplicationResponse
    extends org.cloudfoundry.client.v2.routes._AssociateRouteApplicationResponse {
  private final @Nullable RouteEntity entity;
  private final @Nullable Metadata metadata;

  private AssociateRouteApplicationResponse(AssociateRouteApplicationResponse.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable RouteEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code AssociateRouteApplicationResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateRouteApplicationResponse
        && equalTo(0, (AssociateRouteApplicationResponse) another);
  }

  private boolean equalTo(int synthetic, AssociateRouteApplicationResponse another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(entity);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateRouteApplicationResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateRouteApplicationResponse{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_AssociateRouteApplicationResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.routes._AssociateRouteApplicationResponse {
    RouteEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable RouteEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public RouteEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static AssociateRouteApplicationResponse fromJson(Json json) {
    AssociateRouteApplicationResponse.Builder builder = AssociateRouteApplicationResponse.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link AssociateRouteApplicationResponse AssociateRouteApplicationResponse}.
   * <pre>
   * AssociateRouteApplicationResponse.builder()
   *    .entity(org.cloudfoundry.client.v2.routes.RouteEntity | null) // nullable {@link AssociateRouteApplicationResponse#getEntity() entity}
   *    .metadata(org.cloudfoundry.client.v2.Metadata | null) // nullable {@link AssociateRouteApplicationResponse#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new AssociateRouteApplicationResponse builder
   */
  public static AssociateRouteApplicationResponse.Builder builder() {
    return new AssociateRouteApplicationResponse.Builder();
  }

  /**
   * Builds instances of type {@link AssociateRouteApplicationResponse AssociateRouteApplicationResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AssociateRouteApplicationResponse", generator = "Immutables")
  public static final class Builder {
    private RouteEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateRouteApplicationResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateRouteApplicationResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _AssociateRouteApplicationResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_AssociateRouteApplicationResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.routes.AbstractRouteResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractRouteResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof org.cloudfoundry.client.v2.routes._AssociateRouteApplicationResponse) {
        org.cloudfoundry.client.v2.routes._AssociateRouteApplicationResponse instance = (org.cloudfoundry.client.v2.routes._AssociateRouteApplicationResponse) object;
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        RouteEntity entityValue = instance.getEntity();
        if (entityValue != null) {
          entity(entityValue);
        }
      }
      if (object instanceof AbstractRouteResource) {
        AbstractRouteResource instance = (AbstractRouteResource) object;
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AssociateRouteApplicationResponse#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    public final Builder entity(@Nullable RouteEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateRouteApplicationResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link AssociateRouteApplicationResponse AssociateRouteApplicationResponse}.
     * @return An immutable instance of AssociateRouteApplicationResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateRouteApplicationResponse build() {
      return new AssociateRouteApplicationResponse(this);
    }
  }
}
