package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Security Group Running Default operation
 */
@Generated(from = "_RemoveSecurityGroupRunningDefaultRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveSecurityGroupRunningDefaultRequest
    extends org.cloudfoundry.client.v2.securitygroups._RemoveSecurityGroupRunningDefaultRequest {
  private final String securityGroupId;

  private RemoveSecurityGroupRunningDefaultRequest(RemoveSecurityGroupRunningDefaultRequest.Builder builder) {
    this.securityGroupId = builder.securityGroupId;
  }

  /**
   * The security group id
   */
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveSecurityGroupRunningDefaultRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveSecurityGroupRunningDefaultRequest
        && equalTo(0, (RemoveSecurityGroupRunningDefaultRequest) another);
  }

  private boolean equalTo(int synthetic, RemoveSecurityGroupRunningDefaultRequest another) {
    return securityGroupId.equals(another.securityGroupId);
  }

  /**
   * Computes a hash code from attributes: {@code securityGroupId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + securityGroupId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveSecurityGroupRunningDefaultRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveSecurityGroupRunningDefaultRequest{"
        + "securityGroupId=" + securityGroupId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveSecurityGroupRunningDefaultRequest RemoveSecurityGroupRunningDefaultRequest}.
   * <pre>
   * RemoveSecurityGroupRunningDefaultRequest.builder()
   *    .securityGroupId(String) // required {@link RemoveSecurityGroupRunningDefaultRequest#getSecurityGroupId() securityGroupId}
   *    .build();
   * </pre>
   * @return A new RemoveSecurityGroupRunningDefaultRequest builder
   */
  public static RemoveSecurityGroupRunningDefaultRequest.Builder builder() {
    return new RemoveSecurityGroupRunningDefaultRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveSecurityGroupRunningDefaultRequest RemoveSecurityGroupRunningDefaultRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveSecurityGroupRunningDefaultRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private String securityGroupId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveSecurityGroupRunningDefaultRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveSecurityGroupRunningDefaultRequest instance) {
      return from((_RemoveSecurityGroupRunningDefaultRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveSecurityGroupRunningDefaultRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveSecurityGroupRunningDefaultRequest instance) {
      Objects.requireNonNull(instance, "instance");
      securityGroupId(instance.getSecurityGroupId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSecurityGroupRunningDefaultRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveSecurityGroupRunningDefaultRequest RemoveSecurityGroupRunningDefaultRequest}.
     * @return An immutable instance of RemoveSecurityGroupRunningDefaultRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveSecurityGroupRunningDefaultRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveSecurityGroupRunningDefaultRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      return "Cannot build RemoveSecurityGroupRunningDefaultRequest, some of required attributes are not set " + attributes;
    }
  }
}
