package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.immutables.value.Generated;

/**
 * Route Resource in responses
 */
@Generated(from = "_SecurityGroupResource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SecurityGroupResource
    extends org.cloudfoundry.client.v2.securitygroups._SecurityGroupResource {
  private final @Nullable SecurityGroupEntity entity;
  private final @Nullable Metadata metadata;

  private SecurityGroupResource(SecurityGroupResource.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable SecurityGroupEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code SecurityGroupResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SecurityGroupResource
        && equalTo(0, (SecurityGroupResource) another);
  }

  private boolean equalTo(int synthetic, SecurityGroupResource another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(entity);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code SecurityGroupResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SecurityGroupResource{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_SecurityGroupResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.securitygroups._SecurityGroupResource {
    SecurityGroupEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable SecurityGroupEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public SecurityGroupEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SecurityGroupResource fromJson(Json json) {
    SecurityGroupResource.Builder builder = SecurityGroupResource.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SecurityGroupResource SecurityGroupResource}.
   * <pre>
   * SecurityGroupResource.builder()
   *    .entity(org.cloudfoundry.client.v2.securitygroups.SecurityGroupEntity | null) // nullable {@link SecurityGroupResource#getEntity() entity}
   *    .metadata(org.cloudfoundry.client.v2.Metadata | null) // nullable {@link SecurityGroupResource#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new SecurityGroupResource builder
   */
  public static SecurityGroupResource.Builder builder() {
    return new SecurityGroupResource.Builder();
  }

  /**
   * Builds instances of type {@link SecurityGroupResource SecurityGroupResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SecurityGroupResource", generator = "Immutables")
  public static final class Builder {
    private SecurityGroupEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.securitygroups.AbstractSecurityGroupResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSecurityGroupResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code SecurityGroupResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SecurityGroupResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _SecurityGroupResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_SecurityGroupResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractSecurityGroupResource) {
        AbstractSecurityGroupResource instance = (AbstractSecurityGroupResource) object;
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.securitygroups._SecurityGroupResource) {
        org.cloudfoundry.client.v2.securitygroups._SecurityGroupResource instance = (org.cloudfoundry.client.v2.securitygroups._SecurityGroupResource) object;
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        SecurityGroupEntity entityValue = instance.getEntity();
        if (entityValue != null) {
          entity(entityValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link SecurityGroupResource#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    public final Builder entity(@Nullable SecurityGroupEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link SecurityGroupResource#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link SecurityGroupResource SecurityGroupResource}.
     * @return An immutable instance of SecurityGroupResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SecurityGroupResource build() {
      return new SecurityGroupResource(this);
    }
  }
}
