package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.MaintenanceInfo;
import org.immutables.value.Generated;

/**
 * A service plan
 */
@Generated(from = "_Plan", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Plan extends org.cloudfoundry.client.v2.serviceinstances._Plan {
  private final @Nullable String id;
  private final @Nullable MaintenanceInfo maintenanceInfo;
  private final @Nullable String name;
  private final @Nullable Service service;

  private Plan(Plan.Builder builder) {
    this.id = builder.id;
    this.maintenanceInfo = builder.maintenanceInfo;
    this.name = builder.name;
    this.service = builder.service;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The maintenance info
   */
  @JsonProperty("maintenance_info")
  @Override
  public @Nullable MaintenanceInfo getMaintenanceInfo() {
    return maintenanceInfo;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The service
   */
  @JsonProperty("service")
  @Override
  public @Nullable Service getService() {
    return service;
  }

  /**
   * This instance is equal to all instances of {@code Plan} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Plan
        && equalTo(0, (Plan) another);
  }

  private boolean equalTo(int synthetic, Plan another) {
    return Objects.equals(id, another.id)
        && Objects.equals(maintenanceInfo, another.maintenanceInfo)
        && Objects.equals(name, another.name)
        && Objects.equals(service, another.service);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code maintenanceInfo}, {@code name}, {@code service}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(maintenanceInfo);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(service);
    return h;
  }

  /**
   * Prints the immutable value {@code Plan} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Plan{"
        + "id=" + id
        + ", maintenanceInfo=" + maintenanceInfo
        + ", name=" + name
        + ", service=" + service
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Plan", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._Plan {
    String id;
    MaintenanceInfo maintenanceInfo;
    String name;
    Service service;
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("maintenance_info")
    public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("service")
    public void setService(@Nullable Service service) {
      this.service = service;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public MaintenanceInfo getMaintenanceInfo() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Service getService() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Plan fromJson(Json json) {
    Plan.Builder builder = Plan.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.maintenanceInfo != null) {
      builder.maintenanceInfo(json.maintenanceInfo);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Plan Plan}.
   * <pre>
   * Plan.builder()
   *    .id(String | null) // nullable {@link Plan#getId() id}
   *    .maintenanceInfo(org.cloudfoundry.client.v2.MaintenanceInfo | null) // nullable {@link Plan#getMaintenanceInfo() maintenanceInfo}
   *    .name(String | null) // nullable {@link Plan#getName() name}
   *    .service(org.cloudfoundry.client.v2.serviceinstances.Service | null) // nullable {@link Plan#getService() service}
   *    .build();
   * </pre>
   * @return A new Plan builder
   */
  public static Plan.Builder builder() {
    return new Plan.Builder();
  }

  /**
   * Builds instances of type {@link Plan Plan}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Plan", generator = "Immutables")
  public static final class Builder {
    private String id;
    private MaintenanceInfo maintenanceInfo;
    private String name;
    private Service service;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Plan} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Plan instance) {
      return from((_Plan) instance);
    }

    /**
     * Copy abstract value type {@code _Plan} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Plan instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
      if (maintenanceInfoValue != null) {
        maintenanceInfo(maintenanceInfoValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Service serviceValue = instance.getService();
      if (serviceValue != null) {
        service(serviceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Plan#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Plan#getMaintenanceInfo() maintenanceInfo} attribute.
     * @param maintenanceInfo The value for maintenanceInfo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maintenance_info")
    public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
      return this;
    }

    /**
     * Initializes the value for the {@link Plan#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Plan#getService() service} attribute.
     * @param service The value for service (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service")
    public final Builder service(@Nullable Service service) {
      this.service = service;
      return this;
    }

    /**
     * Builds a new {@link Plan Plan}.
     * @return An immutable instance of Plan
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Plan build() {
      return new Plan(this);
    }
  }
}
