package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload to Unbind Service Instance from a Route
 */
@Generated(from = "_UnbindServiceInstanceRouteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UnbindServiceInstanceRouteRequest
    extends org.cloudfoundry.client.v2.serviceinstances._UnbindServiceInstanceRouteRequest {
  private final String routeId;
  private final String serviceInstanceId;

  private UnbindServiceInstanceRouteRequest(UnbindServiceInstanceRouteRequest.Builder builder) {
    this.routeId = builder.routeId;
    this.serviceInstanceId = builder.serviceInstanceId;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code UnbindServiceInstanceRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnbindServiceInstanceRouteRequest
        && equalTo(0, (UnbindServiceInstanceRouteRequest) another);
  }

  private boolean equalTo(int synthetic, UnbindServiceInstanceRouteRequest another) {
    return routeId.equals(another.routeId)
        && serviceInstanceId.equals(another.serviceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code routeId}, {@code serviceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + routeId.hashCode();
    h += (h << 5) + serviceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnbindServiceInstanceRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnbindServiceInstanceRouteRequest{"
        + "routeId=" + routeId
        + ", serviceInstanceId=" + serviceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link UnbindServiceInstanceRouteRequest UnbindServiceInstanceRouteRequest}.
   * <pre>
   * UnbindServiceInstanceRouteRequest.builder()
   *    .routeId(String) // required {@link UnbindServiceInstanceRouteRequest#getRouteId() routeId}
   *    .serviceInstanceId(String) // required {@link UnbindServiceInstanceRouteRequest#getServiceInstanceId() serviceInstanceId}
   *    .build();
   * </pre>
   * @return A new UnbindServiceInstanceRouteRequest builder
   */
  public static UnbindServiceInstanceRouteRequest.Builder builder() {
    return new UnbindServiceInstanceRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnbindServiceInstanceRouteRequest UnbindServiceInstanceRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnbindServiceInstanceRouteRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x2L;
    private long initBits = 0x3L;

    private String routeId;
    private String serviceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnbindServiceInstanceRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnbindServiceInstanceRouteRequest instance) {
      return from((_UnbindServiceInstanceRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnbindServiceInstanceRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnbindServiceInstanceRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      routeId(instance.getRouteId());
      serviceInstanceId(instance.getServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link UnbindServiceInstanceRouteRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UnbindServiceInstanceRouteRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link UnbindServiceInstanceRouteRequest UnbindServiceInstanceRouteRequest}.
     * @return An immutable instance of UnbindServiceInstanceRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnbindServiceInstanceRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnbindServiceInstanceRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build UnbindServiceInstanceRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
