package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.MaintenanceInfo;
import org.immutables.value.Generated;

/**
 * The request payload to Update a Service Instance
 */
@Generated(from = "_UpdateServiceInstanceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceInstanceRequest
    extends org.cloudfoundry.client.v2.serviceinstances._UpdateServiceInstanceRequest {
  private final @Nullable Boolean acceptsIncomplete;
  private final @Nullable MaintenanceInfo maintenanceInfo;
  private final @Nullable String name;
  private final @Nullable Map<String, Object> parameters;
  private final String serviceInstanceId;
  private final @Nullable String servicePlanId;
  private final @Nullable List<String> tags;

  private UpdateServiceInstanceRequest(UpdateServiceInstanceRequest.Builder builder) {
    this.acceptsIncomplete = builder.acceptsIncomplete;
    this.maintenanceInfo = builder.maintenanceInfo;
    this.name = builder.name;
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.serviceInstanceId = builder.serviceInstanceId;
    this.servicePlanId = builder.servicePlanId;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
  }

  /**
   * The accept incomplete flag
   */
  @JsonIgnore
  @Override
  public @Nullable Boolean getAcceptsIncomplete() {
    return acceptsIncomplete;
  }

  /**
   * The maintenance info
   */
  @JsonProperty("maintenance_info")
  @Override
  public @Nullable MaintenanceInfo getMaintenanceInfo() {
    return maintenanceInfo;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Key/value pairs of all arbitrary parameters to pass along to the service broker
   */
  @JsonProperty("parameters")
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The service instance id
   */
  @JsonProperty("serviceInstanceId")
  @JsonIgnore
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * The service plan id
   */
  @JsonProperty("service_plan_guid")
  @Override
  public @Nullable String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * A list of tags for the service instance
   */
  @JsonProperty("tags")
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceInstanceRequest
        && equalTo(0, (UpdateServiceInstanceRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateServiceInstanceRequest another) {
    return Objects.equals(acceptsIncomplete, another.acceptsIncomplete)
        && Objects.equals(maintenanceInfo, another.maintenanceInfo)
        && Objects.equals(name, another.name)
        && Objects.equals(parameters, another.parameters)
        && serviceInstanceId.equals(another.serviceInstanceId)
        && Objects.equals(servicePlanId, another.servicePlanId)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code acceptsIncomplete}, {@code maintenanceInfo}, {@code name}, {@code parameters}, {@code serviceInstanceId}, {@code servicePlanId}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(acceptsIncomplete);
    h += (h << 5) + Objects.hashCode(maintenanceInfo);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(parameters);
    h += (h << 5) + serviceInstanceId.hashCode();
    h += (h << 5) + Objects.hashCode(servicePlanId);
    h += (h << 5) + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceInstanceRequest{"
        + "acceptsIncomplete=" + acceptsIncomplete
        + ", maintenanceInfo=" + maintenanceInfo
        + ", name=" + name
        + ", parameters=" + parameters
        + ", serviceInstanceId=" + serviceInstanceId
        + ", servicePlanId=" + servicePlanId
        + ", tags=" + tags
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServiceInstanceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._UpdateServiceInstanceRequest {
    Boolean acceptsIncomplete;
    MaintenanceInfo maintenanceInfo;
    String name;
    Map<String, Object> parameters = null;
    String serviceInstanceId;
    String servicePlanId;
    List<String> tags = null;
    @JsonIgnore
    public void setAcceptsIncomplete(@Nullable Boolean acceptsIncomplete) {
      this.acceptsIncomplete = acceptsIncomplete;
    }
    @JsonProperty("maintenance_info")
    public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("parameters")
    public void setParameters(@Nullable Map<String, Object> parameters) {
      this.parameters = parameters;
    }
    @JsonProperty("serviceInstanceId")
    @JsonIgnore
    public void setServiceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
    }
    @JsonProperty("service_plan_guid")
    public void setServicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
    }
    @JsonProperty("tags")
    public void setTags(@Nullable List<String> tags) {
      this.tags = tags;
    }
    @Override
    public Boolean getAcceptsIncomplete() { throw new UnsupportedOperationException(); }
    @Override
    public MaintenanceInfo getMaintenanceInfo() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getParameters() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServiceInstanceRequest fromJson(Json json) {
    UpdateServiceInstanceRequest.Builder builder = UpdateServiceInstanceRequest.builder();
    if (json.acceptsIncomplete != null) {
      builder.acceptsIncomplete(json.acceptsIncomplete);
    }
    if (json.maintenanceInfo != null) {
      builder.maintenanceInfo(json.maintenanceInfo);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.parameters != null) {
      builder.putAllParameters(json.parameters);
    }
    if (json.serviceInstanceId != null) {
      builder.serviceInstanceId(json.serviceInstanceId);
    }
    if (json.servicePlanId != null) {
      builder.servicePlanId(json.servicePlanId);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServiceInstanceRequest UpdateServiceInstanceRequest}.
   * <pre>
   * UpdateServiceInstanceRequest.builder()
   *    .acceptsIncomplete(Boolean | null) // nullable {@link UpdateServiceInstanceRequest#getAcceptsIncomplete() acceptsIncomplete}
   *    .maintenanceInfo(org.cloudfoundry.client.v2.MaintenanceInfo | null) // nullable {@link UpdateServiceInstanceRequest#getMaintenanceInfo() maintenanceInfo}
   *    .name(String | null) // nullable {@link UpdateServiceInstanceRequest#getName() name}
   *    .parameters(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link UpdateServiceInstanceRequest#getParameters() parameters}
   *    .serviceInstanceId(String) // required {@link UpdateServiceInstanceRequest#getServiceInstanceId() serviceInstanceId}
   *    .servicePlanId(String | null) // nullable {@link UpdateServiceInstanceRequest#getServicePlanId() servicePlanId}
   *    .tags(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateServiceInstanceRequest#getTags() tags}
   *    .build();
   * </pre>
   * @return A new UpdateServiceInstanceRequest builder
   */
  public static UpdateServiceInstanceRequest.Builder builder() {
    return new UpdateServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceInstanceRequest UpdateServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceInstanceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean acceptsIncomplete;
    private MaintenanceInfo maintenanceInfo;
    private String name;
    private Map<String, Object> parameters = null;
    private String serviceInstanceId;
    private String servicePlanId;
    private List<String> tags = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceInstanceRequest instance) {
      return from((_UpdateServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean acceptsIncompleteValue = instance.getAcceptsIncomplete();
      if (acceptsIncompleteValue != null) {
        acceptsIncomplete(acceptsIncompleteValue);
      }
      MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
      if (maintenanceInfoValue != null) {
        maintenanceInfo(maintenanceInfoValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      serviceInstanceId(instance.getServiceInstanceId());
      String servicePlanIdValue = instance.getServicePlanId();
      if (servicePlanIdValue != null) {
        servicePlanId(servicePlanIdValue);
      }
      List<String> tagsValue = instance.getTags();
      if (tagsValue != null) {
        addAllTags(tagsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceRequest#getAcceptsIncomplete() acceptsIncomplete} attribute.
     * @param acceptsIncomplete The value for acceptsIncomplete (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder acceptsIncomplete(@Nullable Boolean acceptsIncomplete) {
      this.acceptsIncomplete = acceptsIncomplete;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceRequest#getMaintenanceInfo() maintenanceInfo} attribute.
     * @param maintenanceInfo The value for maintenanceInfo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Put one entry to the {@link UpdateServiceInstanceRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UpdateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UpdateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UpdateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> entries) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.parameters.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceInstanceRequest#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
      return this;
    }

    /**
     * Adds one element to {@link UpdateServiceInstanceRequest#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateServiceInstanceRequest#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link UpdateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceInstanceRequest UpdateServiceInstanceRequest}.
     * @return An immutable instance of UpdateServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build UpdateServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
