package org.cloudfoundry.client.v2.serviceplans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Service Instances for the Service Plan operation
 */
@Generated(from = "_ListServicePlanServiceInstancesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServicePlanServiceInstancesRequest
    extends org.cloudfoundry.client.v2.serviceplans._ListServicePlanServiceInstancesRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final @Nullable List<String> gatewayNames;
  private final @Nullable List<String> names;
  private final @Nullable List<String> serviceBindingIds;
  private final @Nullable List<String> serviceKeyIds;
  private final String servicePlanId;
  private final @Nullable List<String> spaceIds;

  private ListServicePlanServiceInstancesRequest(ListServicePlanServiceInstancesRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.gatewayNames = builder.gatewayNames == null ? null : createUnmodifiableList(true, builder.gatewayNames);
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.serviceBindingIds = builder.serviceBindingIds == null ? null : createUnmodifiableList(true, builder.serviceBindingIds);
    this.serviceKeyIds = builder.serviceKeyIds == null ? null : createUnmodifiableList(true, builder.serviceKeyIds);
    this.servicePlanId = builder.servicePlanId;
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The gateway names
   */
  @Override
  public @Nullable List<String> getGatewayNames() {
    return gatewayNames;
  }

  /**
   * The names of the service instances
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The service binding ids
   */
  @Override
  public @Nullable List<String> getServiceBindingIds() {
    return serviceBindingIds;
  }

  /**
   * The service key ids
   */
  @Override
  public @Nullable List<String> getServiceKeyIds() {
    return serviceKeyIds;
  }

  /**
   * The service plan id
   */
  @Override
  public String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * The space ids
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * This instance is equal to all instances of {@code ListServicePlanServiceInstancesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServicePlanServiceInstancesRequest
        && equalTo(0, (ListServicePlanServiceInstancesRequest) another);
  }

  private boolean equalTo(int synthetic, ListServicePlanServiceInstancesRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && Objects.equals(gatewayNames, another.gatewayNames)
        && Objects.equals(names, another.names)
        && Objects.equals(serviceBindingIds, another.serviceBindingIds)
        && Objects.equals(serviceKeyIds, another.serviceKeyIds)
        && servicePlanId.equals(another.servicePlanId)
        && Objects.equals(spaceIds, another.spaceIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code gatewayNames}, {@code names}, {@code serviceBindingIds}, {@code serviceKeyIds}, {@code servicePlanId}, {@code spaceIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + Objects.hashCode(gatewayNames);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(serviceBindingIds);
    h += (h << 5) + Objects.hashCode(serviceKeyIds);
    h += (h << 5) + servicePlanId.hashCode();
    h += (h << 5) + Objects.hashCode(spaceIds);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServicePlanServiceInstancesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServicePlanServiceInstancesRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", gatewayNames=" + gatewayNames
        + ", names=" + names
        + ", serviceBindingIds=" + serviceBindingIds
        + ", serviceKeyIds=" + serviceKeyIds
        + ", servicePlanId=" + servicePlanId
        + ", spaceIds=" + spaceIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListServicePlanServiceInstancesRequest ListServicePlanServiceInstancesRequest}.
   * <pre>
   * ListServicePlanServiceInstancesRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListServicePlanServiceInstancesRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListServicePlanServiceInstancesRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListServicePlanServiceInstancesRequest#getResultsPerPage() resultsPerPage}
   *    .gatewayNames(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlanServiceInstancesRequest#getGatewayNames() gatewayNames}
   *    .names(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlanServiceInstancesRequest#getNames() names}
   *    .serviceBindingIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlanServiceInstancesRequest#getServiceBindingIds() serviceBindingIds}
   *    .serviceKeyIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlanServiceInstancesRequest#getServiceKeyIds() serviceKeyIds}
   *    .servicePlanId(String) // required {@link ListServicePlanServiceInstancesRequest#getServicePlanId() servicePlanId}
   *    .spaceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListServicePlanServiceInstancesRequest#getSpaceIds() spaceIds}
   *    .build();
   * </pre>
   * @return A new ListServicePlanServiceInstancesRequest builder
   */
  public static ListServicePlanServiceInstancesRequest.Builder builder() {
    return new ListServicePlanServiceInstancesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServicePlanServiceInstancesRequest ListServicePlanServiceInstancesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServicePlanServiceInstancesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_PLAN_ID = 0x1L;
    private long initBits = 0x1L;

    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private List<String> gatewayNames = null;
    private List<String> names = null;
    private List<String> serviceBindingIds = null;
    private List<String> serviceKeyIds = null;
    private String servicePlanId;
    private List<String> spaceIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServicePlanServiceInstancesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServicePlanServiceInstancesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServicePlanServiceInstancesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListServicePlanServiceInstancesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.client.v2.serviceplans._ListServicePlanServiceInstancesRequest) {
        org.cloudfoundry.client.v2.serviceplans._ListServicePlanServiceInstancesRequest instance = (org.cloudfoundry.client.v2.serviceplans._ListServicePlanServiceInstancesRequest) object;
        List<String> serviceBindingIdsValue = instance.getServiceBindingIds();
        if (serviceBindingIdsValue != null) {
          addAllServiceBindingIds(serviceBindingIdsValue);
        }
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        servicePlanId(instance.getServicePlanId());
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
        List<String> serviceKeyIdsValue = instance.getServiceKeyIds();
        if (serviceKeyIdsValue != null) {
          addAllServiceKeyIds(serviceKeyIdsValue);
        }
        List<String> gatewayNamesValue = instance.getGatewayNames();
        if (gatewayNamesValue != null) {
          addAllGatewayNames(gatewayNamesValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListServicePlanServiceInstancesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlanServiceInstancesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlanServiceInstancesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlanServiceInstancesRequest#getGatewayNames() gatewayNames} list.
     * @param element A gatewayNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayName(String element) {
      if (this.gatewayNames == null) {
        this.gatewayNames = new ArrayList<String>();
      }
      this.gatewayNames.add(Objects.requireNonNull(element, "gatewayNames element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getGatewayNames() gatewayNames} list.
     * @param elements An array of gatewayNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayNames(String... elements) {
      if (this.gatewayNames == null) {
        this.gatewayNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.gatewayNames.add(Objects.requireNonNull(element, "gatewayNames element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlanServiceInstancesRequest#getGatewayNames() gatewayNames} list.
     * @param elements An iterable of gatewayNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayNames(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.gatewayNames = null;
        return this;
      }
      this.gatewayNames = new ArrayList<String>();
      return addAllGatewayNames(elements);
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getGatewayNames() gatewayNames} list.
     * @param elements An iterable of gatewayNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGatewayNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "gatewayNames element");
      if (this.gatewayNames == null) {
        this.gatewayNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.gatewayNames.add(Objects.requireNonNull(element, "gatewayNames element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlanServiceInstancesRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlanServiceInstancesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlanServiceInstancesRequest#getServiceBindingIds() serviceBindingIds} list.
     * @param element A serviceBindingIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingId(String element) {
      if (this.serviceBindingIds == null) {
        this.serviceBindingIds = new ArrayList<String>();
      }
      this.serviceBindingIds.add(Objects.requireNonNull(element, "serviceBindingIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getServiceBindingIds() serviceBindingIds} list.
     * @param elements An array of serviceBindingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingIds(String... elements) {
      if (this.serviceBindingIds == null) {
        this.serviceBindingIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBindingIds.add(Objects.requireNonNull(element, "serviceBindingIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlanServiceInstancesRequest#getServiceBindingIds() serviceBindingIds} list.
     * @param elements An iterable of serviceBindingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceBindingIds = null;
        return this;
      }
      this.serviceBindingIds = new ArrayList<String>();
      return addAllServiceBindingIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getServiceBindingIds() serviceBindingIds} list.
     * @param elements An iterable of serviceBindingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceBindingIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceBindingIds element");
      if (this.serviceBindingIds == null) {
        this.serviceBindingIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBindingIds.add(Objects.requireNonNull(element, "serviceBindingIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlanServiceInstancesRequest#getServiceKeyIds() serviceKeyIds} list.
     * @param element A serviceKeyIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceKeyId(String element) {
      if (this.serviceKeyIds == null) {
        this.serviceKeyIds = new ArrayList<String>();
      }
      this.serviceKeyIds.add(Objects.requireNonNull(element, "serviceKeyIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getServiceKeyIds() serviceKeyIds} list.
     * @param elements An array of serviceKeyIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceKeyIds(String... elements) {
      if (this.serviceKeyIds == null) {
        this.serviceKeyIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceKeyIds.add(Objects.requireNonNull(element, "serviceKeyIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlanServiceInstancesRequest#getServiceKeyIds() serviceKeyIds} list.
     * @param elements An iterable of serviceKeyIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceKeyIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceKeyIds = null;
        return this;
      }
      this.serviceKeyIds = new ArrayList<String>();
      return addAllServiceKeyIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getServiceKeyIds() serviceKeyIds} list.
     * @param elements An iterable of serviceKeyIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceKeyIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceKeyIds element");
      if (this.serviceKeyIds == null) {
        this.serviceKeyIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceKeyIds.add(Objects.requireNonNull(element, "serviceKeyIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListServicePlanServiceInstancesRequest#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String servicePlanId) {
      this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListServicePlanServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListServicePlanServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListServicePlanServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListServicePlanServiceInstancesRequest ListServicePlanServiceInstancesRequest}.
     * @return An immutable instance of ListServicePlanServiceInstancesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServicePlanServiceInstancesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListServicePlanServiceInstancesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_PLAN_ID) != 0) attributes.add("servicePlanId");
      return "Cannot build ListServicePlanServiceInstancesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
