package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.immutables.value.Generated;

/**
 * The response payload for the the Update Service Plan Visibility request.
 */
@Generated(from = "_UpdateServicePlanVisibilityResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServicePlanVisibilityResponse
    extends org.cloudfoundry.client.v2.serviceplanvisibilities._UpdateServicePlanVisibilityResponse {
  private final @Nullable ServicePlanVisibilityEntity entity;
  private final @Nullable Metadata metadata;

  private UpdateServicePlanVisibilityResponse(UpdateServicePlanVisibilityResponse.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable ServicePlanVisibilityEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServicePlanVisibilityResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServicePlanVisibilityResponse
        && equalTo(0, (UpdateServicePlanVisibilityResponse) another);
  }

  private boolean equalTo(int synthetic, UpdateServicePlanVisibilityResponse another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(entity);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServicePlanVisibilityResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServicePlanVisibilityResponse{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateServicePlanVisibilityResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.serviceplanvisibilities._UpdateServicePlanVisibilityResponse {
    ServicePlanVisibilityEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable ServicePlanVisibilityEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public ServicePlanVisibilityEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateServicePlanVisibilityResponse fromJson(Json json) {
    UpdateServicePlanVisibilityResponse.Builder builder = UpdateServicePlanVisibilityResponse.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateServicePlanVisibilityResponse UpdateServicePlanVisibilityResponse}.
   * <pre>
   * UpdateServicePlanVisibilityResponse.builder()
   *    .entity(org.cloudfoundry.client.v2.serviceplanvisibilities.ServicePlanVisibilityEntity | null) // nullable {@link UpdateServicePlanVisibilityResponse#getEntity() entity}
   *    .metadata(org.cloudfoundry.client.v2.Metadata | null) // nullable {@link UpdateServicePlanVisibilityResponse#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new UpdateServicePlanVisibilityResponse builder
   */
  public static UpdateServicePlanVisibilityResponse.Builder builder() {
    return new UpdateServicePlanVisibilityResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServicePlanVisibilityResponse UpdateServicePlanVisibilityResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServicePlanVisibilityResponse", generator = "Immutables")
  public static final class Builder {
    private ServicePlanVisibilityEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.serviceplanvisibilities.AbstractServicePlanVisibilityResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractServicePlanVisibilityResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServicePlanVisibilityResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServicePlanVisibilityResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateServicePlanVisibilityResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateServicePlanVisibilityResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractServicePlanVisibilityResource) {
        AbstractServicePlanVisibilityResource instance = (AbstractServicePlanVisibilityResource) object;
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.serviceplanvisibilities._UpdateServicePlanVisibilityResponse) {
        org.cloudfoundry.client.v2.serviceplanvisibilities._UpdateServicePlanVisibilityResponse instance = (org.cloudfoundry.client.v2.serviceplanvisibilities._UpdateServicePlanVisibilityResponse) object;
        if ((bits & 0x1L) == 0) {
          Metadata metadataValue = instance.getMetadata();
          if (metadataValue != null) {
            metadata(metadataValue);
          }
          bits |= 0x1L;
        }
        ServicePlanVisibilityEntity entityValue = instance.getEntity();
        if (entityValue != null) {
          entity(entityValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanVisibilityResponse#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    public final Builder entity(@Nullable ServicePlanVisibilityEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServicePlanVisibilityResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link UpdateServicePlanVisibilityResponse UpdateServicePlanVisibilityResponse}.
     * @return An immutable instance of UpdateServicePlanVisibilityResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServicePlanVisibilityResponse build() {
      return new UpdateServicePlanVisibilityResponse(this);
    }
  }
}
