package org.cloudfoundry.client.v2.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Service operation.
 */
@Generated(from = "_DeleteServiceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteServiceRequest extends org.cloudfoundry.client.v2.services._DeleteServiceRequest {
  private final @Nullable Boolean async;
  private final @Nullable Boolean purge;
  private final String serviceId;

  private DeleteServiceRequest(DeleteServiceRequest.Builder builder) {
    this.async = builder.async;
    this.purge = builder.purge;
    this.serviceId = builder.serviceId;
  }

  /**
   * The async flag
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The purge flag
   */
  @Override
  public @Nullable Boolean getPurge() {
    return purge;
  }

  /**
   * The service id
   */
  @Override
  public String getServiceId() {
    return serviceId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServiceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServiceRequest
        && equalTo(0, (DeleteServiceRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteServiceRequest another) {
    return Objects.equals(async, another.async)
        && Objects.equals(purge, another.purge)
        && serviceId.equals(another.serviceId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code purge}, {@code serviceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(async);
    h += (h << 5) + Objects.hashCode(purge);
    h += (h << 5) + serviceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServiceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServiceRequest{"
        + "async=" + async
        + ", purge=" + purge
        + ", serviceId=" + serviceId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServiceRequest DeleteServiceRequest}.
   * <pre>
   * DeleteServiceRequest.builder()
   *    .async(Boolean | null) // nullable {@link DeleteServiceRequest#getAsync() async}
   *    .purge(Boolean | null) // nullable {@link DeleteServiceRequest#getPurge() purge}
   *    .serviceId(String) // required {@link DeleteServiceRequest#getServiceId() serviceId}
   *    .build();
   * </pre>
   * @return A new DeleteServiceRequest builder
   */
  public static DeleteServiceRequest.Builder builder() {
    return new DeleteServiceRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServiceRequest DeleteServiceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteServiceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private Boolean purge;
    private String serviceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServiceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServiceRequest instance) {
      return from((_DeleteServiceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServiceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServiceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      Boolean purgeValue = instance.getPurge();
      if (purgeValue != null) {
        purge(purgeValue);
      }
      serviceId(instance.getServiceId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceRequest#getPurge() purge} attribute.
     * @param purge The value for purge (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder purge(@Nullable Boolean purge) {
      this.purge = purge;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceRequest#getServiceId() serviceId} attribute.
     * @param serviceId The value for serviceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
      initBits &= ~INIT_BIT_SERVICE_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteServiceRequest DeleteServiceRequest}.
     * @return An immutable instance of DeleteServiceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServiceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServiceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_ID) != 0) attributes.add("serviceId");
      return "Cannot build DeleteServiceRequest, some of required attributes are not set " + attributes;
    }
  }
}
