package org.cloudfoundry.client.v2.serviceusageevents;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity response payload for Service Usage Events
 */
@Generated(from = "_ServiceUsageEventEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceUsageEventEntity
    extends org.cloudfoundry.client.v2.serviceusageevents._ServiceUsageEventEntity {
  private final @Nullable String organizationId;
  private final @Nullable String serviceBrokerId;
  private final @Nullable String serviceBrokerName;
  private final @Nullable String serviceId;
  private final @Nullable String serviceInstanceId;
  private final @Nullable String serviceInstanceName;
  private final @Nullable String serviceInstanceType;
  private final @Nullable String serviceLabel;
  private final @Nullable String servicePlanId;
  private final @Nullable String servicePlanName;
  private final @Nullable String spaceId;
  private final @Nullable String spaceName;
  private final @Nullable String state;

  private ServiceUsageEventEntity(ServiceUsageEventEntity.Builder builder) {
    this.organizationId = builder.organizationId;
    this.serviceBrokerId = builder.serviceBrokerId;
    this.serviceBrokerName = builder.serviceBrokerName;
    this.serviceId = builder.serviceId;
    this.serviceInstanceId = builder.serviceInstanceId;
    this.serviceInstanceName = builder.serviceInstanceName;
    this.serviceInstanceType = builder.serviceInstanceType;
    this.serviceLabel = builder.serviceLabel;
    this.servicePlanId = builder.servicePlanId;
    this.servicePlanName = builder.servicePlanName;
    this.spaceId = builder.spaceId;
    this.spaceName = builder.spaceName;
    this.state = builder.state;
  }

  /**
   * The organization id
   */
  @JsonProperty("org_guid")
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The service broker id
   */
  @JsonProperty("service_broker_guid")
  @Override
  public @Nullable String getServiceBrokerId() {
    return serviceBrokerId;
  }

  /**
   * The service broker name
   */
  @JsonProperty("service_broker_name")
  @Override
  public @Nullable String getServiceBrokerName() {
    return serviceBrokerName;
  }

  /**
   * The service id
   */
  @JsonProperty("service_guid")
  @Override
  public @Nullable String getServiceId() {
    return serviceId;
  }

  /**
   * The service instance id
   */
  @JsonProperty("service_instance_guid")
  @Override
  public @Nullable String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * The service instance name
   */
  @JsonProperty("service_instance_name")
  @Override
  public @Nullable String getServiceInstanceName() {
    return serviceInstanceName;
  }

  /**
   * The service instance type
   */
  @JsonProperty("service_instance_type")
  @Override
  public @Nullable String getServiceInstanceType() {
    return serviceInstanceType;
  }

  /**
   * The service label
   */
  @JsonProperty("service_label")
  @Override
  public @Nullable String getServiceLabel() {
    return serviceLabel;
  }

  /**
   * The service plan id
   */
  @JsonProperty("service_plan_guid")
  @Override
  public @Nullable String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * The service plan name
   */
  @JsonProperty("service_plan_name")
  @Override
  public @Nullable String getServicePlanName() {
    return servicePlanName;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The space name
   */
  @JsonProperty("space_name")
  @Override
  public @Nullable String getSpaceName() {
    return spaceName;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * This instance is equal to all instances of {@code ServiceUsageEventEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceUsageEventEntity
        && equalTo(0, (ServiceUsageEventEntity) another);
  }

  private boolean equalTo(int synthetic, ServiceUsageEventEntity another) {
    return Objects.equals(organizationId, another.organizationId)
        && Objects.equals(serviceBrokerId, another.serviceBrokerId)
        && Objects.equals(serviceBrokerName, another.serviceBrokerName)
        && Objects.equals(serviceId, another.serviceId)
        && Objects.equals(serviceInstanceId, another.serviceInstanceId)
        && Objects.equals(serviceInstanceName, another.serviceInstanceName)
        && Objects.equals(serviceInstanceType, another.serviceInstanceType)
        && Objects.equals(serviceLabel, another.serviceLabel)
        && Objects.equals(servicePlanId, another.servicePlanId)
        && Objects.equals(servicePlanName, another.servicePlanName)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(spaceName, another.spaceName)
        && Objects.equals(state, another.state);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code serviceBrokerId}, {@code serviceBrokerName}, {@code serviceId}, {@code serviceInstanceId}, {@code serviceInstanceName}, {@code serviceInstanceType}, {@code serviceLabel}, {@code servicePlanId}, {@code servicePlanName}, {@code spaceId}, {@code spaceName}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + Objects.hashCode(serviceBrokerId);
    h += (h << 5) + Objects.hashCode(serviceBrokerName);
    h += (h << 5) + Objects.hashCode(serviceId);
    h += (h << 5) + Objects.hashCode(serviceInstanceId);
    h += (h << 5) + Objects.hashCode(serviceInstanceName);
    h += (h << 5) + Objects.hashCode(serviceInstanceType);
    h += (h << 5) + Objects.hashCode(serviceLabel);
    h += (h << 5) + Objects.hashCode(servicePlanId);
    h += (h << 5) + Objects.hashCode(servicePlanName);
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(spaceName);
    h += (h << 5) + Objects.hashCode(state);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceUsageEventEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceUsageEventEntity{"
        + "organizationId=" + organizationId
        + ", serviceBrokerId=" + serviceBrokerId
        + ", serviceBrokerName=" + serviceBrokerName
        + ", serviceId=" + serviceId
        + ", serviceInstanceId=" + serviceInstanceId
        + ", serviceInstanceName=" + serviceInstanceName
        + ", serviceInstanceType=" + serviceInstanceType
        + ", serviceLabel=" + serviceLabel
        + ", servicePlanId=" + servicePlanId
        + ", servicePlanName=" + servicePlanName
        + ", spaceId=" + spaceId
        + ", spaceName=" + spaceName
        + ", state=" + state
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServiceUsageEventEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceusageevents._ServiceUsageEventEntity {
    String organizationId;
    String serviceBrokerId;
    String serviceBrokerName;
    String serviceId;
    String serviceInstanceId;
    String serviceInstanceName;
    String serviceInstanceType;
    String serviceLabel;
    String servicePlanId;
    String servicePlanName;
    String spaceId;
    String spaceName;
    String state;
    @JsonProperty("org_guid")
    public void setOrganizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("service_broker_guid")
    public void setServiceBrokerId(@Nullable String serviceBrokerId) {
      this.serviceBrokerId = serviceBrokerId;
    }
    @JsonProperty("service_broker_name")
    public void setServiceBrokerName(@Nullable String serviceBrokerName) {
      this.serviceBrokerName = serviceBrokerName;
    }
    @JsonProperty("service_guid")
    public void setServiceId(@Nullable String serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty("service_instance_guid")
    public void setServiceInstanceId(@Nullable String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
    }
    @JsonProperty("service_instance_name")
    public void setServiceInstanceName(@Nullable String serviceInstanceName) {
      this.serviceInstanceName = serviceInstanceName;
    }
    @JsonProperty("service_instance_type")
    public void setServiceInstanceType(@Nullable String serviceInstanceType) {
      this.serviceInstanceType = serviceInstanceType;
    }
    @JsonProperty("service_label")
    public void setServiceLabel(@Nullable String serviceLabel) {
      this.serviceLabel = serviceLabel;
    }
    @JsonProperty("service_plan_guid")
    public void setServicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
    }
    @JsonProperty("service_plan_name")
    public void setServicePlanName(@Nullable String servicePlanName) {
      this.servicePlanName = servicePlanName;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("space_name")
    public void setSpaceName(@Nullable String spaceName) {
      this.spaceName = spaceName;
    }
    @JsonProperty("state")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBrokerId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBrokerName() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceName() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceType() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceLabel() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceName() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceUsageEventEntity fromJson(Json json) {
    ServiceUsageEventEntity.Builder builder = ServiceUsageEventEntity.builder();
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.serviceBrokerId != null) {
      builder.serviceBrokerId(json.serviceBrokerId);
    }
    if (json.serviceBrokerName != null) {
      builder.serviceBrokerName(json.serviceBrokerName);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceInstanceId != null) {
      builder.serviceInstanceId(json.serviceInstanceId);
    }
    if (json.serviceInstanceName != null) {
      builder.serviceInstanceName(json.serviceInstanceName);
    }
    if (json.serviceInstanceType != null) {
      builder.serviceInstanceType(json.serviceInstanceType);
    }
    if (json.serviceLabel != null) {
      builder.serviceLabel(json.serviceLabel);
    }
    if (json.servicePlanId != null) {
      builder.servicePlanId(json.servicePlanId);
    }
    if (json.servicePlanName != null) {
      builder.servicePlanName(json.servicePlanName);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.spaceName != null) {
      builder.spaceName(json.spaceName);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceUsageEventEntity ServiceUsageEventEntity}.
   * <pre>
   * ServiceUsageEventEntity.builder()
   *    .organizationId(String | null) // nullable {@link ServiceUsageEventEntity#getOrganizationId() organizationId}
   *    .serviceBrokerId(String | null) // nullable {@link ServiceUsageEventEntity#getServiceBrokerId() serviceBrokerId}
   *    .serviceBrokerName(String | null) // nullable {@link ServiceUsageEventEntity#getServiceBrokerName() serviceBrokerName}
   *    .serviceId(String | null) // nullable {@link ServiceUsageEventEntity#getServiceId() serviceId}
   *    .serviceInstanceId(String | null) // nullable {@link ServiceUsageEventEntity#getServiceInstanceId() serviceInstanceId}
   *    .serviceInstanceName(String | null) // nullable {@link ServiceUsageEventEntity#getServiceInstanceName() serviceInstanceName}
   *    .serviceInstanceType(String | null) // nullable {@link ServiceUsageEventEntity#getServiceInstanceType() serviceInstanceType}
   *    .serviceLabel(String | null) // nullable {@link ServiceUsageEventEntity#getServiceLabel() serviceLabel}
   *    .servicePlanId(String | null) // nullable {@link ServiceUsageEventEntity#getServicePlanId() servicePlanId}
   *    .servicePlanName(String | null) // nullable {@link ServiceUsageEventEntity#getServicePlanName() servicePlanName}
   *    .spaceId(String | null) // nullable {@link ServiceUsageEventEntity#getSpaceId() spaceId}
   *    .spaceName(String | null) // nullable {@link ServiceUsageEventEntity#getSpaceName() spaceName}
   *    .state(String | null) // nullable {@link ServiceUsageEventEntity#getState() state}
   *    .build();
   * </pre>
   * @return A new ServiceUsageEventEntity builder
   */
  public static ServiceUsageEventEntity.Builder builder() {
    return new ServiceUsageEventEntity.Builder();
  }

  /**
   * Builds instances of type {@link ServiceUsageEventEntity ServiceUsageEventEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceUsageEventEntity", generator = "Immutables")
  public static final class Builder {
    private String organizationId;
    private String serviceBrokerId;
    private String serviceBrokerName;
    private String serviceId;
    private String serviceInstanceId;
    private String serviceInstanceName;
    private String serviceInstanceType;
    private String serviceLabel;
    private String servicePlanId;
    private String servicePlanName;
    private String spaceId;
    private String spaceName;
    private String state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceUsageEventEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceUsageEventEntity instance) {
      return from((_ServiceUsageEventEntity) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceUsageEventEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceUsageEventEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      String serviceBrokerIdValue = instance.getServiceBrokerId();
      if (serviceBrokerIdValue != null) {
        serviceBrokerId(serviceBrokerIdValue);
      }
      String serviceBrokerNameValue = instance.getServiceBrokerName();
      if (serviceBrokerNameValue != null) {
        serviceBrokerName(serviceBrokerNameValue);
      }
      String serviceIdValue = instance.getServiceId();
      if (serviceIdValue != null) {
        serviceId(serviceIdValue);
      }
      String serviceInstanceIdValue = instance.getServiceInstanceId();
      if (serviceInstanceIdValue != null) {
        serviceInstanceId(serviceInstanceIdValue);
      }
      String serviceInstanceNameValue = instance.getServiceInstanceName();
      if (serviceInstanceNameValue != null) {
        serviceInstanceName(serviceInstanceNameValue);
      }
      String serviceInstanceTypeValue = instance.getServiceInstanceType();
      if (serviceInstanceTypeValue != null) {
        serviceInstanceType(serviceInstanceTypeValue);
      }
      String serviceLabelValue = instance.getServiceLabel();
      if (serviceLabelValue != null) {
        serviceLabel(serviceLabelValue);
      }
      String servicePlanIdValue = instance.getServicePlanId();
      if (servicePlanIdValue != null) {
        servicePlanId(servicePlanIdValue);
      }
      String servicePlanNameValue = instance.getServicePlanName();
      if (servicePlanNameValue != null) {
        servicePlanName(servicePlanNameValue);
      }
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      String spaceNameValue = instance.getSpaceName();
      if (spaceNameValue != null) {
        spaceName(spaceNameValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("org_guid")
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getServiceBrokerId() serviceBrokerId} attribute.
     * @param serviceBrokerId The value for serviceBrokerId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_broker_guid")
    public final Builder serviceBrokerId(@Nullable String serviceBrokerId) {
      this.serviceBrokerId = serviceBrokerId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getServiceBrokerName() serviceBrokerName} attribute.
     * @param serviceBrokerName The value for serviceBrokerName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_broker_name")
    public final Builder serviceBrokerName(@Nullable String serviceBrokerName) {
      this.serviceBrokerName = serviceBrokerName;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getServiceId() serviceId} attribute.
     * @param serviceId The value for serviceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_guid")
    public final Builder serviceId(@Nullable String serviceId) {
      this.serviceId = serviceId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance_guid")
    public final Builder serviceInstanceId(@Nullable String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getServiceInstanceName() serviceInstanceName} attribute.
     * @param serviceInstanceName The value for serviceInstanceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance_name")
    public final Builder serviceInstanceName(@Nullable String serviceInstanceName) {
      this.serviceInstanceName = serviceInstanceName;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getServiceInstanceType() serviceInstanceType} attribute.
     * @param serviceInstanceType The value for serviceInstanceType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance_type")
    public final Builder serviceInstanceType(@Nullable String serviceInstanceType) {
      this.serviceInstanceType = serviceInstanceType;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getServiceLabel() serviceLabel} attribute.
     * @param serviceLabel The value for serviceLabel (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_label")
    public final Builder serviceLabel(@Nullable String serviceLabel) {
      this.serviceLabel = serviceLabel;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan_guid")
    public final Builder servicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getServicePlanName() servicePlanName} attribute.
     * @param servicePlanName The value for servicePlanName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan_name")
    public final Builder servicePlanName(@Nullable String servicePlanName) {
      this.servicePlanName = servicePlanName;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getSpaceName() spaceName} attribute.
     * @param spaceName The value for spaceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_name")
    public final Builder spaceName(@Nullable String spaceName) {
      this.spaceName = spaceName;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceUsageEventEntity#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Builds a new {@link ServiceUsageEventEntity ServiceUsageEventEntity}.
     * @return An immutable instance of ServiceUsageEventEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceUsageEventEntity build() {
      return new ServiceUsageEventEntity(this);
    }
  }
}
