package org.cloudfoundry.client.v2.shareddomains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Create a Shared Domain operation
 */
@Generated(from = "_CreateSharedDomainRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateSharedDomainRequest
    extends org.cloudfoundry.client.v2.shareddomains._CreateSharedDomainRequest {
  private final @Nullable Boolean internal;
  private final String name;
  private final @Nullable String routerGroupId;

  private CreateSharedDomainRequest(CreateSharedDomainRequest.Builder builder) {
    this.internal = builder.internal;
    this.name = builder.name;
    this.routerGroupId = builder.routerGroupId;
  }

  /**
   * Whether this is an internal domain
   */
  @JsonProperty("internal")
  @Override
  public @Nullable Boolean getInternal() {
    return internal;
  }

  /**
   * The domain name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The router group id
   */
  @JsonProperty("router_group_guid")
  @Override
  public @Nullable String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * This instance is equal to all instances of {@code CreateSharedDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateSharedDomainRequest
        && equalTo(0, (CreateSharedDomainRequest) another);
  }

  private boolean equalTo(int synthetic, CreateSharedDomainRequest another) {
    return Objects.equals(internal, another.internal)
        && name.equals(another.name)
        && Objects.equals(routerGroupId, another.routerGroupId);
  }

  /**
   * Computes a hash code from attributes: {@code internal}, {@code name}, {@code routerGroupId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(internal);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(routerGroupId);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateSharedDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateSharedDomainRequest{"
        + "internal=" + internal
        + ", name=" + name
        + ", routerGroupId=" + routerGroupId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateSharedDomainRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.shareddomains._CreateSharedDomainRequest {
    Boolean internal;
    String name;
    String routerGroupId;
    @JsonProperty("internal")
    public void setInternal(@Nullable Boolean internal) {
      this.internal = internal;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("router_group_guid")
    public void setRouterGroupId(@Nullable String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @Override
    public Boolean getInternal() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateSharedDomainRequest fromJson(Json json) {
    CreateSharedDomainRequest.Builder builder = CreateSharedDomainRequest.builder();
    if (json.internal != null) {
      builder.internal(json.internal);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateSharedDomainRequest CreateSharedDomainRequest}.
   * <pre>
   * CreateSharedDomainRequest.builder()
   *    .internal(Boolean | null) // nullable {@link CreateSharedDomainRequest#getInternal() internal}
   *    .name(String) // required {@link CreateSharedDomainRequest#getName() name}
   *    .routerGroupId(String | null) // nullable {@link CreateSharedDomainRequest#getRouterGroupId() routerGroupId}
   *    .build();
   * </pre>
   * @return A new CreateSharedDomainRequest builder
   */
  public static CreateSharedDomainRequest.Builder builder() {
    return new CreateSharedDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateSharedDomainRequest CreateSharedDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateSharedDomainRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Boolean internal;
    private String name;
    private String routerGroupId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateSharedDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateSharedDomainRequest instance) {
      return from((_CreateSharedDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateSharedDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateSharedDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean internalValue = instance.getInternal();
      if (internalValue != null) {
        internal(internalValue);
      }
      name(instance.getName());
      String routerGroupIdValue = instance.getRouterGroupId();
      if (routerGroupIdValue != null) {
        routerGroupId(routerGroupIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSharedDomainRequest#getInternal() internal} attribute.
     * @param internal The value for internal (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder internal(@Nullable Boolean internal) {
      this.internal = internal;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSharedDomainRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSharedDomainRequest#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routerGroupId(@Nullable String routerGroupId) {
      this.routerGroupId = routerGroupId;
      return this;
    }

    /**
     * Builds a new {@link CreateSharedDomainRequest CreateSharedDomainRequest}.
     * @return An immutable instance of CreateSharedDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateSharedDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateSharedDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateSharedDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
