package org.cloudfoundry.client.v2.spacequotadefinitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Associate Space with the Space Quota Definition operation
 */
@Generated(from = "_AssociateSpaceQuotaDefinitionRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AssociateSpaceQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.spacequotadefinitions._AssociateSpaceQuotaDefinitionRequest {
  private final String spaceId;
  private final String spaceQuotaDefinitionId;

  private AssociateSpaceQuotaDefinitionRequest(AssociateSpaceQuotaDefinitionRequest.Builder builder) {
    this.spaceId = builder.spaceId;
    this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The space quota definition id
   */
  @Override
  public String getSpaceQuotaDefinitionId() {
    return spaceQuotaDefinitionId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateSpaceQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateSpaceQuotaDefinitionRequest
        && equalTo(0, (AssociateSpaceQuotaDefinitionRequest) another);
  }

  private boolean equalTo(int synthetic, AssociateSpaceQuotaDefinitionRequest another) {
    return spaceId.equals(another.spaceId)
        && spaceQuotaDefinitionId.equals(another.spaceQuotaDefinitionId);
  }

  /**
   * Computes a hash code from attributes: {@code spaceId}, {@code spaceQuotaDefinitionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + spaceQuotaDefinitionId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateSpaceQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateSpaceQuotaDefinitionRequest{"
        + "spaceId=" + spaceId
        + ", spaceQuotaDefinitionId=" + spaceQuotaDefinitionId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateSpaceQuotaDefinitionRequest AssociateSpaceQuotaDefinitionRequest}.
   * <pre>
   * AssociateSpaceQuotaDefinitionRequest.builder()
   *    .spaceId(String) // required {@link AssociateSpaceQuotaDefinitionRequest#getSpaceId() spaceId}
   *    .spaceQuotaDefinitionId(String) // required {@link AssociateSpaceQuotaDefinitionRequest#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId}
   *    .build();
   * </pre>
   * @return A new AssociateSpaceQuotaDefinitionRequest builder
   */
  public static AssociateSpaceQuotaDefinitionRequest.Builder builder() {
    return new AssociateSpaceQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateSpaceQuotaDefinitionRequest AssociateSpaceQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AssociateSpaceQuotaDefinitionRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private static final long INIT_BIT_SPACE_QUOTA_DEFINITION_ID = 0x2L;
    private long initBits = 0x3L;

    private String spaceId;
    private String spaceQuotaDefinitionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateSpaceQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateSpaceQuotaDefinitionRequest instance) {
      return from((_AssociateSpaceQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateSpaceQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateSpaceQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      spaceId(instance.getSpaceId());
      spaceQuotaDefinitionId(instance.getSpaceQuotaDefinitionId());
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateSpaceQuotaDefinitionRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateSpaceQuotaDefinitionRequest#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId} attribute.
     * @param spaceQuotaDefinitionId The value for spaceQuotaDefinitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuotaDefinitionId(String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = Objects.requireNonNull(spaceQuotaDefinitionId, "spaceQuotaDefinitionId");
      initBits &= ~INIT_BIT_SPACE_QUOTA_DEFINITION_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateSpaceQuotaDefinitionRequest AssociateSpaceQuotaDefinitionRequest}.
     * @return An immutable instance of AssociateSpaceQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateSpaceQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateSpaceQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      if ((initBits & INIT_BIT_SPACE_QUOTA_DEFINITION_ID) != 0) attributes.add("spaceQuotaDefinitionId");
      return "Cannot build AssociateSpaceQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
