package org.cloudfoundry.client.v2.spacequotadefinitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete a Space Quota Definition operation
 */
@Generated(from = "_DeleteSpaceQuotaDefinitionRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteSpaceQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.spacequotadefinitions._DeleteSpaceQuotaDefinitionRequest {
  private final @Nullable Boolean async;
  private final String spaceQuotaDefinitionId;

  private DeleteSpaceQuotaDefinitionRequest(DeleteSpaceQuotaDefinitionRequest.Builder builder) {
    this.async = builder.async;
    this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
  }

  /**
   * If true, a new asynchronous job is submitted to perform the operation and the job id is included in the response
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The space quota definition id
   */
  @Override
  public String getSpaceQuotaDefinitionId() {
    return spaceQuotaDefinitionId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteSpaceQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteSpaceQuotaDefinitionRequest
        && equalTo(0, (DeleteSpaceQuotaDefinitionRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteSpaceQuotaDefinitionRequest another) {
    return Objects.equals(async, another.async)
        && spaceQuotaDefinitionId.equals(another.spaceQuotaDefinitionId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code spaceQuotaDefinitionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(async);
    h += (h << 5) + spaceQuotaDefinitionId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteSpaceQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteSpaceQuotaDefinitionRequest{"
        + "async=" + async
        + ", spaceQuotaDefinitionId=" + spaceQuotaDefinitionId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteSpaceQuotaDefinitionRequest DeleteSpaceQuotaDefinitionRequest}.
   * <pre>
   * DeleteSpaceQuotaDefinitionRequest.builder()
   *    .async(Boolean | null) // nullable {@link DeleteSpaceQuotaDefinitionRequest#getAsync() async}
   *    .spaceQuotaDefinitionId(String) // required {@link DeleteSpaceQuotaDefinitionRequest#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId}
   *    .build();
   * </pre>
   * @return A new DeleteSpaceQuotaDefinitionRequest builder
   */
  public static DeleteSpaceQuotaDefinitionRequest.Builder builder() {
    return new DeleteSpaceQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteSpaceQuotaDefinitionRequest DeleteSpaceQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteSpaceQuotaDefinitionRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_QUOTA_DEFINITION_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String spaceQuotaDefinitionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteSpaceQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteSpaceQuotaDefinitionRequest instance) {
      return from((_DeleteSpaceQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteSpaceQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteSpaceQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      spaceQuotaDefinitionId(instance.getSpaceQuotaDefinitionId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteSpaceQuotaDefinitionRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteSpaceQuotaDefinitionRequest#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId} attribute.
     * @param spaceQuotaDefinitionId The value for spaceQuotaDefinitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuotaDefinitionId(String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = Objects.requireNonNull(spaceQuotaDefinitionId, "spaceQuotaDefinitionId");
      initBits &= ~INIT_BIT_SPACE_QUOTA_DEFINITION_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteSpaceQuotaDefinitionRequest DeleteSpaceQuotaDefinitionRequest}.
     * @return An immutable instance of DeleteSpaceQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteSpaceQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteSpaceQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_QUOTA_DEFINITION_ID) != 0) attributes.add("spaceQuotaDefinitionId");
      return "Cannot build DeleteSpaceQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
