package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Creating a Space operation
 */
@Generated(from = "_CreateSpaceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateSpaceRequest extends org.cloudfoundry.client.v2.spaces._CreateSpaceRequest {
  private final @Nullable Boolean allowSsh;
  private final @Nullable List<String> auditorsIds;
  private final @Nullable List<String> developerIds;
  private final @Nullable List<String> domainIds;
  private final @Nullable List<String> managerIds;
  private final String name;
  private final String organizationId;
  private final @Nullable List<String> securityGroupIds;
  private final @Nullable String spaceQuotaDefinitionId;

  private CreateSpaceRequest(CreateSpaceRequest.Builder builder) {
    this.allowSsh = builder.allowSsh;
    this.auditorsIds = builder.auditorsIds == null ? null : createUnmodifiableList(true, builder.auditorsIds);
    this.developerIds = builder.developerIds == null ? null : createUnmodifiableList(true, builder.developerIds);
    this.domainIds = builder.domainIds == null ? null : createUnmodifiableList(true, builder.domainIds);
    this.managerIds = builder.managerIds == null ? null : createUnmodifiableList(true, builder.managerIds);
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.securityGroupIds = builder.securityGroupIds == null ? null : createUnmodifiableList(true, builder.securityGroupIds);
    this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
  }

  /**
   * Allow SSH
   */
  @JsonProperty("allow_ssh")
  @Override
  public @Nullable Boolean getAllowSsh() {
    return allowSsh;
  }

  /**
   * The auditor ids
   */
  @JsonProperty("auditor_guid")
  @Override
  public @Nullable List<String> getAuditorsIds() {
    return auditorsIds;
  }

  /**
   * The developer ids
   */
  @JsonProperty("developer_guid")
  @Override
  public @Nullable List<String> getDeveloperIds() {
    return developerIds;
  }

  /**
   * The domain ids
   */
  @JsonProperty("domain_guid")
  @Override
  public @Nullable List<String> getDomainIds() {
    return domainIds;
  }

  /**
   * The manager ids
   */
  @JsonProperty("manager_guid")
  @Override
  public @Nullable List<String> getManagerIds() {
    return managerIds;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @JsonProperty("organization_guid")
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The security group ids
   */
  @JsonProperty("security_group_guids")
  @Override
  public @Nullable List<String> getSecurityGroupIds() {
    return securityGroupIds;
  }

  /**
   * The space quota definition id
   */
  @JsonProperty("space_quota_definition_guid")
  @Override
  public @Nullable String getSpaceQuotaDefinitionId() {
    return spaceQuotaDefinitionId;
  }

  /**
   * This instance is equal to all instances of {@code CreateSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateSpaceRequest
        && equalTo(0, (CreateSpaceRequest) another);
  }

  private boolean equalTo(int synthetic, CreateSpaceRequest another) {
    return Objects.equals(allowSsh, another.allowSsh)
        && Objects.equals(auditorsIds, another.auditorsIds)
        && Objects.equals(developerIds, another.developerIds)
        && Objects.equals(domainIds, another.domainIds)
        && Objects.equals(managerIds, another.managerIds)
        && name.equals(another.name)
        && organizationId.equals(another.organizationId)
        && Objects.equals(securityGroupIds, another.securityGroupIds)
        && Objects.equals(spaceQuotaDefinitionId, another.spaceQuotaDefinitionId);
  }

  /**
   * Computes a hash code from attributes: {@code allowSsh}, {@code auditorsIds}, {@code developerIds}, {@code domainIds}, {@code managerIds}, {@code name}, {@code organizationId}, {@code securityGroupIds}, {@code spaceQuotaDefinitionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(allowSsh);
    h += (h << 5) + Objects.hashCode(auditorsIds);
    h += (h << 5) + Objects.hashCode(developerIds);
    h += (h << 5) + Objects.hashCode(domainIds);
    h += (h << 5) + Objects.hashCode(managerIds);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(securityGroupIds);
    h += (h << 5) + Objects.hashCode(spaceQuotaDefinitionId);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateSpaceRequest{"
        + "allowSsh=" + allowSsh
        + ", auditorsIds=" + auditorsIds
        + ", developerIds=" + developerIds
        + ", domainIds=" + domainIds
        + ", managerIds=" + managerIds
        + ", name=" + name
        + ", organizationId=" + organizationId
        + ", securityGroupIds=" + securityGroupIds
        + ", spaceQuotaDefinitionId=" + spaceQuotaDefinitionId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateSpaceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.spaces._CreateSpaceRequest {
    Boolean allowSsh;
    List<String> auditorsIds = null;
    List<String> developerIds = null;
    List<String> domainIds = null;
    List<String> managerIds = null;
    String name;
    String organizationId;
    List<String> securityGroupIds = null;
    String spaceQuotaDefinitionId;
    @JsonProperty("allow_ssh")
    public void setAllowSsh(@Nullable Boolean allowSsh) {
      this.allowSsh = allowSsh;
    }
    @JsonProperty("auditor_guid")
    public void setAuditorsIds(@Nullable List<String> auditorsIds) {
      this.auditorsIds = auditorsIds;
    }
    @JsonProperty("developer_guid")
    public void setDeveloperIds(@Nullable List<String> developerIds) {
      this.developerIds = developerIds;
    }
    @JsonProperty("domain_guid")
    public void setDomainIds(@Nullable List<String> domainIds) {
      this.domainIds = domainIds;
    }
    @JsonProperty("manager_guid")
    public void setManagerIds(@Nullable List<String> managerIds) {
      this.managerIds = managerIds;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("organization_guid")
    public void setOrganizationId(String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("security_group_guids")
    public void setSecurityGroupIds(@Nullable List<String> securityGroupIds) {
      this.securityGroupIds = securityGroupIds;
    }
    @JsonProperty("space_quota_definition_guid")
    public void setSpaceQuotaDefinitionId(@Nullable String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
    }
    @Override
    public Boolean getAllowSsh() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAuditorsIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getDeveloperIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getDomainIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getManagerIds() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSecurityGroupIds() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceQuotaDefinitionId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateSpaceRequest fromJson(Json json) {
    CreateSpaceRequest.Builder builder = CreateSpaceRequest.builder();
    if (json.allowSsh != null) {
      builder.allowSsh(json.allowSsh);
    }
    if (json.auditorsIds != null) {
      builder.addAllAuditorsIds(json.auditorsIds);
    }
    if (json.developerIds != null) {
      builder.addAllDeveloperIds(json.developerIds);
    }
    if (json.domainIds != null) {
      builder.addAllDomainIds(json.domainIds);
    }
    if (json.managerIds != null) {
      builder.addAllManagerIds(json.managerIds);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.securityGroupIds != null) {
      builder.addAllSecurityGroupIds(json.securityGroupIds);
    }
    if (json.spaceQuotaDefinitionId != null) {
      builder.spaceQuotaDefinitionId(json.spaceQuotaDefinitionId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateSpaceRequest CreateSpaceRequest}.
   * <pre>
   * CreateSpaceRequest.builder()
   *    .allowSsh(Boolean | null) // nullable {@link CreateSpaceRequest#getAllowSsh() allowSsh}
   *    .auditorsIds(List&amp;lt;String&amp;gt; | null) // nullable {@link CreateSpaceRequest#getAuditorsIds() auditorsIds}
   *    .developerIds(List&amp;lt;String&amp;gt; | null) // nullable {@link CreateSpaceRequest#getDeveloperIds() developerIds}
   *    .domainIds(List&amp;lt;String&amp;gt; | null) // nullable {@link CreateSpaceRequest#getDomainIds() domainIds}
   *    .managerIds(List&amp;lt;String&amp;gt; | null) // nullable {@link CreateSpaceRequest#getManagerIds() managerIds}
   *    .name(String) // required {@link CreateSpaceRequest#getName() name}
   *    .organizationId(String) // required {@link CreateSpaceRequest#getOrganizationId() organizationId}
   *    .securityGroupIds(List&amp;lt;String&amp;gt; | null) // nullable {@link CreateSpaceRequest#getSecurityGroupIds() securityGroupIds}
   *    .spaceQuotaDefinitionId(String | null) // nullable {@link CreateSpaceRequest#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId}
   *    .build();
   * </pre>
   * @return A new CreateSpaceRequest builder
   */
  public static CreateSpaceRequest.Builder builder() {
    return new CreateSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateSpaceRequest CreateSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateSpaceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x2L;
    private long initBits = 0x3L;

    private Boolean allowSsh;
    private List<String> auditorsIds = null;
    private List<String> developerIds = null;
    private List<String> domainIds = null;
    private List<String> managerIds = null;
    private String name;
    private String organizationId;
    private List<String> securityGroupIds = null;
    private String spaceQuotaDefinitionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateSpaceRequest instance) {
      return from((_CreateSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean allowSshValue = instance.getAllowSsh();
      if (allowSshValue != null) {
        allowSsh(allowSshValue);
      }
      List<String> auditorsIdsValue = instance.getAuditorsIds();
      if (auditorsIdsValue != null) {
        addAllAuditorsIds(auditorsIdsValue);
      }
      List<String> developerIdsValue = instance.getDeveloperIds();
      if (developerIdsValue != null) {
        addAllDeveloperIds(developerIdsValue);
      }
      List<String> domainIdsValue = instance.getDomainIds();
      if (domainIdsValue != null) {
        addAllDomainIds(domainIdsValue);
      }
      List<String> managerIdsValue = instance.getManagerIds();
      if (managerIdsValue != null) {
        addAllManagerIds(managerIdsValue);
      }
      name(instance.getName());
      organizationId(instance.getOrganizationId());
      List<String> securityGroupIdsValue = instance.getSecurityGroupIds();
      if (securityGroupIdsValue != null) {
        addAllSecurityGroupIds(securityGroupIdsValue);
      }
      String spaceQuotaDefinitionIdValue = instance.getSpaceQuotaDefinitionId();
      if (spaceQuotaDefinitionIdValue != null) {
        spaceQuotaDefinitionId(spaceQuotaDefinitionIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceRequest#getAllowSsh() allowSsh} attribute.
     * @param allowSsh The value for allowSsh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowSsh(@Nullable Boolean allowSsh) {
      this.allowSsh = allowSsh;
      return this;
    }

    /**
     * Adds one element to {@link CreateSpaceRequest#getAuditorsIds() auditorsIds} list.
     * @param element A auditorsIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorsId(String element) {
      if (this.auditorsIds == null) {
        this.auditorsIds = new ArrayList<String>();
      }
      this.auditorsIds.add(Objects.requireNonNull(element, "auditorsIds element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getAuditorsIds() auditorsIds} list.
     * @param elements An array of auditorsIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorsIds(String... elements) {
      if (this.auditorsIds == null) {
        this.auditorsIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditorsIds.add(Objects.requireNonNull(element, "auditorsIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateSpaceRequest#getAuditorsIds() auditorsIds} list.
     * @param elements An iterable of auditorsIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorsIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.auditorsIds = null;
        return this;
      }
      this.auditorsIds = new ArrayList<String>();
      return addAllAuditorsIds(elements);
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getAuditorsIds() auditorsIds} list.
     * @param elements An iterable of auditorsIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditorsIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "auditorsIds element");
      if (this.auditorsIds == null) {
        this.auditorsIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditorsIds.add(Objects.requireNonNull(element, "auditorsIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CreateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param element A developerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerId(String element) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param elements An array of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerIds(String... elements) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.developerIds = null;
        return this;
      }
      this.developerIds = new ArrayList<String>();
      return addAllDeveloperIds(elements);
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDeveloperIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "developerIds element");
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CreateSpaceRequest#getDomainIds() domainIds} list.
     * @param element A domainIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String element) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getDomainIds() domainIds} list.
     * @param elements An array of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(String... elements) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateSpaceRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domainIds = null;
        return this;
      }
      this.domainIds = new ArrayList<String>();
      return addAllDomainIds(elements);
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domainIds element");
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CreateSpaceRequest#getManagerIds() managerIds} list.
     * @param element A managerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerId(String element) {
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getManagerIds() managerIds} list.
     * @param elements An array of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerIds(String... elements) {
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateSpaceRequest#getManagerIds() managerIds} list.
     * @param elements An iterable of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.managerIds = null;
        return this;
      }
      this.managerIds = new ArrayList<String>();
      return addAllManagerIds(elements);
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getManagerIds() managerIds} list.
     * @param elements An iterable of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "managerIds element");
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Adds one element to {@link CreateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param element A securityGroupIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String element) {
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An array of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupIds(String... elements) {
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.securityGroupIds = null;
        return this;
      }
      this.securityGroupIds = new ArrayList<String>();
      return addAllSecurityGroupIds(elements);
    }

    /**
     * Adds elements to {@link CreateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSecurityGroupIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "securityGroupIds element");
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceRequest#getSpaceQuotaDefinitionId() spaceQuotaDefinitionId} attribute.
     * @param spaceQuotaDefinitionId The value for spaceQuotaDefinitionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuotaDefinitionId(@Nullable String spaceQuotaDefinitionId) {
      this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
      return this;
    }

    /**
     * Builds a new {@link CreateSpaceRequest CreateSpaceRequest}.
     * @return An immutable instance of CreateSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build CreateSpaceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
