package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Associate Route User Provided Service Instance
 */
@Generated(from = "_AssociateUserProvidedServiceInstanceRouteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class AssociateUserProvidedServiceInstanceRouteRequest
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._AssociateUserProvidedServiceInstanceRouteRequest {
  private final @Nullable Map<String, Object> parameters;
  private final String routeId;
  private final String userProvidedServiceInstanceId;

  private AssociateUserProvidedServiceInstanceRouteRequest(AssociateUserProvidedServiceInstanceRouteRequest.Builder builder) {
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.routeId = builder.routeId;
    this.userProvidedServiceInstanceId = builder.userProvidedServiceInstanceId;
  }

  /**
   * Key/value pairs to store credentials
   */
  @JsonProperty("parameters")
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The route id
   */
  @JsonProperty("routeId")
  @JsonIgnore
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * The user provided service instance id
   */
  @JsonProperty("userProvidedServiceInstanceId")
  @JsonIgnore
  @Override
  public String getUserProvidedServiceInstanceId() {
    return userProvidedServiceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateUserProvidedServiceInstanceRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateUserProvidedServiceInstanceRouteRequest
        && equalTo(0, (AssociateUserProvidedServiceInstanceRouteRequest) another);
  }

  private boolean equalTo(int synthetic, AssociateUserProvidedServiceInstanceRouteRequest another) {
    return Objects.equals(parameters, another.parameters)
        && routeId.equals(another.routeId)
        && userProvidedServiceInstanceId.equals(another.userProvidedServiceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code parameters}, {@code routeId}, {@code userProvidedServiceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(parameters);
    h += (h << 5) + routeId.hashCode();
    h += (h << 5) + userProvidedServiceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateUserProvidedServiceInstanceRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateUserProvidedServiceInstanceRouteRequest{"
        + "parameters=" + parameters
        + ", routeId=" + routeId
        + ", userProvidedServiceInstanceId=" + userProvidedServiceInstanceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_AssociateUserProvidedServiceInstanceRouteRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.userprovidedserviceinstances._AssociateUserProvidedServiceInstanceRouteRequest {
    Map<String, Object> parameters = null;
    String routeId;
    String userProvidedServiceInstanceId;
    @JsonProperty("parameters")
    public void setParameters(@Nullable Map<String, Object> parameters) {
      this.parameters = parameters;
    }
    @JsonProperty("routeId")
    @JsonIgnore
    public void setRouteId(String routeId) {
      this.routeId = routeId;
    }
    @JsonProperty("userProvidedServiceInstanceId")
    @JsonIgnore
    public void setUserProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
      this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
    }
    @Override
    public Map<String, Object> getParameters() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserProvidedServiceInstanceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static AssociateUserProvidedServiceInstanceRouteRequest fromJson(Json json) {
    AssociateUserProvidedServiceInstanceRouteRequest.Builder builder = AssociateUserProvidedServiceInstanceRouteRequest.builder();
    if (json.parameters != null) {
      builder.putAllParameters(json.parameters);
    }
    if (json.routeId != null) {
      builder.routeId(json.routeId);
    }
    if (json.userProvidedServiceInstanceId != null) {
      builder.userProvidedServiceInstanceId(json.userProvidedServiceInstanceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link AssociateUserProvidedServiceInstanceRouteRequest AssociateUserProvidedServiceInstanceRouteRequest}.
   * <pre>
   * AssociateUserProvidedServiceInstanceRouteRequest.builder()
   *    .parameters(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link AssociateUserProvidedServiceInstanceRouteRequest#getParameters() parameters}
   *    .routeId(String) // required {@link AssociateUserProvidedServiceInstanceRouteRequest#getRouteId() routeId}
   *    .userProvidedServiceInstanceId(String) // required {@link AssociateUserProvidedServiceInstanceRouteRequest#getUserProvidedServiceInstanceId() userProvidedServiceInstanceId}
   *    .build();
   * </pre>
   * @return A new AssociateUserProvidedServiceInstanceRouteRequest builder
   */
  public static AssociateUserProvidedServiceInstanceRouteRequest.Builder builder() {
    return new AssociateUserProvidedServiceInstanceRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateUserProvidedServiceInstanceRouteRequest AssociateUserProvidedServiceInstanceRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AssociateUserProvidedServiceInstanceRouteRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private static final long INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID = 0x2L;
    private long initBits = 0x3L;

    private Map<String, Object> parameters = null;
    private String routeId;
    private String userProvidedServiceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateUserProvidedServiceInstanceRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateUserProvidedServiceInstanceRouteRequest instance) {
      return from((_AssociateUserProvidedServiceInstanceRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateUserProvidedServiceInstanceRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateUserProvidedServiceInstanceRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      routeId(instance.getRouteId());
      userProvidedServiceInstanceId(instance.getUserProvidedServiceInstanceId());
      return this;
    }

    /**
     * Put one entry to the {@link AssociateUserProvidedServiceInstanceRouteRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link AssociateUserProvidedServiceInstanceRouteRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link AssociateUserProvidedServiceInstanceRouteRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link AssociateUserProvidedServiceInstanceRouteRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> entries) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.parameters.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserProvidedServiceInstanceRouteRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AssociateUserProvidedServiceInstanceRouteRequest#getUserProvidedServiceInstanceId() userProvidedServiceInstanceId} attribute.
     * @param userProvidedServiceInstanceId The value for userProvidedServiceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
      this.userProvidedServiceInstanceId = Objects.requireNonNull(userProvidedServiceInstanceId, "userProvidedServiceInstanceId");
      initBits &= ~INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateUserProvidedServiceInstanceRouteRequest AssociateUserProvidedServiceInstanceRouteRequest}.
     * @return An immutable instance of AssociateUserProvidedServiceInstanceRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateUserProvidedServiceInstanceRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateUserProvidedServiceInstanceRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      if ((initBits & INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID) != 0) attributes.add("userProvidedServiceInstanceId");
      return "Cannot build AssociateUserProvidedServiceInstanceRouteRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
