package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete User Provided Service Instance operation.
 */
@Generated(from = "_DeleteUserProvidedServiceInstanceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteUserProvidedServiceInstanceRequest
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._DeleteUserProvidedServiceInstanceRequest {
  private final String userProvidedServiceInstanceId;

  private DeleteUserProvidedServiceInstanceRequest(DeleteUserProvidedServiceInstanceRequest.Builder builder) {
    this.userProvidedServiceInstanceId = builder.userProvidedServiceInstanceId;
  }

  /**
   * The user provided service instance id
   */
  @Override
  public String getUserProvidedServiceInstanceId() {
    return userProvidedServiceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteUserProvidedServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteUserProvidedServiceInstanceRequest
        && equalTo(0, (DeleteUserProvidedServiceInstanceRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteUserProvidedServiceInstanceRequest another) {
    return userProvidedServiceInstanceId.equals(another.userProvidedServiceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code userProvidedServiceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + userProvidedServiceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteUserProvidedServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteUserProvidedServiceInstanceRequest{"
        + "userProvidedServiceInstanceId=" + userProvidedServiceInstanceId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteUserProvidedServiceInstanceRequest DeleteUserProvidedServiceInstanceRequest}.
   * <pre>
   * DeleteUserProvidedServiceInstanceRequest.builder()
   *    .userProvidedServiceInstanceId(String) // required {@link DeleteUserProvidedServiceInstanceRequest#getUserProvidedServiceInstanceId() userProvidedServiceInstanceId}
   *    .build();
   * </pre>
   * @return A new DeleteUserProvidedServiceInstanceRequest builder
   */
  public static DeleteUserProvidedServiceInstanceRequest.Builder builder() {
    return new DeleteUserProvidedServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteUserProvidedServiceInstanceRequest DeleteUserProvidedServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteUserProvidedServiceInstanceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private String userProvidedServiceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteUserProvidedServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteUserProvidedServiceInstanceRequest instance) {
      return from((_DeleteUserProvidedServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteUserProvidedServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteUserProvidedServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      userProvidedServiceInstanceId(instance.getUserProvidedServiceInstanceId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteUserProvidedServiceInstanceRequest#getUserProvidedServiceInstanceId() userProvidedServiceInstanceId} attribute.
     * @param userProvidedServiceInstanceId The value for userProvidedServiceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
      this.userProvidedServiceInstanceId = Objects.requireNonNull(userProvidedServiceInstanceId, "userProvidedServiceInstanceId");
      initBits &= ~INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteUserProvidedServiceInstanceRequest DeleteUserProvidedServiceInstanceRequest}.
     * @return An immutable instance of DeleteUserProvidedServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteUserProvidedServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteUserProvidedServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID) != 0) attributes.add("userProvidedServiceInstanceId");
      return "Cannot build DeleteUserProvidedServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
